#all Theophylline menu 
Theall.menu<-function()
{
 cat("\n")
  file.menu <- c("Aminophylline anhydrous",
                 "Aminophylline dihydrous",
                 "Oxtriphylline",
                 "Theophylline",
                 "Go back one upper level")
  pick <- menu(file.menu, title = "<< Theophylline Menu >>")
    if (pick == 1){
     cat("\n\n")
     Amianh.menu()
  } else {
    if (pick == 2){
      cat("\n\n") 
     Amidih.menu()
    } else {
    if (pick == 3){
      cat("\n\n") 
     Oxt.menu()
    }  else {
    if (pick == 4){
      cat("\n\n") 
     The.menu()
    } else {
    if (pick == 5){
      cat("\n\n") 
     run()
    }
    }
    }
    }
    }
    }
    
# Aminophylline anhydrous    
Amianh.menu <- function()                        #list of Aminophylline anhydrous input form  
{
  file.menu <- c("immdediate release",
                 "control release",
                 "iv infusion",
                 "Go back one upper level")
  pick <- menu(file.menu, title = "<< Aminophylline anhydrous input form menu >>")
  if (pick == 1){
     cat("\n\n")      
     Amianhir.model()
  } 
  else if (pick == 2){
     cat("\n\n") 
     Amianhcr.model()
  }         
  else if (pick == 3){
     cat("\n\n") 
     Amianhinfusion.model()
  }   
  else if (pick == 4){
     cat("\n\n") 
     Theall.menu()
  }      
}

# Aminophylline anhydrous immdediate release model          
Amianhir.model <- function()                                       #list of Aminophylline anhydrous IR data type               
{  
  file.menu <- c("single subj with single conc",               
                 "single subj with mutiple conc (sampling times must more than twice)",
                 "multiple subj with each single conc",
                 "multiple subj and mutiple conc (each subj's sampling times must more than twice)",
                 "Go back one upper level")
  pick <- menu(file.menu, title = "<< data type >>") 
  if (pick == 1){                                                                    # chosse single subject with single concentration                                                                   
     cat("\n")                                                                       # show input and output information make user convenience to use                                                                        
     cat("***********************************************************\n")
     cat("    --Aminophylline anhydrous IR input data information--  \n")
     cat("    Gender = Male=1 ; Female=0                             \n")
     cat("    age = age (yr)                                         \n")
     cat("    ht = height (cm)                                       \n") 
     cat("    CHF = 1 for yes ; otherwise = 0                        \n")
     cat("    smoke = 1 for a amoker ; otherwise 0                   \n") 
     cat("    D = dose for each dosing interval (mg)                 \n") 
     cat("    tau = dosing interval (hr)                             \n")
     cat("    ts = sampling time (hr)                                \n")   
     cat("    C = measured steady-state conc.                        \n")
     cat("***********************************************************\n\n")
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")       # tell user how to edit table of aminophylline anhydrous input data information
     cat("     window, and close Data Editor window by clicking           \n")    
     cat("           (x) button at upper right corner.                    \n\n")
     AmianhirSSpar<-data.frame(parameter=c("Gender","age (yr)","ht (cm)","CHF","smoke","D (mg)","tau (hr)","ts (hr)","c (mg/L)"),value=c(0))      # edit table of aminophylline anhydrous input data information                                               
     AmianhirSSpar<-edit(AmianhirSSpar)                                                                                                           # show table of aminophylline anhydrous input data information for user editing                                                                                                                                           
     AmianhirSSpar<-ycheck(AmianhirSSpar)                                                                                                         # avoid user missing input information
     cat("\n")                                                                                                                                    # Ť@
     Amianhir.ss(AmianhirSSpar[9,2],AmianhirSSpar[7,2],AmianhirSSpar[8,2],AmianhirSSpar[6,2],AmianhirSSpar[3,2],AmianhirSSpar[2,2],AmianhirSSpar[5,2],AmianhirSSpar[1,2],AmianhirSSpar[4,2])    # calculate individual aminophylline anhydrous PK parameters and show its prediction
     get(getOption("device"))()                                              # open a new window
     samplesHistory("*",mfrow=c(3,1), ask = FALSE)                           # show plots of history
     get(getOption("device"))()
     samplesDensity("*", mfrow = c(3, 2), ask = FALSE)                       # show plots of density
     get(getOption("device"))()
     samplesAutoC("*",1, mfrow = c(3, 2), ask = FALSE)                       # show plots of autocorrection
     cat("\n\n")
     cat("***********************************************************\n")    # show aminophylline anhydrous output data information
     cat("    --Aminophylline anhydrous IR output data information-- \n")
     cat("    cl_F = clerance/bioavailability (L/hr)                 \n")
     cat("    V_F = volume of distribution/bioavailability (L)       \n")
     cat("    Cmss_pr = predicted steady-state measured conc.(mg/L)  \n")
     cat("    Cpss_pr = predicted steady-state peak conc.(mg/L)      \n")
     cat("    Ctss_pr = predicted steady-state trough conc.(mg/L)    \n")
     cat("***********************************************************\n")
     show(samplesStats("*"))                                                 # show predicted PK parameters of aminophylline anhydrous 
     cat("\n") 
     C<-TheIRsscpr(0.85,AmianhirSSpar[6,2],AmianhirSSpar[7,2],AmianhirSSpar[8,2])     # calculate predicted steady-state measured concentration of aminophylline anhydrous (equation of _phylline IR concentration)
     sim<-matrix(C[1 ,1])                                                           # [1,1]
     coutput<-data.frame(sim)                                                       # RWҨXӪ[1,1]couput
     colnames(coutput)<-list("Cmss_pr (mg/L)")                                      # éRW쬰Cmss_pr(mg/L)
     output1<-coutput                                                               # NCmss_prRWcoutput1   
     show(coutput)                                                                  # show the concentration of aminophylline anhydrous  
     r=log(1.85-(samplesStats("cl_F")/samplesStats("v_F")))/(1.85-(samplesStats("cl_F")/samplesStats("v_F")))      # ptmax
     C<-TheIRsscpr(0.85,AmianhirSSpar[6,2],AmianhirSSpar[7,2],r)                                                     # calculate predicted steady-state peak concentration of aminophylline anhydrous
     sim<-matrix(C[1 ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Cpss_pr (mg/L)")                                                                     # éRW欰Cpss_pr(mg/L)
     output2<-coutput                                                                                              # NCmss_prRWcoutput2 
     show(coutput)
     C<-TheIRsscpr(0.85,AmianhirSSpar[6,2],AmianhirSSpar[7,2],AmianhirSSpar[7,2])                                    # calculate predicted steady-state trough concentration of aminophylline anhydrous
     sim<-matrix(C[1 ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Ctss_pr (mg/L)")                                                                     # éRW欰Ctss_pr(mg/L)
     output3<-coutput                                                                                              # NCmss_prRWcoutput3
     show(coutput)     
     cat("\n")    
     Amianhir.more(AmianhirSSpar,output1,output2,output3)                                           # calculate dose adjustment of Aminoflycoside with single subject single concentration                                    s                                                                                                                        
  } 
   else if (pick == 2){                                                                   # choose single subject with each multiple concentrations         
     cat("\n")                                                                       
     cat("***********************************************************\n")                 # show input and output information make user convenience to use 
     cat("    --Aminophylline anhydrous IR input data information--  \n")
     cat("    Gender = Male=1 ; Female=0                             \n")
     cat("    age = age (yr)                                         \n")
     cat("    ht = height (cm)                                       \n") 
     cat("    CHF = 1 for yes ; otherwise = 0                        \n")
     cat("    smoke = 1 for a amoker ; otherwise 0                   \n") 
     cat("    D = dose for each dosing interval (mg)                 \n") 
     cat("    tau = dosing interval (hr)                             \n")  
     cat("***********************************************************\n\n")
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     AmianhirSMMpar<-data.frame(parameter=c("Gender","age (yr)","ht (cm)","CHF","smoke","D (mg)","tau (hr)"),value=c(0))       # edit table of aminophylline anhydrous input data information except ts and conc 
     AmianhirSMMpar<-edit(AmianhirSMMpar)
     AmianhirSMMpar<-ycheck(AmianhirSMMpar)
     cat("\n")
     cat("***********************************************************\n")
     cat("    --Aminophylline anhydrous IR input data information--  \n")
     cat("    c = measured steady-state conc.(mg/L)                  \n")
     cat("    ts = sampling time since infusion end                  \n")
     cat("***********************************************************\n\n")
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     AmianhirSMpar<-data.frame(ts=c(0),conc=c(0))                                         # edit table of aminophylline anhydrous input data information including ts and conc (檺e{覡We{覡P)                                                                                                                                                   
     AmianhirSMpar<-edit(AmianhirSMpar)                                                   # show table of aminophylline anhydrous input data information for user editing                                            
     AmianhirSMpar<-mscheck(AmianhirSMpar)                                                # avoid user missing input information                                         
     cat("\n")
     Amianhir.sm(length(AmianhirSMpar$ts),AmianhirSMpar$conc,AmianhirSMpar$ts,AmianhirSMMpar[7,2],AmianhirSMMpar[6,2],AmianhirSMMpar[3,2],AmianhirSMMpar[2,2],AmianhirSMMpar[5,2],AmianhirSMMpar[1,2],AmianhirSMMpar[4,2])   # calculate individual aminophylline anhydrous PK parameters and show its prediction    
     get(getOption("device"))()
     samplesHistory("*",mfrow=c(3,1), ask = FALSE)
     get(getOption("device"))()
     samplesDensity("*", mfrow = c(3, 2), ask = FALSE)
     get(getOption("device"))()
     samplesAutoC("*",1, mfrow = c(3, 2), ask = FALSE)
     cat("\n\n")
     cat("***********************************************************\n")
     cat("    --Aminophylline anhydrous IR output data information-- \n")
     cat("    cl_F = clerance/bioavailability (L/hr)                 \n")
     cat("    V_F = volume of distribution/bioavailability (L)       \n")
     cat("    Cpss_pr = predicted steady-state peak conc.(mg/L)      \n")
     cat("    Ctss_pr = predicted steady-state trough conc.(mg/L)    \n")
     cat("***********************************************************\n")
     show(samplesStats("*"))
     cat("\n")
     C<-TheIRsscpr(0.85,AmianhirSMMpar[6,2],AmianhirSMMpar[7,2],AmianhirSMMpar[7,2])
     sim<-matrix(C[1 ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Ctss_pr (mg/L)")
     output1<-coutput
     show(coutput)     
     r=log(1.85-(samplesStats("cl_F")/samplesStats("v_F")))/(1.85-(samplesStats("cl_F")/samplesStats("v_F")))
     C<-TheIRsscpr(0.85,AmianhirSMMpar[6,2],AmianhirSMMpar[7,2],r)
     sim<-matrix(C[1 ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Cpss_pr (mg/L)")
     output2<-coutput
     show(coutput) 
     cat("\n")   
     Amianhirsm.more(AmianhirSMMpar,AmianhirSMpar,output1,output2)                # calculate dose adjustment of Aminoflycoside with single subject and each multiple concentrations                                                                                                                                                                                            
  } 
     else if (pick == 3){                                                                   # chosse multiple subjects with each single concentration
     rm(list=ls(all=TRUE))
 # show input and output information make user convenience to use 
     cat("\n")                                                                       
     cat("***********************************************************\n")
     cat("    --Aminophylline anhydrous IR input data information--  \n")
     cat("    Gender = Male=1 ; Female=0                             \n")
     cat("    age = age (yr)                                         \n")
     cat("    ht = height (cm)                                       \n") 
     cat("    CHF = 1 for yes ; otherwise = 0                        \n")
     cat("    smoke = 1 for a amoker ; otherwise 0                   \n") 
     cat("    D = dose for each dosing interval (mg)                 \n") 
     cat("    tau = dosing interval (hr)                             \n")
     cat("    ts = sampling time (hr)                                \n")   
     cat("    C = measured steady-state conc.                        \n")
     cat("***********************************************************\n\n")
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     AmianhirMSpar<-data.frame(subject=c(1,2),Gender=c(0),age=c(0),ht=c(0),CHF=c(0),smoke=c(0),D=c(0),tau=c(0),ts=c(0),c=c(0))
     AmianhirMSpar<-edit(AmianhirMSpar)
     AmianhirMSpar<-ymscheck(AmianhirMSpar)
     cat("\n")
     Amianhir.ms(length(AmianhirMSpar$subject),AmianhirMSpar$c,AmianhirMSpar$tau,AmianhirMSpar$ts,AmianhirMSpar$D,AmianhirMSpar$ht,AmianhirMSpar$age,AmianhirMSpar$smoke,AmianhirMSpar$Gender,AmianhirMSpar$CHF)   # calculate individual aminophylline anhydrous PK parameters and show its prediction
     cat("\n\n")
     cat("**********************************************************\n")
     cat("   You can PgUp/PgDown to scroll through your checking    \n")
     cat("   convergence plots.                                     \n")  
     cat("**********************************************************\n\n")
     options("graphics.record"=TRUE)
     samplesHistory("*",mfrow=c(3,1), ask = FALSE)
     samplesDensity("*", mfrow = c(3, 2), ask = FALSE)
     samplesAutoC("*",1, mfrow = c(3, 2), ask = FALSE)
     cat("\n\n")
     cat("***********************************************************\n")
     cat("    --Aminophylline anhydrous IR output data information-- \n")
     cat("    cl_F = clerance/bioavailability (L/hr)                 \n")
     cat("    V_F = volume of distribution/bioavailability (L)       \n")
     cat("    Cmss_pr = predicted steady-state measured conc.(mg/L)  \n")
     cat("    Cpss_pr = predicted steady-state peak conc.(mg/L)      \n")
     cat("    Ctss_pr = predicted steady-state trough conc.(mg/L)    \n")
     cat("***********************************************************\n")   
     show(samplesStats("*"))
     cat("\n")
     C<-TheIRsscpr(0.85,AmianhirMSpar$D,AmianhirMSpar$tau,AmianhirMSpar$ts)
     sim<-matrix(C[ ,1])                                                      # [ ,1]
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Cmss_pr (mg/L)")
     output1<-coutput
     show(coutput)
     r=log(1.85-(samplesStats("cl_F")/samplesStats("v_F")))/(1.85-(samplesStats("cl_F")/samplesStats("v_F")))
     C<-TheIRsscpr(0.85,AmianhirMSpar$D,AmianhirMSpar$tau,r)
     sim<-matrix(C[ ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Cpss_pr (mg/L)")
     output2<-coutput
     show(coutput)
     C<-TheIRsscpr(0.85,AmianhirMSpar$D,AmianhirMSpar$tau,AmianhirMSpar$tau)
     sim<-matrix(C[ ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Ctss_pr (mg/L)")
     output3<-coutput
     show(coutput)     
     cat("\n") 
     cat("          Pressing Enter to show individual summary report                  \n")
     readline()
     Amianhirms.pkoutput(AmianhirMSpar,output1,output2,output3)                                                                                                                                                                                                           
     cal.again()  
  } 
     else if (pick == 4){                                                                   # chosse multiple subjects with each multiple concentrations     
     cat("\n")                                                                       
     cat("***********************************************************\n")
     cat("    --Aminophylline anhydrous IR input data information--  \n")
     cat("    Gender = Male=1 ; Female=0                             \n")
     cat("    age = age (yr)                                         \n")
     cat("    ht = height (cm)                                       \n") 
     cat("    CHF = 1 for yes ; otherwise = 0                        \n")
     cat("    smoke = 1 for a amoker ; otherwise 0                   \n") 
     cat("    D = dose for each dosing interval (mg)                 \n") 
     cat("    tau = dosing interval (hr)                             \n")  
     cat("***********************************************************\n\n")
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     AmianhirMMpar<-data.frame(subject=c(1,2),Gender=c(0),age=c(0),ht=c(0),CHF=c(0),smoke=c(0),D=c(0),tau=c(0))      # edit table of aminophylline anhydrous input data information except ts and conc 
     AmianhirMMpar<-edit(AmianhirMMpar)
     AmianhirMMpar<-mscheck(AmianhirMMpar)
     cat("\n")
     cat("***********************************************************\n")
     cat("    --Aminophylline anhydrous IR input data information--  \n")
     cat("    c = measured steady-state conc.(mg/L)                  \n")
     cat("    ts = sampling time since infusion end                  \n")
     cat("***********************************************************\n\n")
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     AmianhirMMMpar<-data.frame(subject=c(1),ts=c(0),conc=c(0))                  # edit table of aminophylline anhydrous input data information including subject, ts and conc
     AmianhirMMMpar<-edit(AmianhirMMMpar)
     AmianhirMMMpar<-mscheck(AmianhirMMMpar)
     cat("\n")
     cat("***********************************************************\n")
     cat("    --Aminophylline anhydrous IR output data information-- \n")
     cat("    cl_F = clerance/bioavailability (L/hr)                 \n")
     cat("    V_F = volume of distribution/bioavailability (L)       \n")
     cat("    Cpss_pr = predicted steady-state peak conc.(mg/L)     \n")
     cat("    Ctss_pr = predicted steady-state trough conc.(mg/L)   \n")
     cat("***********************************************************\n\n")
     for(i in 1:length(unique(AmianhirMMpar$subject))){          # Loop, FphHhIѼ(ܭp@ӤH)
     a=length(AmianhirMMMpar$ts[AmianhirMMMpar$subject==i])        # a=number of sampling time of subject[i]
     b=AmianhirMMMpar$conc[AmianhirMMMpar$subject==i]             # b=concentration of subject[i]
     C=AmianhirMMMpar$ts[AmianhirMMMpar$subject==i]               # c=sampling time of subject[i]
     d=AmianhirMMpar$tau[AmianhirMMpar$subject==i]                # d=dosing interval of subject[i]
     e=AmianhirMMpar$D[AmianhirMMpar$subject==i]                  # e=dose of subject[i]
     f=AmianhirMMpar$ht[AmianhirMMpar$subject==i]                 # f=height of subject[i]
     g=AmianhirMMpar$age[AmianhirMMpar$subject==i]                # g=age of subject[i]
     h=AmianhirMMpar$smoke[AmianhirMMpar$subject==i]              # h=subject[i]O_
     l=AmianhirMMpar$Gender[AmianhirMMpar$subject==i]             # l=Gender of subject[i]
     J=AmianhirMMpar$CHF[AmianhirMMpar$subject==i]                # J=subject[i]ϧ_CHF
     Amianhir.mm(a,b,C,d,e,f,g,h,l,J,i)                           # calculate individual aminophylline anhydrous PK parameters and show its prediction
     cat("\n")
     cat("**************************************************************************\n")
     cat("                 << Subject",i,">>                           \n\n" )
     cat("cl_F = clerance/bioavailability (L/hr)                         \n")
     cat("v_F = volume of distribution/bioavailability (L)               \n\n")
     windows()
     samplesHistory("*",mfrow=c(3,1),ask=FALSE)
     windows()
     samplesDensity("*",mfrow=c(3,2),ask=FALSE)
     windows()
     samplesAutoC("*",1,mfrow=c(3,2),ask=FALSE)
     show(samplesStats("*"))
     cat("\n")
     r=log(1.85-(samplesStats("cl_F")/samplesStats("v_F")))/(1.85-(samplesStats("cl_F")/samplesStats("v_F")))
     C<-TheIRsscpr(0.85,e,d,r)
     sim<-matrix(C[1 ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Ctss_pr (mg/L)")
     show(coutput)  
     C<-TheIRsscpr(0.85,e,d,d)
     sim<-matrix(C[1 ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Ctss_pr (mg/L)")
     show(coutput)     
     cat("\n**************************************************************************\n")
     }
     cal.again()         # ask user does he want to calculate another drug again?
  } 
  else if (pick == 5){   # go back to upper layer
     cat("\n\n") 
     Amianh.menu()
  }      
}


# 2 
# Aminophylline anhydrous control release model
Amianhcr.model <- function()
{
  file.menu <- c("single subj with single conc",                 
                 "multiple subj with each single conc",
                 "Go back one upper level")
  pick <- menu(file.menu, title = "<< data type >>") 
  if (pick == 1){                                                                    
     cat("\n")                                                                      
     cat("***********************************************************\n")
     cat("    --Aminophylline anhydrous CR input data information--  \n")
     cat("    Gender = Male=1 ; Female=0                             \n")
     cat("    age = age (yr)                                         \n")
     cat("    ht = height (cm)                                       \n") 
     cat("    CHF = 1 for yes ; otherwise = 0                        \n")
     cat("    smoke = 1 for a amoker ; otherwise 0                   \n") 
     cat("    D = dose for each dosing interval (mg)                 \n") 
     cat("    tau = dosing interval (hr)                             \n")
     cat("    C = measured steady-state conc.                        \n")
     cat("***********************************************************\n\n")
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     AmianhcrSSpar<-data.frame(parameter=c("Gender","age (yr)","ht (cm)","CHF","smoke","D (mg)","tau (hr)","c (mg/L)"),value=c(0))                                            
     AmianhcrSSpar<-edit(AmianhcrSSpar)                                                                                                                                           
     AmianhcrSSpar<-ycheck(AmianhcrSSpar)       
     cat("\n")                                                                                                                         
     Amianhcr.ss(AmianhcrSSpar[8,2],AmianhcrSSpar[7,2],AmianhcrSSpar[6,2],AmianhcrSSpar[3,2],AmianhcrSSpar[2,2],AmianhcrSSpar[5,2],AmianhcrSSpar[1,2],AmianhcrSSpar[4,2])
     get(getOption("device"))()
     samplesHistory("*",mfrow=c(3,1), ask = FALSE)
     get(getOption("device"))()
     samplesDensity("*", mfrow = c(3, 2), ask = FALSE)
     get(getOption("device"))()
     samplesAutoC("*",1, mfrow = c(3, 2), ask = FALSE)
     cat("\n\n")
     cat("***********************************************************\n")
     cat("   --Aminophylline anhydrous CR output data information-- \n")
     cat("   cl_F = clerance/bioavailability (L/hr)                 \n")
     cat("   Css_pr = predicted steady-state conc.(mg/L)            \n")
     cat("***********************************************************\n")
     show(samplesStats("*"))
     cat("\n") 
     C<-TheCRcpr(0.85,AmianhcrSSpar[6,2],AmianhcrSSpar[7,2])
     sim<-matrix(C[1 ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Css_pr (mg/L)")    
     show(coutput) 
     cat("\n")   
     Amianhcr.more(AmianhcrSSpar,coutput)                                                                                                                                                              
  } 
    else if (pick == 2){
     rm(list=ls(all=TRUE))
     cat("\n")                                                                      
     cat("***********************************************************\n")
     cat("    --Aminophylline anhydrous CR input data information--  \n")
     cat("    Gender = Male=1 ; Female=0                             \n")
     cat("    age = age (yr)                                         \n")
     cat("    ht = height (cm)                                       \n") 
     cat("    CHF = 1 for yes ; otherwise = 0                        \n")
     cat("    smoke = 1 for a amoker ; otherwise 0                   \n") 
     cat("    D = dose for each dosing interval (mg)                 \n") 
     cat("    tau = dosing interval (hr)                             \n")
     cat("    C = measured steady-state conc.                        \n")
     cat("***********************************************************\n\n")
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     AmianhcrMSpar<-data.frame(subject=c(1,2),Gender=c(0),age=c(0),ht=c(0),CHF=c(0),smoke=c(0),D=c(0),tau=c(0),c=c(0))
     AmianhcrMSpar<-edit(AmianhcrMSpar)
     AmianhcrMSpar<-ymscheck(AmianhcrMSpar)
     cat("\n")
     Amianhcr.ms(length(AmianhcrMSpar$subject),AmianhcrMSpar$c,AmianhcrMSpar$tau,AmianhcrMSpar$D,AmianhcrMSpar$ht,AmianhcrMSpar$age,AmianhcrMSpar$smoke,AmianhcrMSpar$Gender,AmianhcrMSpar$CHF)
     cat("\n\n")
     cat("**********************************************************\n")
     cat("   You can PgUp/PgDown to scroll through your checking    \n")
     cat("   convergence plots.                                     \n")  
     cat("**********************************************************\n\n")
     options("graphics.record"=TRUE)
     samplesHistory("*",mfrow=c(3,1), ask = FALSE)
     samplesDensity("*", mfrow = c(3, 2), ask = FALSE)
     samplesAutoC("*",1, mfrow = c(3, 2), ask = FALSE)
     cat("***********************************************************\n")
     cat("    --Aminophylline anhydrous CR output data information-- \n")
     cat("    cl_F = clerance/bioavailability (L/hr)                 \n")
     cat("    Css_pr = predicted steady-state conc.(mg/L)            \n")
     cat("***********************************************************\n")    
     show(samplesStats("*"))
     cat("\n")
     C<-TheCRcpr(0.85,AmianhcrMSpar$D,AmianhcrMSpar$tau)
     sim<-matrix(C[ ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Css_pr (mg/L)")     
     show(coutput)
     cat("\n")
     cat("          Pressing Enter to show individual summary report                  \n")
     readline()
     Amianhcrms.pkoutput(AmianhcrMSpar,coutput)
     cal.again()                                                                                                                                                                               
  } 
  else if (pick == 3){
     cat("\n\n") 
     Amianh.menu()
  }      
}


Amianhinfusion.model <- function()
{
  file.menu <- c("single subj with single conc",               
                 "single subj with mutiple conc (sampling times must more than twice)",
                 "multiple subj with each single conc",
                 "multiple subj and mutiple conc (each subj's sampling times must more than twice)",
                 "Go back one upper level")
  pick <- menu(file.menu, title = "<< data type >>") 
  if (pick == 1){                                                                    
     cat("\n")                                                                      
     cat("********************************************************************\n")
     cat("    --Aminophylline anhydrous iv infusion input data information--  \n")
     cat("    Gender = Male=1 ; Female=0                             \n")
     cat("    age = age (yr)                                         \n")
     cat("    ht = height (cm)                                       \n") 
     cat("    CHF = 1 for yes ; otherwise = 0                        \n")
     cat("    smoke = 1 for a amoker ; otherwise 0                   \n") 
     cat("    DL = loading dose (mg)                                 \n")
     cat("    tinf = infusion time of loading dose (hr)              \n") 
     cat("    R = constant intravenous infusion rate (mg/hr)         \n") 
     cat("    ts = sampling time since infusion end (hr)             \n")
     cat("    C = measured conc. (mg/L)                             \n")
     cat("********************************************************************\n\n")                                                              
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     AmianhinfusionSSpar<-data.frame(parameter=c("Gender","age (yr)","ht (cm)","CHF","smoke","DL (mg)","tinf (hr)","R (mg/hr)","ts (hr)","c (mg/L)"),value=c(0))                                                                                                          
     AmianhinfusionSSpar<-edit(AmianhinfusionSSpar)                                                                                                                                                                                                             
     AmianhinfusionSSpar<-ycheck(AmianhinfusionSSpar)     
     cat("\n")
     Amianhinfusion.ss(AmianhinfusionSSpar[10,2],AmianhinfusionSSpar[9,2],AmianhinfusionSSpar[3,2],AmianhinfusionSSpar[2,2],AmianhinfusionSSpar[5,2],AmianhinfusionSSpar[1,2],AmianhinfusionSSpar[4,2],AmianhinfusionSSpar[6,2],AmianhinfusionSSpar[8,2],AmianhinfusionSSpar[7,2])
     get(getOption("device"))()
     samplesHistory("*",mfrow=c(3,1), ask = FALSE)
     get(getOption("device"))()
     samplesDensity("*", mfrow = c(3, 2), ask = FALSE)
     get(getOption("device"))()
     samplesAutoC("*",1, mfrow = c(3, 2), ask = FALSE)
     cat("\n\n")
     cat("*********************************************************************\n") 
     cat("   --Aminophylline anhydrous iv infusion output data information-- \n")
     cat("   cl = clerance (L/hr)                 \n")
     cat("   v = volume of distribution (L)       \n")
     cat("   Cm_pr = predicted measured conc.(mg/L)   \n")
     cat("   Ctss_pr = predicted steady-state trough conc.(mg/L)     \n")
     cat("*********************************************************************\n")   
     show(samplesStats("*"))                                                                                                                                                                                                            
     cat("\n")
     C<-Theinfusioncpr(0.85,AmianhinfusionSSpar[6,2],AmianhinfusionSSpar[8,2],AmianhinfusionSSpar[9,2],AmianhinfusionSSpar[7,2])
     sim<-matrix(C[1,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Cm_pr (mg/L)")    
     coutput1<-coutput 
     show(coutput)
     C<-0.85*AmianhinfusionSSpar[8,2]/(samplesStats("cl"))
     sim<-matrix(C[1,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Ctss_pr (mg/L)")  
     coutput2<-coutput   
     show(coutput)
     cat("\n")   
     Amianhinfusion.more(AmianhinfusionSSpar,coutput1,coutput2)                                                                                                                                                                                                                                                  
   } 
   else if (pick == 2){     
     cat("\n")                                                                       
     cat("*********************************************************************\n")
     cat("    --Aminophylline anhydrous iv infusion input data information--  \n")
     cat("    Gender = Male=1 ; Female=0                             \n")
     cat("    age = age (yr)                                         \n")
     cat("    ht = height (cm)                                       \n") 
     cat("    CHF = 1 for yes ; otherwise = 0                        \n")
     cat("    smoke = 1 for a amoker ; otherwise 0                   \n") 
     cat("    DL = loading dose (mg)                                 \n")
     cat("    tinf = infusion time of loading dose (hr)              \n") 
     cat("    R = constant intravenous infusion rate (mg/hr)         \n") 
     cat("*********************************************************************\n\n")                                                              
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     AmianhinfusionSMMpar<-data.frame(parameter=c("Gender","age (yr)","ht (cm)","CHF","smoke","DL (mg)","tinf (hr)","R (mg/hr)"),value=c(0))
     AmianhinfusionSMMpar<-edit(AmianhinfusionSMMpar)
     AmianhinfusionSMMpar<-ycheck(AmianhinfusionSMMpar)
     cat("\n")
     cat("******************************************************************\n")
     cat("    --Aminophylline anhydrous infusion input data information--  \n")
     cat("    c = measured conc.(mg/L)                  \n")
     cat("    ts = sampling time since infusion end                  \n")
     cat("******************************************************************\n\n")
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     AmianhinfusionSMpar<-data.frame(ts=c(0),conc=c(0))                                                                                                                            
     AmianhinfusionSMpar<-edit(AmianhinfusionSMpar)                                            
     AmianhinfusionSMpar<-mscheck(AmianhinfusionSMpar)                                         
     cat("\n")
     Amianhinfusion.sm(length(AmianhinfusionSMpar$ts),AmianhinfusionSMpar$conc,AmianhinfusionSMpar$ts,AmianhinfusionSMMpar[3,2],AmianhinfusionSMMpar[2,2],AmianhinfusionSMMpar[5,2],AmianhinfusionSMMpar[1,2],AmianhinfusionSMMpar[4,2],AmianhinfusionSMMpar[6,2],AmianhinfusionSMMpar[8,2],AmianhinfusionSMMpar[7,2])
     get(getOption("device"))()
     samplesHistory("*",mfrow=c(3,1), ask = FALSE)
     get(getOption("device"))()
     samplesDensity("*", mfrow = c(3, 2), ask = FALSE)
     get(getOption("device"))()
     samplesAutoC("*",1, mfrow = c(3, 2), ask = FALSE)
     cat("\n\n")
     cat("********************************************************************\n")
     cat("    --Aminophylline anhydrous infusion output data information-- \n")
     cat("    cl = clerance(L/hr)                 \n")
     cat("    V = volume of distribution (L)       \n")
     cat("    Ctss_pr = predicted steady-state trough conc.(mg/L)    \n")
     cat("********************************************************************\n")
     show(samplesStats("*"))
     cat("\n")
     C<-0.85*AmianhinfusionSMMpar[8,2]/(samplesStats("cl"))
     sim<-matrix(C[1 ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Ctss_pr (mg/L)")
     show(coutput)     
     cat("\n")   
     Amianhinfusionsm.more(AmianhinfusionSMMpar,AmianhinfusionSMpar,coutput)                                                                                                                                                                                            
  } 
     else if (pick == 3){
      rm(list=ls(all=TRUE))
     cat("\n")                                                                      
     cat("*********************************************************************\n\n")
     cat("    --Aminophylline anhydrous iv infusion input data information--  \n")
     cat("    Gender = Male=1 ; Female=0                             \n")
     cat("    age = age (yr)                                         \n")
     cat("    ht = height (cm)                                       \n") 
     cat("    CHF = 1 for yes ; otherwise = 0                        \n")
     cat("    smoke = 1 for a amoker ; otherwise 0                   \n") 
     cat("    DL = loading dose (mg)                                 \n") 
     cat("    tinf = infusion time of loading dose (hr)              \n") 
     cat("    R = constant intravenous infusion rate (mg/hr)         \n") 
     cat("    ts = sampling time since infusion end (hr)           \n")
     cat("    C = measured conc. (mg/L)                              \n")
     cat("*********************************************************************\n\n")
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     AmianhinfusionMSpar<-data.frame(subject=c(1,2),Gender=c(0),age=c(0),ht=c(0),CHF=c(0),smoke=c(0),DL=c(0),tinf=c(0),R=c(0),ts=c(0),c=c(0))
     AmianhinfusionMSpar<-edit(AmianhinfusionMSpar)
     AmianhinfusionMSpar<-ymscheck(AmianhinfusionMSpar)
     cat("\n")
     Amianhinfusion.ms(length(AmianhinfusionMSpar$subject),AmianhinfusionMSpar$c,AmianhinfusionMSpar$ts,AmianhinfusionMSpar$ht,AmianhinfusionMSpar$age,AmianhinfusionMSpar$smoke,AmianhinfusionMSpar$Gender,AmianhinfusionMSpar$CHF,AmianhinfusionMSpar$DL,AmianhinfusionMSpar$R,AmianhinfusionMSpar$tinf)
     cat("\n\n")
     cat("**********************************************************\n")
     cat("   You can PgUp/PgDown to scroll through your checking    \n")
     cat("   convergence plots.                                     \n")  
     cat("**********************************************************\n\n")
     options("graphics.record"=TRUE)
     samplesHistory("*",mfrow=c(3,1), ask = FALSE)
     samplesDensity("*", mfrow = c(3, 2), ask = FALSE)
     samplesAutoC("*",1, mfrow = c(3, 2), ask = FALSE)
     cat("***********************************************************************\n") 
     cat("    --Aminophylline anhydrous iv infusion output data information-- \n")
     cat("    cl = clerance (L/hr)                 \n")
     cat("    v = volume of distribution (L)       \n")
     cat("    Cm_pr = predicted measured conc.(mg/L)   \n")
     cat("    Ctss_pr = predicted steady-state trough conc.(mg/L)     \n")
     cat("***********************************************************************\n")       
     show(samplesStats("*"))
     cat("\n")
     C<-Theinfusioncpr(0.85,AmianhinfusionMSpar$DL,AmianhinfusionMSpar$R,AmianhinfusionMSpar$ts,AmianhinfusionMSpar$tinf)
     sim<-matrix(C[ ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Cm_pr (mg/L)")   
     coutput1<-coutput  
     show(coutput)
     C<-0.85*AmianhinfusionMSpar$R/(samplesStats("cl"))
     sim<-matrix(C[ ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Ctss_pr (mg/L)")     
     coutput2<-coutput
     show(coutput)
     cat("\n")  
     cat("          Pressing Enter to show individual summary report                  \n")
     readline()
     Amianhinfusionms.pkoutput(AmianhinfusionMSpar,coutput1,coutput2)  
     cal.again()                                                                                                                                                            
  } 
     else if (pick == 4){     
     cat("\n")                                                                       
     cat("*******************************************************************\n")
     cat("    --Aminophylline anhydrous infusion input data information--  \n")
     cat("    Gender = Male=1 ; Female=0                             \n")
     cat("    age = age (yr)                                         \n")
     cat("    ht = height (cm)                                       \n") 
     cat("    CHF = 1 for yes ; otherwise = 0                        \n")
     cat("    smoke = 1 for a amoker ; otherwise 0                   \n") 
     cat("    DL = loading dose (mg)                                 \n")
     cat("    tinf = infusion time of loading dose (hr)              \n") 
     cat("    R = constant intravenous infusion rate (mg/hr)         \n") 
     cat("*******************************************************************\n\n")
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     AmianhinfusionMMpar<-data.frame(subject=c(1,2),Gender=c(0),age=c(0),ht=c(0),CHF=c(0),smoke=c(0),DL=c(0),tinf=c(0),R=c(0))
     AmianhinfusionMMpar<-edit(AmianhinfusionMMpar)
     AmianhinfusionMMpar<-mscheck(AmianhinfusionMMpar)
     cat("\n")
     cat("********************************************************************\n")
     cat("    --Aminophylline anhydrous infusion input data information--  \n")
     cat("    c = measured steady-state conc.(mg/L)                  \n")
     cat("    ts = sampling time since infusion end                  \n")
     cat("********************************************************************\n\n")
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     AmianhinfusionMMMpar<-data.frame(subject=c(1),ts=c(0),conc=c(0))
     AmianhinfusionMMMpar<-edit(AmianhinfusionMMMpar)
     AmianhinfusionMMMpar<-mscheck(AmianhinfusionMMMpar)
     for(i in 1:length(unique(AmianhinfusionMMpar$subject))){
     a=length(AmianhinfusionMMMpar$ts[AmianhinfusionMMMpar$subject==i])
     b=AmianhinfusionMMMpar$conc[AmianhinfusionMMMpar$subject==i]
     C=AmianhinfusionMMMpar$ts[AmianhinfusionMMMpar$subject==i]
     e=AmianhinfusionMMpar$DL[AmianhinfusionMMpar$subject==i]
     k=AmianhinfusionMMpar$R[AmianhinfusionMMpar$subject==i]
     m=AmianhinfusionMMpar$tinf[AmianhinfusionMMpar$subject==i]
     f=AmianhinfusionMMpar$ht[AmianhinfusionMMpar$subject==i]
     g=AmianhinfusionMMpar$age[AmianhinfusionMMpar$subject==i]
     h=AmianhinfusionMMpar$smoke[AmianhinfusionMMpar$subject==i]
     l=AmianhinfusionMMpar$Gender[AmianhinfusionMMpar$subject==i]
     J=AmianhinfusionMMpar$CHF[AmianhinfusionMMpar$subject==i]
     Amianhinfusion.mm(a,i,b,C,f,g,h,l,J,e,k,m)
     cat("\n")
     cat("**************************************************************************\n")
     cat("                 << Subject",i,">>                           \n\n" )
     cat("cl = clerance (L/hr)                         \n")
     cat("v = volume of distribution (L)               \n")
     cat("Ctss_pr = predicted steady-state trough conc.(mg/L)    \n\n")
     windows()
     samplesHistory("*",mfrow=c(3,1),ask=FALSE)
     windows()
     samplesDensity("*",mfrow=c(3,2),ask=FALSE)
     windows()
     samplesAutoC("*",1,mfrow=c(3,2),ask=FALSE)
     show(samplesStats("*"))
     cat("\n")
     C<-0.85*k/(samplesStats("cl"))
     sim<-matrix(C[1 ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Ctss_pr (mg/L)")
     show(coutput)     
     cat("\n**************************************************************************\n")
     }
     cal.again()
  } 
  else if (pick == 5){
     cat("\n\n") 
     Amianh.menu()
  }      
}


# Aminophylline dihydrous
Amidih.menu <- function()
{
  file.menu <- c("immdediate release",
                 "control release",
                 "iv infusion",
                 "Go back one upper level")
  pick <- menu(file.menu, title = "<< Aminophylline dihydrous input form menu >>")
  if (pick == 1){
     cat("\n\n")      
     Amidihir.model()
  } 
  else if (pick == 2){
     cat("\n\n") 
     Amidihcr.model()
  }         
  else if (pick == 3){
     cat("\n\n") 
     Amidihinfusion.model()
  }   
  else if (pick == 4){
     cat("\n\n") 
     Theall.menu()
  }      
}


# Aminophylline dihydrous immdediate release model
Amidihir.model <- function()
{
  file.menu <- c("single subj with single conc",               
                 "single subj with mutiple conc (sampling times must more than twice)",
                 "multiple subj with each single conc",
                 "multiple subj and mutiple conc (each subj's sampling times must more than twice)",
                 "Go back one upper level")
  pick <- menu(file.menu, title = "<< data type >>") 
  if (pick == 1){                                                                    
     cat("\n")                                                                       
     cat("***********************************************************\n")
     cat("    --Aminophylline dihydrous IR input data information--  \n")
     cat("    Gender = Male=1 ; Female=0                             \n")
     cat("    age = age (yr)                                         \n")
     cat("    ht = height (cm)                                       \n") 
     cat("    CHF = 1 for yes ; otherwise = 0                        \n")
     cat("    smoke = 1 for a amoker ; otherwise 0                   \n") 
     cat("    D = dose for each dosing interval (mg)                 \n") 
     cat("    tau = dosing interval (hr)                             \n")
     cat("    ts = sampling time (hr)                                \n")   
     cat("    C = measured steady-state conc.                        \n")
     cat("***********************************************************\n\n")
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     AmidihirSSpar<-data.frame(parameter=c("Gender","age (yr)","ht (cm)","CHF","smoke","D (mg)","tau (hr)","ts (hr)","c (mg/L)"),value=c(0))                                            
     AmidihirSSpar<-edit(AmidihirSSpar)                                                                                                                                           
     AmidihirSSpar<-ycheck(AmidihirSSpar)    
     cat("\n")                                                                                                                                                                                                                                                                        
     Amidihir.ss(AmidihirSSpar[9,2],AmidihirSSpar[7,2],AmidihirSSpar[8,2],AmidihirSSpar[6,2],AmidihirSSpar[3,2],AmidihirSSpar[2,2],AmidihirSSpar[5,2],AmidihirSSpar[1,2],AmidihirSSpar[4,2])
     get(getOption("device"))()
     samplesHistory("*",mfrow=c(3,1), ask = FALSE)
     get(getOption("device"))()
     samplesDensity("*", mfrow = c(3, 2), ask = FALSE)
     get(getOption("device"))()
     samplesAutoC("*",1, mfrow = c(3, 2), ask = FALSE)
     cat("\n\n")
     cat("***********************************************************\n") 
     cat("    --Aminophylline dihydrous IR output data information-- \n")
     cat("    cl_F = clerance/bioavailability (L/hr)                 \n")
     cat("    V_F = volume of distribution/bioavailability (L)       \n")
     cat("    Cmss_pr = predicted steady-state measured conc.(mg/L) \n")
     cat("    Cpss_pr = predicted steady-state peak conc.(mg/L)     \n")
     cat("    Ctss_pr = predicted steady-state trough conc.(mg/L)   \n")
     cat("***********************************************************\n")     
     show(samplesStats("*"))
     cat("\n") 
     C<-TheIRsscpr(0.8,AmidihirSSpar[6,2],AmidihirSSpar[7,2],AmidihirSSpar[8,2])
     sim<-matrix(C[1 ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Cmss_pr (mg/L)")
     output1<-coutput
     show(coutput)
     r=log(1.85-(samplesStats("cl_F")/samplesStats("v_F")))/(1.85-(samplesStats("cl_F")/samplesStats("v_F")))
     C<-TheIRsscpr(0.8,AmidihirSSpar[6,2],AmidihirSSpar[7,2],r)
     sim<-matrix(C[1 ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Cpss_pr (mg/L)")
     output2<-coutput
     show(coutput)
     C<-TheIRsscpr(0.8,AmidihirSSpar[6,2],AmidihirSSpar[7,2],AmidihirSSpar[7,2])
     sim<-matrix(C[1 ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Ctss_pr (mg/L)")
     output3<-coutput
     show(coutput)     
     cat("\n")   
     Amidihir.more(AmidihirSSpar,output1,output2,output3)                                                                                                                                                             
  } 
   else if (pick == 2){     
     cat("\n")                                                                       
     cat("***********************************************************\n")
     cat("    --Aminophylline dihydrous IR input data information--  \n")
     cat("    Gender = Male=1 ; Female=0                             \n")
     cat("    age = age (yr)                                         \n")
     cat("    ht = height (cm)                                       \n") 
     cat("    CHF = 1 for yes ; otherwise = 0                        \n")
     cat("    smoke = 1 for a amoker ; otherwise 0                   \n") 
     cat("    D = dose for each dosing interval (mg)                 \n") 
     cat("    tau = dosing interval (hr)                             \n")  
     cat("***********************************************************\n\n")
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     AmidihirSMMpar<-data.frame(parameter=c("Gender","age (yr)","ht (cm)","CHF","smoke","D (mg)","tau (hr)"),value=c(0))
     AmidihirSMMpar<-edit(AmidihirSMMpar)
     AmidihirSMMpar<-ycheck(AmidihirSMMpar)
     cat("\n")
     cat("***********************************************************\n")
     cat("    --Aminophylline dihydrous IR input data information--  \n")
     cat("    c = measured steady-state conc.(mg/L)                   \n")
     cat("    ts = sampling time since infusion end                  \n")
     cat("***********************************************************\n\n")
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     AmidihirSMpar<-data.frame(ts=c(0),conc=c(0))                                                                                                                             
     AmidihirSMpar<-edit(AmidihirSMpar)                                            
     AmidihirSMpar<-mscheck(AmidihirSMpar)                                         
     cat("\n")
     Amidihir.sm(length(AmidihirSMpar$ts),AmidihirSMpar$conc,AmidihirSMpar$ts,AmidihirSMMpar[7,2],AmidihirSMMpar[6,2],AmidihirSMMpar[3,2],AmidihirSMMpar[2,2],AmidihirSMMpar[5,2],AmidihirSMMpar[1,2],AmidihirSMMpar[4,2])
     get(getOption("device"))()
     samplesHistory("*",mfrow=c(3,1), ask = FALSE)
     get(getOption("device"))()
     samplesDensity("*", mfrow = c(3, 2), ask = FALSE)
     get(getOption("device"))()
     samplesAutoC("*",1, mfrow = c(3, 2), ask = FALSE)
     cat("\n\n")
     cat("***********************************************************\n")
     cat("    --Aminophylline dihydrous IR output data information-- \n")
     cat("    cl_F = clerance/bioavailability (L/hr)                 \n")
     cat("    V_F = volume of distribution/bioavailability (L)       \n")
     cat("    Cpss_pr = predicted steady-state peak conc.(mg/L)      \n")
     cat("    Ctss_pr = predicted steady-state trough conc.(mg/L)    \n")
     cat("***********************************************************\n")
     show(samplesStats("*"))
     cat("\n")
     r=log(1.85-(samplesStats("cl_F")/samplesStats("v_F")))/(1.85-(samplesStats("cl_F")/samplesStats("v_F")))
     C<-TheIRsscpr(0.8,AmidihirSMMpar[6,2],AmidihirSMMpar[7,2],r)
     sim<-matrix(C[1 ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Cpss_pr (mg/L)")
     output1<-coutput
     show(coutput) 
     C<-TheIRsscpr(0.8,AmidihirSMMpar[6,2],AmidihirSMMpar[7,2],AmidihirSMMpar[7,2])
     sim<-matrix(C[1 ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Ctss_pr (mg/L)")
     output2<-coutput
     show(coutput)     
     cat("\n")   
     Amidihirsm.more(AmidihirSMMpar,AmidihirSMpar,output1,output2)                                                                                                                                                                                            
  } 
     else if (pick == 3){
     rm(list=ls(all=TRUE))
     cat("\n")                                                                       
     cat("***********************************************************\n")
     cat("    --Aminophylline dihydrous IR input data information--  \n")
     cat("    Gender = Male=1 ; Female=0                             \n")
     cat("    age = age (yr)                                         \n")
     cat("    ht = height (cm)                                       \n") 
     cat("    CHF = 1 for yes ; otherwise = 0                        \n")
     cat("    smoke = 1 for a amoker ; otherwise 0                   \n") 
     cat("    D = dose for each dosing interval (mg)                 \n") 
     cat("    tau = dosing interval (hr)                             \n")
     cat("    ts = sampling time (hr)                                \n") 
     cat("    c = measured steady-state conc.(mg/L)                  \n")  
     cat("***********************************************************\n\n")
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     AmidihirMSpar<-data.frame(subject=c(1,2),Gender=c(0),age=c(0),ht=c(0),CHF=c(0),smoke=c(0),D=c(0),tau=c(0),ts=c(0),c=c(0))
     AmidihirMSpar<-edit(AmidihirMSpar)
     AmidihirMSpar<-ymscheck(AmidihirMSpar)
     cat("\n")
     Amidihir.ms(length(AmidihirMSpar$subject),AmidihirMSpar$c,AmidihirMSpar$tau,AmidihirMSpar$ts,AmidihirMSpar$D,AmidihirMSpar$ht,AmidihirMSpar$age,AmidihirMSpar$smoke,AmidihirMSpar$Gender,AmidihirMSpar$CHF)
     cat("\n\n")
     cat("**********************************************************\n")
     cat("   You can PgUp/PgDown to scroll through your checking    \n")
     cat("   convergence plots.                                     \n")  
     cat("**********************************************************\n\n")
     options("graphics.record"=TRUE)
     samplesHistory("*",mfrow=c(3,1), ask = FALSE)
     samplesDensity("*", mfrow = c(3, 2), ask = FALSE)
     samplesAutoC("*",1, mfrow = c(3, 2), ask = FALSE)
     cat("***********************************************************\n") 
     cat("    --Aminophylline dihydrous IR output data information-- \n")
     cat("    cl_F = clerance/bioavailability (L/hr)                 \n")
     cat("    V_F = volume of distribution/bioavailability (L)       \n")
     cat("    Cmss_pr = predicted steady-state measured conc.(mg/L) \n")
     cat("    Cpss_pr = predicted steady-state peak conc.(mg/L)     \n")
     cat("    Ctss_pr = predicted steady-state trough conc.(mg/L)   \n")
     cat("***********************************************************\n")         
     show(samplesStats("*"))
     cat("\n")
     C<-TheIRsscpr(0.8,AmidihirMSpar$D,AmidihirMSpar$tau,AmidihirMSpar$ts)
     sim<-matrix(C[ ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Cmss_pr (mg/L)")
     output1<-coutput
     show(coutput)
     r=log(1.85-(samplesStats("cl_F")/samplesStats("v_F")))/(1.85-(samplesStats("cl_F")/samplesStats("v_F")))
     C<-TheIRsscpr(0.8,AmidihirMSpar$D,AmidihirMSpar$tau,r)
     sim<-matrix(C[ ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Cpss_pr (mg/L)")
     output2<-coutput
     show(coutput) 
     C<-TheIRsscpr(0.8,AmidihirMSpar$D,AmidihirMSpar$tau,AmidihirMSpar$tau)
     sim<-matrix(C[ ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Ctss_pr (mg/L)")
     output3<-coutput
     show(coutput)     
     cat("\n")  
     cat("          Pressing Enter to show individual summary report                  \n")
     readline()
     Amidihirms.pkoutput(AmidihirMSpar,output1,output2,output3)                                                                                                                                                                                
     cal.again()
  } 
     else if (pick == 4){     
      cat("\n")                                                                       
     cat("***********************************************************\n")
     cat("    --Aminophylline dihydrous IR input data information--  \n")
     cat("    Gender = Male=1 ; Female=0                             \n")
     cat("    age = age (yr)                                         \n")
     cat("    ht = height (cm)                                       \n") 
     cat("    CHF = 1 for yes ; otherwise = 0                        \n")
     cat("    smoke = 1 for a amoker ; otherwise 0                   \n") 
     cat("    D = dose for each dosing interval (mg)                 \n") 
     cat("    tau = dosing interval (hr)                             \n")  
     cat("***********************************************************\n\n")
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     AmidihirMMpar<-data.frame(subject=c(1,2),Gender=c(0),age=c(0),ht=c(0),CHF=c(0),smoke=c(0),D=c(0),tau=c(0))
     AmidihirMMpar<-edit(AmidihirMMpar)
     AmidihirMmpar<-mscheck(AmidihirMMpar)
     cat("\n")
     cat("***********************************************************\n")
     cat("    --Aminophylline dihydrous IR input data information--  \n")
     cat("    c = measured steady-state conc.(mg/L)                  \n")
     cat("    ts = sampling time since infusion end                  \n")
     cat("***********************************************************\n\n")
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     AmidihirMMMpar<-data.frame(subject=c(1),ts=c(0),conc=c(0))
     AmidihirMMMpar<-edit(AmidihirMMMpar)
     AmidihirMMMpar<-mscheck(AmidihirMMMpar)
     cat("\n")
     cat("***********************************************************\n")
     cat("    --Aminophylline dihydrous IR output data information-- \n")
     cat("    cl_F = clerance/bioavailability (L/hr)                 \n")
     cat("    V_F = volume of distribution/bioavailability (L)       \n")
     cat("    Cpss_pr = predicted steady-state peak conc.(mg/L)      \n")
     cat("    Ctss_pr = predicted steady-state trough conc.(mg/L)    \n")
     cat("***********************************************************\n")
     for(i in 1:length(unique(AmidihirMMpar$subject))){
     a=length(AmidihirMMMpar$ts[AmidihirMMMpar$subject==i])
     b=AmidihirMMMpar$conc[AmidihirMMMpar$subject==i]
     C=AmidihirMMMpar$ts[AmidihirMMMpar$subject==i]
     d=AmidihirMMpar$tau[AmidihirMMpar$subject==i]
     e=AmidihirMMpar$D[AmidihirMMpar$subject==i]
     f=AmidihirMMpar$ht[AmidihirMMpar$subject==i]
     g=AmidihirMMpar$age[AmidihirMMpar$subject==i]
     h=AmidihirMMpar$smoke[AmidihirMMpar$subject==i]
     l=AmidihirMMpar$Gender[AmidihirMMpar$subject==i]
     J=AmidihirMMpar$CHF[AmidihirMMpar$subject==i]
     Amidihir.mm(a,b,C,d,e,f,g,h,l,J,i)
     cat("\n")
     cat("**************************************************************************\n")
     cat("                 << Subject",i,">>                           \n\n" )
     cat("cl_F = clerance/bioavailability (L/hr)                         \n")
     cat("v_F = volume of distribution/bioavailability (L)               \n\n")
     windows()
     samplesHistory("*",mfrow=c(3,1),ask=FALSE)
     windows()
     samplesDensity("*",mfrow=c(3,2),ask=FALSE)
     windows()
     samplesAutoC("*",1,mfrow=c(3,2),ask=FALSE)
     show(samplesStats("*"))
     cat("\n")
     r=log(1.85-(samplesStats("cl_F")/samplesStats("v_F")))/(1.85-(samplesStats("cl_F")/samplesStats("v_F")))
     C<-TheIRsscpr(0.8,e,d,r)
     sim<-matrix(C[1 ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Cpss_pr (mg/L)")
     show(coutput) 
     C<-TheIRsscpr(0.8,e,d,d)
     sim<-matrix(C[1 ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Ctss_pr (mg/L)")
     show(coutput)     
     cat("\n")  
     cat("\n**************************************************************************\n")
     }
     cal.again()
  } 
  else if (pick == 5){
     cat("\n\n") 
     Amidih.menu()
  }      
}


# 2 
# Aminophylline dihydrous control release model
Amidihcr.model<-function()
{
   file.menu <- c("single subj with single conc",               
                 "multiple subj with each single conc",
                 "Go back one upper level")
  pick <- menu(file.menu, title = "<< data type >>") 
  if (pick == 1){                                                                    
     cat("\n")                                                                       
     cat("***********************************************************\n")
     cat("    --Aminophylline dihydrous CR input data information--  \n")
     cat("    Gender = Male=1 ; Female=0                             \n")
     cat("    age = age (yr)                                         \n")
     cat("    ht = height (cm)                                       \n") 
     cat("    CHF = 1 for yes ; otherwise = 0                        \n")
     cat("    smoke = 1 for a amoker ; otherwise 0                   \n") 
     cat("    D = dose for each dosing interval (mg)                 \n") 
     cat("    tau = dosing interval (hr)                             \n")
     cat("    C = measured steady-state conc.                        \n")
     cat("***********************************************************\n\n")
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     AmidihcrSSpar<-data.frame(parameter=c("Gender","age (yr)","ht (cm)","CHF","smoke","D (mg)","tau (hr)","c (mg/L)"),value=c(0))                                           
     AmidihcrSSpar<-edit(AmidihcrSSpar)                                                                                                                                          
     AmidihcrSSpar<-ycheck(AmidihcrSSpar) 
     cat("\n")                                                                                                                                        
     Amidihcr.ss(AmidihcrSSpar[8,2],AmidihcrSSpar[7,2],AmidihcrSSpar[6,2],AmidihcrSSpar[3,2],AmidihcrSSpar[2,2],AmidihcrSSpar[5,2],AmidihcrSSpar[1,2],AmidihcrSSpar[4,2]) 
     get(getOption("device"))()
     samplesHistory("*",mfrow=c(3,1), ask = FALSE)
     get(getOption("device"))()
     samplesDensity("*", mfrow = c(3, 2), ask = FALSE)
     get(getOption("device"))()
     samplesAutoC("*",1, mfrow = c(3, 2), ask = FALSE)
     cat("\n\n")
     cat("***********************************************************\n")
     cat("    --Aminophylline dihydrous CR output data information-- \n")
     cat("    cl_F = clerance/bioavailability (L/hr)                 \n")
     cat("    Css_pr = predicted steady-state conc.(mg/L)            \n")
     cat("***********************************************************\n")
     show(samplesStats("*"))
     cat("\n") 
     C<-TheCRcpr(0.8,AmidihcrSSpar[6,2],AmidihcrSSpar[7,2])
     sim<-matrix(C[1 ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Css_pr (mg/L)")     
     show(coutput)
     cat("\n")   
     Amidihcr.more(AmidihcrSSpar,coutput)                                                                                                                                                             
  } 
     else if (pick == 2){
     rm(list=ls(all=TRUE))
     cat("\n")                                                                       
     cat("***********************************************************\n")
     cat("    --Aminophylline dihydrous CR input data information--  \n")
     cat("    Gender = Male=1 ; Female=0                             \n")
     cat("    age = age (yr)                                         \n")
     cat("    ht = height (cm)                                       \n") 
     cat("    CHF = 1 for yes ; otherwise = 0                        \n")
     cat("    smoke = 1 for a amoker ; otherwise 0                   \n") 
     cat("    D = dose for each dosing interval (mg)                 \n") 
     cat("    tau = dosing interval (hr)                             \n")
     cat("    C = measured steady-state conc.                        \n")
     cat("***********************************************************\n\n")
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     AmidihcrMSpar<-data.frame(subject=c(1,2),Gender=c(0),age=c(0),ht=c(0),CHF=c(0),smoke=c(0),D=c(0),tau=c(0),c=c(0))
     AmidihcrMSpar<-edit(AmidihcrMSpar)
     AmidihcrMSpar<-ymscheck(AmidihcrMSpar)
     cat("\n")
     Amidihcr.ms(length(AmidihcrMSpar$subject),AmidihcrMSpar$c,AmidihcrMSpar$tau,AmidihcrMSpar$D,AmidihcrMSpar$ht,AmidihcrMSpar$age,AmidihcrMSpar$smoke,AmidihcrMSpar$Gender,AmidihcrMSpar$CHF)
     cat("\n\n")
     cat("**********************************************************\n")
     cat("   You can PgUp/PgDown to scroll through your checking    \n")
     cat("   convergence plots.                                     \n")  
     cat("**********************************************************\n\n")
     options("graphics.record"=TRUE)
     samplesHistory("*",mfrow=c(3,1), ask = FALSE)
     samplesDensity("*", mfrow = c(3, 2), ask = FALSE)
     samplesAutoC("*",1, mfrow = c(3, 2), ask = FALSE)
     cat("***********************************************************\n")
     cat("    --Aminophylline dihydrous CR output data information-- \n")
     cat("    cl_F = clerance/bioavailability (L/hr)                 \n")
     cat("    Css_pr = predicted steady-state conc.(mg/L)            \n")
     cat("***********************************************************\n")    
     show(samplesStats("*"))
     cat("\n") 
     C<-TheCRcpr(0.8,AmidihcrMSpar$D,AmidihcrMSpar$tau)
     sim<-matrix(C[ ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Css_pr (mg/L)")     
     show(coutput)
     cat("\n")   
     cat("          Pressing Enter to show individual summary report                  \n")
     readline()
     Amidihcrms.pkoutput(AmidihcrMSpar,coutput)  
     cal.again()                                                                                                                                                                             
  } 
  else if (pick == 3){
     cat("\n\n") 
     Amidih.menu()
  }      
}


#Aminophylline dihydrous iv infusion model
Amidihinfusion.model<-function()
{
  file.menu <- c("single subj with single conc",               
                 "single subj with mutiple conc (sampling times must more than twice)",
                 "multiple subj with each single conc",
                 "multiple subj and mutiple conc (each subj's sampling times must more than twice)",
                 "Go back one upper level")
  pick <- menu(file.menu, title = "<< data type >>") 
  if (pick == 1){                                                                    
     cat("\n")                                                                        
     cat("********************************************************************\n")
     cat("    --Aminophylline dihydrous iv infusion input data information--  \n")
     cat("    Gender = Male=1 ; Female=0                             \n")
     cat("    age = age (yr)                                         \n")
     cat("    ht = height (cm)                                       \n") 
     cat("    CHF = 1 for yes ; otherwise = 0                        \n")
     cat("    smoke = 1 for a amoker ; otherwise 0                   \n") 
     cat("    DL = loading dose (mg)                                 \n")
     cat("    tinf = infusion time of loading dose (hr)              \n") 
     cat("    R = constant intravenous infusion rate (mg/hr)         \n") 
     cat("    tau = dosing interval (hr)                             \n")
     cat("    ts = sampling time since infusion end (hr)           \n")
     cat("    C = measured conc. (mg/L)                              \n")
     cat("********************************************************************\n\n")                                                              
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     AmidihinfusionSSpar<-data.frame(parameter=c("Gender","age (yr)","ht (cm)","CHF","smoke","DL (mg)","tinf (hr)","R (hr)","ts (hr)","c (mg/L)"),value=c(0))                                                                                                          
     AmidihinfusionSSpar<-edit(AmidihinfusionSSpar)                                                                                                                                                                                                              
     AmidihinfusionSSpar<-ycheck(AmidihinfusionSSpar)     
     cat("\n")                                                                                                                                                                                                        
     Amidihinfusion.ss(AmidihinfusionSSpar[10,2],AmidihinfusionSSpar[9,2],AmidihinfusionSSpar[6,2],AmidihinfusionSSpar[3,2],AmidihinfusionSSpar[2,2],AmidihinfusionSSpar[5,2],AmidihinfusionSSpar[1,2],AmidihinfusionSSpar[4,2],AmidihinfusionSSpar[6,2],AmidihinfusionSSpar[8,2],AmidihinfusionSSpar[9,2])
     get(getOption("device"))()
     samplesHistory("*",mfrow=c(3,1), ask = FALSE)
     get(getOption("device"))()
     samplesDensity("*", mfrow = c(3, 2), ask = FALSE)
     get(getOption("device"))()
     samplesAutoC("*",1, mfrow = c(3, 2), ask = FALSE)
     cat("\n\n")
     cat("********************************************************************\n") 
     cat("    --Aminophylline dihydrous iv infusion output data information-- \n")
     cat("    cl = clerance (L/hr)                          \n")
     cat("    v = volume of distribution (L)                \n")
     cat("    Cm_pr = predicted measured conc.(mg/L)   \n")
     cat("    Ctss_pr = predicted steady-state trough conc.(mg/L)     \n")
     cat("********************************************************************\n")  
     show(samplesStats("*"))
     cat("\n") 
     C<-Theinfusioncpr(0.8,AmidihinfusionSSpar[6,2],AmidihinfusionSSpar[8,2],AmidihinfusionSSpar[9,2],AmidihinfusionSSpar[7,2])
     sim<-matrix(C[1 ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Cm_pr (mg/L)")   
     coutput1<-coutput  
     show(coutput)
     C<-0.8*AmidihinfusionSSpar[8,2]/(samplesStats("cl"))
     sim<-matrix(C[1,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Ctss_pr (mg/L)") 
     coutput2<-coutput
     cat("\n")   
     Amidihinfusion.more(AmidihinfusionSSpar,coutput1,coutput2)                                                                                                                                                                                                                                                  
   } 
   else if (pick == 2){     
     cat("\n")                                                                       
     cat("********************************************************************\n")
     cat("    --Aminophylline dihydrous iv infusion input data information--  \n")
     cat("    Gender = Male=1 ; Female=0                             \n")
     cat("    age = age (yr)                                         \n")
     cat("    ht = height (cm)                                       \n") 
     cat("    CHF = 1 for yes ; otherwise = 0                        \n")
     cat("    smoke = 1 for a amoker ; otherwise 0                   \n") 
     cat("    DL = loading dose (mg)                                 \n")
     cat("    tinf = infusion time of loading dose (hr)              \n") 
     cat("    R = constant intravenous infusion rate (mg/hr)         \n") 
     cat("********************************************************************\n\n")                                                              
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     AmidihinfusionSMMpar<-data.frame(parameter=c("Gender","age (yr)","ht (cm)","CHF","smoke","DL (mg)","tinf (hr)","R (mg/hr)"),value=c(0))
     AmidihinfusionSMMpar<-edit(AmidihinfusionSMMpar)
     AmidihinfusionSMMpar<-ycheck(AmidihinfusionSMMpar)
     cat("\n")
     cat("*****************************************************************\n")
     cat("    --Aminophylline dihydrous infusion input data information--  \n")
     cat("    c = measured conc.(mg/L)                  \n")
     cat("    ts = sampling time since infusion end                  \n")
     cat("*****************************************************************\n\n")
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     AmidihinfusionSMpar<-data.frame(ts=c(0),conc=c(0))                                                                                                                            
     AmidihinfusionSMpar<-edit(AmidihinfusionSMpar)                                            
     AmidihinfusionSMpar<-mscheck(AmidihinfusionSMpar)                                         
     cat("\n")
     Amidihinfusion.sm(length(AmidihinfusionSMpar$ts),AmidihinfusionSMpar$conc,AmidihinfusionSMpar$ts,AmidihinfusionSMMpar[3,2],AmidihinfusionSMMpar[2,2],AmidihinfusionSMMpar[5,2],AmidihinfusionSMMpar[1,2],AmidihinfusionSMMpar[4,2],AmidihinfusionSMMpar[6,2],AmidihinfusionSMMpar[8,2],AmidihinfusionSMMpar[7,2])
     get(getOption("device"))()
     samplesHistory("*",mfrow=c(3,1), ask = FALSE)
     get(getOption("device"))()
     samplesDensity("*", mfrow = c(3, 2), ask = FALSE)
     get(getOption("device"))()
     samplesAutoC("*",1, mfrow = c(3, 2), ask = FALSE)
     cat("\n\n")
     cat("*****************************************************************\n")
     cat("    --Aminophylline dihydrous infusion output data information-- \n")
     cat("    cl = clerance(L/hr)                 \n")
     cat("    V = volume of distribution (L)       \n")
     cat("    Ctss_pr = predicted steady-state trough conc.(mg/L)    \n")
     cat("*****************************************************************\n")
     show(samplesStats("*"))
     cat("\n")
     C<-0.8*AmidihinfusionSMMpar[8,2]/(samplesStats("cl"))
     sim<-matrix(C[1 ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Ctss_pr (mg/L)")
     show(coutput)     
     cat("\n")   
     Amidihinfusionsm.more(AmidihinfusionSMMpar,AmidihinfusionSMpar,coutput)                                                                                                                                                                                            
  } 
     else if (pick == 3){
     rm(list=ls(all=TRUE))
     cat("\n")                                                                      
     cat("********************************************************************\n\n")
     cat("    --Aminophylline dihydrous iv infusion input data information--  \n")
     cat("    Gender = Male=1 ; Female=0                             \n")
     cat("    age = age (yr)                                         \n")
     cat("    ht = height (cm)                                       \n") 
     cat("    CHF = 1 for yes ; otherwise = 0                        \n")
     cat("    smoke = 1 for a amoker ; otherwise 0                   \n") 
     cat("    DL = loading dose (mg)                                 \n") 
     cat("    tinf = infusion time of loading dose (hr)              \n")
     cat("    R = constant intravenous infusion rate (mg/hr)         \n") 
     cat("    ts = sampling time since infusion end (hr)           \n")
     cat("    C = measured conc. (mg/L)                              \n")
     cat("********************************************************************\n\n")
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     AmidihinfusionMSpar<-data.frame(subject=c(1,2),Gender=c(0),age=c(0),ht=c(0),CHF=c(0),smoke=c(0),DL=c(0),tinf=c(0),R=c(0),ts=c(0),c=c(0))
     AmidihinfusionMSpar<-edit(AmidihinfusionMSpar)
     AmidihinfusionMSpar<-ymscheck(AmidihinfusionMSpar)
     cat("\n")
     Amidihinfusion.ms(length(AmidihinfusionMSpar$subject),AmidihinfusionMSpar$c,AmidihinfusionMSpar$ts,AmidihinfusionMSpar$ht,AmidihinfusionMSpar$age,AmidihinfusionMSpar$smoke,AmidihinfusionMSpar$Gender,AmidihinfusionMSpar$CHF,AmidihinfusionMSpar$DL,AmidihinfusionMSpar$R,AmidihinfusionMSpar$tinf)
     cat("\n\n")
     cat("**********************************************************\n")
     cat("   You can PgUp/PgDown to scroll through your checking    \n")
     cat("   convergence plots.                                     \n")  
     cat("**********************************************************\n\n")
     options("graphics.record"=TRUE)
     samplesHistory("*",mfrow=c(3,1), ask = FALSE)
     samplesDensity("*", mfrow = c(3, 2), ask = FALSE)
     samplesAutoC("*",1, mfrow = c(3, 2), ask = FALSE)
     cat("**********************************************************************\n") 
     cat("    --Aminophylline dihydrous iv infusion output data information-- \n")
     cat("    cl = clerance (L/hr)                          \n")
     cat("    v = volume of distribution (L)                \n")
     cat("    Cm_pr = predicted measured conc.(mg/L)   \n")
     cat("    Ctss_pr = predicted steady-state trough conc.(mg/L)     \n")
     cat("**********************************************************************\n")      
     show(samplesStats("*"))
     cat("\n") 
     C<-Theinfusioncpr(0.8,AmidihinfusionMSpar$DL,AmidihinfusionMSpar$R,AmidihinfusionMSpar$ts,AmidihinfusionMSpar$tinf)
     sim<-matrix(C[ ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Cm_pr (mg/L)")     
     coutput1<-coutput
     show(coutput)
     C<-0.8*AmidihinfusionMSpar$R/(samplesStats("cl"))
     sim<-matrix(C[ ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Ctss_pr (mg/L)") 
     coutput2<-coutput
     show(coutput)
     cat("\n")   
     cat("          Pressing Enter to show individual summary report                  \n")
     readline()
     Amidihinfusionms.pkoutput(AmidihinfusionMSpar,coutput1,coutput2)      
     cal.again()                                                                                                                                                       
  } 
     else if (pick == 4){     
     cat("\n")                                                                       
     cat("*****************************************************************\n")
     cat("    --Aminophylline dihydrous infusion input data information--  \n")
     cat("    Gender = Male=1 ; Female=0                             \n")
     cat("    age = age (yr)                                         \n")
     cat("    ht = height (cm)                                       \n") 
     cat("    CHF = 1 for yes ; otherwise = 0                        \n")
     cat("    smoke = 1 for a amoker ; otherwise 0                   \n") 
     cat("    DL = loading dose (mg)                                 \n")
     cat("    tinf = infusion time of loading dose (hr)              \n") 
     cat("    R = constant intravenous infusion rate (mg/hr)         \n") 
     cat("*****************************************************************\n\n")
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     AmidihinfusionMMpar<-data.frame(usbject=c(1,2),Gender=c(0),age=c(0),ht=c(0),CHF=c(0),smoke=c(0),DL=c(0),tinf=c(0),R=c(0))
     AmidihinfusionMMpar<-edit(AmidihinfusionMMpar)
     AmidihinfusionMMpar<-mscheck(AmidihinfusionMMpar)
     cat("\n")
     cat("********************************************************************\n")
     cat("    --Aminophylline dihydrous infusion input data information--  \n")
     cat("    c = measured steady-state conc.(mg/L)                  \n")
     cat("    ts = sampling time since infusion end                  \n")
     cat("********************************************************************\n\n")
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     AmidihinfusionMMMpar<-data.frame(subject=c(1),ts=c(0),conc=c(0))
     AmidihinfusionMMMpar<-edit(AmidihinfusionMMMpar)
     AmidihinfusionMMMpar<-mscheck(AmidihinfusionMMMpar)
     for(i in 1:length(unique(AmidihinfusionMMpar$subject))){
     a=length(AmidihinfusionMMMpar$ts[AmidihinfusionMMMpar$subject==i])
     b=AmidihinfusionMMMpar$conc[AmidihinfusionMMMpar$subject==i]
     C=AmidihinfusionMMMpar$ts[AmidihinfusionMMMpar$subject==i]
     e=AmidihinfusionMMpar$DL[AmidihinfusionMMpar$subject==i]
     k=AmidihinfusionMMpar$R[AmidihinfusionMMpar$subject==i]
     m=AmidihinfusionMMpar$tinf[AmidihinfusionMMpar$subject==i]
     f=AmidihinfusionMMpar$ht[AmidihinfusionMMpar$subject==i]
     g=AmidihinfusionMMpar$age[AmidihinfusionMMpar$subject==i]
     h=AmidihinfusionMMpar$smoke[AmidihinfusionMMpar$subject==i]
     l=AmidihinfusionMMpar$Gender[AmidihinfusionMMpar$subject==i]
     J=AmidihinfusionMMpar$CHF[AmidihinfusionMMpar$subject==i]
     Amidihinfusion.mm(a,i,b,C,f,g,h,l,J,e,k,m)
     cat("\n")
     cat("**************************************************************************\n")
     cat("                 << Subject",i,">>                           \n\n" )
     cat("cl = clerance (L/hr)                         \n")
     cat("v = volume of distribution (L)               \n")
     cat("Ctss_pr = predicted steady-state trough conc.(mg/L)    \n\n")
     windows()
     samplesHistory("*",mfrow=c(3,1),ask=FALSE)
     windows()
     samplesDensity("*",mfrow=c(3,2),ask=FALSE)
     windows()
     samplesAutoC("*",1,mfrow=c(3,2),ask=FALSE)
     show(samplesStats("*"))
     cat("\n")
     C<-0.8*k/(samplesStats("cl"))
     sim<-matrix(C[1 ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Ctss_pr (mg/L)")
     show(coutput)     
     cat("\n**************************************************************************\n")
     }
     cal.again()
  } 
  else if (pick == 5){
     cat("\n\n") 
     Amidih.menu()
  }      
}


# Oxtriphylline
Oxt.menu <- function()
{
  file.menu <- c("immdediate release",
                 "control release",
                 "Go back one upper level")
  pick <- menu(file.menu, title = "<< Oxtriphylline input form menu >>")
  if (pick == 1){
     cat("\n\n")      
     Oxtir.model()
  } 
  else if (pick == 2){
     cat("\n\n") 
     Oxtcr.model()
  }         
  else if (pick == 3){
     cat("\n\n") 
     Theall.menu()
  }      
}

# Oxtriphylline immdediate release model
Oxtir.model <- function()
{
  file.menu <- c("single subj with single conc",               
                 "single subj with mutiple conc (sampling times must more than twice)",
                 "multiple subj with each single conc",
                 "multiple subj and mutiple conc (each subj's sampling times must more than twice)",
                 "Go back one upper level")
  pick <- menu(file.menu, title = "<< data type >>") 
  if (pick == 1){                                                                    
     cat("\n")                                                                       
     cat("***********************************************************\n")
     cat("    --Oxtriphylline IR input data information--  \n")
     cat("    Gender = Male=1 ; Female=0                             \n")
     cat("    age = age (yr)                                         \n")
     cat("    ht = height (cm)                                       \n") 
     cat("    CHF = 1 for yes ; otherwise = 0                        \n")
     cat("    smoke = 1 for a amoker ; otherwise 0                   \n") 
     cat("    D = dose for each dosing interval (mg)                 \n") 
     cat("    tau = dosing interval (hr)                             \n")
     cat("    ts = sampling time (hr)                                \n")   
     cat("    C = measured steady-state conc.                        \n")
     cat("***********************************************************\n\n")
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     OxtirSSpar<-data.frame(parameter=c("Gender","age (yr)","ht (cm)","CHF","smoke","D (mg)","tau (hr)","ts (hr)","c (mg/L)"),value=c(0))                   
     OxtirSSpar<-edit(OxtirSSpar)                                                                                                                   
     OxtirSSpar<-ycheck(OxtirSSpar)           
     cat("\n")                                                                                                         
     Oxtir.ss(OxtirSSpar[9,2],OxtirSSpar[7,2],OxtirSSpar[8,2],OxtirSSpar[6,2],OxtirSSpar[3,2],OxtirSSpar[2,2],OxtirSSpar[5,2],OxtirSSpar[1,2],OxtirSSpar[4,2])
     get(getOption("device"))()
     samplesHistory("*",mfrow=c(3,1), ask = FALSE)
     get(getOption("device"))()
     samplesDensity("*", mfrow = c(3, 2), ask = FALSE)
     get(getOption("device"))()
     samplesAutoC("*",1, mfrow = c(3, 2), ask = FALSE)
     cat("\n\n")
     cat("***********************************************************\n")
     cat("    --Oxtriphylline IR output data information--           \n")
     cat("    cl_F = clerance/bioavailability (L/hr)                 \n")
     cat("    V_F = volume of distribution/bioavailability (L)       \n")
     cat("    Cmss_pr = predicted steady-state measured conc.(mg/L)  \n")
     cat("    Cpss_pr = predicted steady-state peak conc.(mg/L)      \n")
     cat("    Ctss_pr = predicted steady-state trough conc.(mg/L)    \n")
     cat("***********************************************************\n")
     show(samplesStats("*"))
     cat("\n") 
     C<-TheIRsscpr(0.65,OxtirSSpar[6,2],OxtirSSpar[7,2],OxtirSSpar[8,2])
     sim<-matrix(C[1 ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Cmss_pr (mg/L)")
     output1<-coutput
     show(coutput)
     r=log(1.85-(samplesStats("cl_F")/samplesStats("v_F")))/(1.85-(samplesStats("cl_F")/samplesStats("v_F")))
     C<-TheIRsscpr(0.65,OxtirSSpar[6,2],OxtirSSpar[7,2],r)
     sim<-matrix(C[1 ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Cpss_pr (mg/L)")
     output2<-coutput
     show(coutput)
     C<-TheIRsscpr(0.65,OxtirSSpar[6,2],OxtirSSpar[7,2],OxtirSSpar[7,2])
     sim<-matrix(C[1 ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Ctss_pr (mg/L)")
     output3<-coutput
     show(coutput)     
     cat("\n")  
     Oxtir.more(OxtirSSpar,output1,output2,output3)                                                                                                                                    
  } 
   else if (pick == 2){     
     cat("\n")                                                                      
     cat("***********************************************************\n")
     cat("    --Oxtriphylline IR input data information--            \n")
     cat("    Gender = Male=1 ; Female=0                             \n")
     cat("    age = age (yr)                                         \n")
     cat("    ht = height (cm)                                       \n") 
     cat("    CHF = 1 for yes ; otherwise = 0                        \n")
     cat("    smoke = 1 for a amoker ; otherwise 0                   \n") 
     cat("    D = dose for each dosing interval (mg)                 \n") 
     cat("    tau = dosing interval (hr)                             \n")  
     cat("***********************************************************\n\n")
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     OxtirSMMpar<-data.frame(parameter=c("Gender","age (yr)","ht (cm)","CHF","smoke","D (mg)","tau (hr)"),value=c(0))
     OxtirSMMpar<-edit(OxtirSMMpar)
     OxtirSMMpar<-ycheck(OxtirSMMpar)
     cat("\n")
     cat("***********************************************************\n")
     cat("    --Oxtriphylline IR input data information--            \n")
     cat("    c = measured steady-state conc.(mg/L)                  \n")
     cat("    ts = sampling time since infusion end                  \n")
     cat("***********************************************************\n\n")
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     OxtirSMpar<-data.frame(ts=c(0),conc=c(0))                                                                                                                             
     OxtirSMpar<-edit(OxtirSMpar)                                               
     OxtirSMpar<-mscheck(OxtirSMpar)                                           
     cat("\n")
     Oxtir.sm(length(OxtirSMpar$ts),OxtirSMpar$conc,OxtirSMpar$ts,OxtirSMMpar[7,2],OxtirSMMpar[6,2],OxtirSMMpar[3,2],OxtirSMMpar[2,2],OxtirSMMpar[5,2],OxtirSMMpar[1,2],OxtirSMMpar[4,2])
     cat("\n\n")
     cat("**********************************************************\n")
     cat("   You can PgUp/PgDown to scroll through your checking    \n")
     cat("   convergence plots.                                     \n")  
     cat("**********************************************************\n\n")
     options("graphics.record"=TRUE)
     samplesHistory("*",mfrow=c(3,1), ask = FALSE)
     samplesDensity("*", mfrow = c(3, 2), ask = FALSE)
     samplesAutoC("*",1, mfrow = c(3, 2), ask = FALSE)
     cat("***********************************************************\n")
     cat("    --Oxtriphylline IR output data information--           \n")
     cat("    cl_F = clerance/bioavailability (L/hr)                 \n")
     cat("    V_F = volume of distribution/bioavailability (L)       \n")
     cat("    Cpss_pr = predicted steady-state peak conc.(mg/L)      \n")
     cat("    Ctss_pr = predicted steady-state trough conc.(mg/L)    \n")
     cat("***********************************************************\n")   
     show(samplesStats("*"))
     cat("\n")
     r=log(1.85-(samplesStats("cl_F")/samplesStats("v_F")))/(1.85-(samplesStats("cl_F")/samplesStats("v_F")))
     C<-TheIRsscpr(0.65,OxtirSMMpar[6,2],OxtirSMMpar[7,2],r)
     sim<-matrix(C[1 ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Cpss_pr (mg/L)")
     output1<-coutput
     show(coutput)
     C<-TheIRsscpr(0.65,OxtirSMMpar[6,2],OxtirSMMpar[7,2],OxtirSMMpar[7,2])
     sim<-matrix(C[1 ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Ctss_pr (mg/L)")
     output2<-coutput
     show(coutput)     
     cat("\n")   
     Oxtirsm.more(OxtirSMMpar,OxtirSMpar,output1,output2)                                                                                                                                                                 
  } 
     else if (pick == 3){
     rm(list=ls(all=TRUE))
     cat("\n")                                                                      
     cat("***********************************************************\n")
     cat("    --Oxtriphylline IR input data information--  \n")
     cat("    Gender = Male=1 ; Female=0                             \n")
     cat("    age = age (yr)                                         \n")
     cat("    ht = height (cm)                                       \n") 
     cat("    CHF = 1 for yes ; otherwise = 0                        \n")
     cat("    smoke = 1 for a amoker ; otherwise 0                   \n") 
     cat("    D = dose for each dosing interval (mg)                 \n") 
     cat("    tau = dosing interval (hr)                             \n")
     cat("    ts = sampling time (hr)                                \n")   
     cat("    C = measured steady-state conc.                        \n")
     cat("***********************************************************\n\n")
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     OxtirMSpar<-data.frame(subject=c(1,2),Gender=c(0),age=c(0),ht=c(0),CHF=c(0),smoke=c(0),D=c(0),tau=c(0),ts=c(0),c=c(0))
     OxtirMSpar<-edit(OxtirMSpar)
     OxtirMSpar<-ymscheck(OxtirMSpar)
     cat("\n")
     Oxtir.ms(length(OxtirMSpar$subject),OxtirMSpar$c,OxtirMSpar$tau,OxtirMSpar$ts,OxtirMSpar$D,OxtirMSpar$ht,OxtirMSpar$age,OxtirMSpar$smoke,OxtirMSpar$Gender,OxtirMSpar$CHF)
     cat("\n\n")
     cat("**********************************************************\n")
     cat("   You can PgUp/PgDown to scroll through your checking    \n")
     cat("   convergence plots.                                     \n")  
     cat("**********************************************************\n\n")
     options("graphics.record"=TRUE)
     samplesHistory("*",mfrow=c(3,1), ask = FALSE)
     samplesDensity("*", mfrow = c(3, 2), ask = FALSE)
     samplesAutoC("*",1, mfrow = c(3, 2), ask = FALSE)
      cat("***********************************************************\n")
     cat("    --Oxtriphylline IR output data information--           \n")
     cat("    cl_F = clerance/bioavailability (L/hr)                 \n")
     cat("    V_F = volume of distribution/bioavailability (L)       \n")
     cat("    Cmss_pr = predicted steady-state measured conc.(mg/L)  \n")
     cat("    Cpss_pr = predicted steady-state peak conc.(mg/L)      \n")
     cat("    Ctss_pr = predicted steady-state trough conc.(mg/L)    \n")
     cat("***********************************************************\n")   
     show(samplesStats("*"))
     cat("\n")
     C<-TheIRsscpr(0.65,OxtirMSpar$D,OxtirMSpar$tau,OxtirMSpar$ts)
     sim<-matrix(C[ ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Cmss_pr (mg/L)")
     output1<-coutput
     show(coutput)
     r=log(1.85-(samplesStats("cl_F")/samplesStats("v_F")))/(1.85-(samplesStats("cl_F")/samplesStats("v_F")))
     C<-TheIRsscpr(0.65,OxtirMSpar$D,OxtirMSpar$tau,r)
     sim<-matrix(C[ ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Cpss_pr (mg/L)")
     output2<-coutput
     show(coutput)
     C<-TheIRsscpr(0.65,OxtirMSpar$D,OxtirMSpar$tau,OxtirMSpar$tau)
     sim<-matrix(C[ ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Ctss_pr (mg/L)")
     output3<-coutput
     show(coutput)     
     cat("\n")   
     cat("          Pressing Enter to show individual summary report                  \n")
     readline()
     Oxtirms.pkoutput(OxtirMSpar,output1,output2,output3)     
     cal.again()                                                                                                                                                       
  } 
     else if (pick == 4){     
      cat("\n")                                                                      
     cat("***********************************************************\n")
     cat("    --Oxtriphylline IR input data information--            \n")
      cat("    Gender = Male=1 ; Female=0                             \n")
     cat("    age = age (yr)                                         \n")
     cat("    ht = height (cm)                                       \n") 
     cat("    CHF = 1 for yes ; otherwise = 0                        \n")
     cat("    smoke = 1 for a amoker ; otherwise 0                   \n") 
     cat("    D = dose for each dosing interval (mg)                 \n") 
     cat("    tau = dosing interval (hr)                             \n")  
     cat("***********************************************************\n\n")
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     OxtirMMpar<-data.frame(subject=c(1,2),Gender=c(0),age=c(0),ht=c(0),CHF=c(0),smoke=c(0),D=c(0),tau=c(0))
     OxtirMMpar<-edit(OxtirMMpar)
     OxtirMMpar<-ymscheck(OxtirMMpar)
     cat("\n")
     cat("\n")
     cat("***********************************************************\n")
     cat("    --Oxtriphylline IR input data information--            \n")
     cat("    c = measured steady-state conc.(mg/L)                  \n")
     cat("    ts = sampling time since infusion end                  \n")
     cat("***********************************************************\n\n")
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     OxtirMMMpar<-data.frame(subject=c(1),ts=c(0),conc=c(0))
     OxtirMMMpar<-edit(OxtirMMMpar)
     OxtirMMMpar<-mscheck(OxtirMMMpar)
     cat("\n")
     cat("***********************************************************\n")
     cat("    --Oxtriphylline IR output data information--           \n")
     cat("    cl_F = clerance/bioavailability (L/hr)                 \n")
     cat("    V_F = volume of distribution/bioavailability (L)       \n")
     cat("    Cpss_pr = predicted steady-state peak conc.(mg/L)      \n")
     cat("    Ctss_pr = predicted steady-state trough conc.(mg/L)    \n")
     cat("***********************************************************\n")
     for(i in 1:length(unique(OxtirMMpar$subject))){
     a=length(OxtirMMMpar$ts[OxtirMMMpar$subject==i])
     b=OxtirMMMpar$conc[OxtirMMMpar$subject==i]
     C=OxtirMMMpar$ts[OxtirMMMpar$subject==i]
     d=OxtirMMpar$tau[OxtirMMpar$subject==i]
     e=OxtirMMpar$D[OxtirMMpar$subject==i]
     f=OxtirMMpar$ht[OxtirMMpar$subject==i]
     g=OxtirMMpar$age[OxtirMMpar$subject==i]
     h=OxtirMMpar$smoke[OxtirMMpar$subject==i]
     l=OxtirMMpar$Gender[OxtirMMpar$subject==i]
     J=OxtirMMpar$CHF[OxtirMMpar$subject==i]
     Oxtir.mm(a,b,C,d,e,f,g,h,l,J,i)
     cat("\n")
     cat("**************************************************************************\n")
     cat("                 << Subject",i,">>                           \n\n" )
     cat("cl_F = clerance/bioavailability (L/hr)                         \n")
     cat("v_F = volume of distribution/bioavailability (L)               \n\n")
     windows()
     samplesHistory("*",mfrow=c(3,1),ask=FALSE)
     windows()
     samplesDensity("*",mfrow=c(3,2),ask=FALSE)
     windows()
     samplesAutoC("*",1,mfrow=c(3,2),ask=FALSE)
     show(samplesStats("*"))
     cat("\n")
     r=log(1.85-(samplesStats("cl_F")/samplesStats("v_F")))/(1.85-(samplesStats("cl_F")/samplesStats("v_F")))
     C<-TheIRsscpr(0.65,e,d,r)
     sim<-matrix(C[1 ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Cpss_pr (mg/L)")
     show(coutput)
     C<-TheIRsscpr(0.65,e,d,d)
     sim<-matrix(C[1 ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Ctss_pr (mg/L)")
     show(coutput)     
     cat("\n")  
     cat("\n**************************************************************************\n")
     }
     cal.again()
  } 
  else if (pick == 5){
     cat("\n\n") 
     Oxt.menu()
  }      
}



# 2. 
# Oxtriphylline control release model
Oxtcr.model <- function()
{
  file.menu <- c("single subj with single conc",               
                 "multiple subj with each single conc",
                 "Go back one upper level")
  pick <- menu(file.menu, title = "<< data type >>") 
  if (pick == 1){                                                                    
     cat("\n")                                                                      
     cat("***********************************************************\n")
     cat("    --Oxtriphylline CR input data information--            \n")
     cat("    Gender = Male=1 ; Female=0                             \n")
     cat("    age = age (yr)                                         \n")
     cat("    ht = height (cm)                                       \n") 
     cat("    CHF = 1 for yes ; otherwise = 0                        \n")
     cat("    smoke = 1 for a amoker ; otherwise 0                   \n") 
     cat("    D = dose for each dosing interval (mg)                 \n") 
     cat("    tau = dosing interval (hr)                             \n")
     cat("    C = measured steady-state conc.                        \n")
     cat("***********************************************************\n\n")
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     OxtcrSSpar<-data.frame(parameter=c("Gender","age (yr)","ht (cm)","CHF","smoke","D (mg)","tau (hr)","c (mg/L)"),value=c(0))                   
     OxtcrSSpar<-edit(OxtcrSSpar)                                                                                                                    
     OxtcrSSpar<-ycheck(OxtcrSSpar)   
     cat("\n")                                                                                                                 
     Oxtcr.ss(OxtcrSSpar[8,2],OxtcrSSpar[7,2],OxtcrSSpar[6,2],OxtcrSSpar[3,2],OxtcrSSpar[2,2],OxtcrSSpar[5,2],OxtcrSSpar[1,2],OxtcrSSpar[4,2])
     get(getOption("device"))()
     samplesHistory("*",mfrow=c(3,1), ask = FALSE)
     get(getOption("device"))()
     samplesDensity("*", mfrow = c(3, 2), ask = FALSE)
     get(getOption("device"))()
     samplesAutoC("*",1, mfrow = c(3, 2), ask = FALSE)
     cat("\n\n")
     cat("***********************************************************\n")
     cat("    --Oxtriphylline CR output data information--           \n")
     cat("    cl_F = clerance/bioavailability (L/hr)                 \n")
     cat("    Css_pr = predicted steady-state conc.(mg/L)            \n")
     cat("***********************************************************\n")
     show(samplesStats("*"))
     cat("\n") 
     C<-TheCRcpr(0.65,OxtcrSSpar[6,2],OxtcrSSpar[7,2])
     sim<-matrix(C[1 ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Css_pr (mg/L)")     
     show(coutput)
     cat("\n")   
     Oxtcr.more(OxtcrSSpar,coutput)                                                                                                                                      
  } 
     else if (pick == 2){
     rm(list=ls(all=TRUE))
     cat("\n")                                                                      
     cat("***********************************************************\n")
     cat("    --Oxtriphylline CR input data information--             \n")
     cat("    Gender = Male=1 ; Female=0                             \n")
     cat("    age = age (yr)                                         \n")
     cat("    ht = height (cm)                                       \n") 
     cat("    CHF = 1 for yes ; otherwise = 0                        \n")
     cat("    smoke = 1 for a amoker ; otherwise 0                   \n") 
     cat("    D = dose for each dosing interval (mg)                 \n") 
     cat("    tau = dosing interval (hr)                             \n")
     cat("    C = measured steady-state conc.                        \n")
     cat("***********************************************************\n\n")
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     OxtcrMSpar<-data.frame(subject=c(1,2),Gender=c(0),age=c(0),ht=c(0),CHF=c(0),smoke=c(0),D=c(0),tau=c(0),c=c(0))
     OxtcrMSpar<-edit(OxtcrMSpar)
     OxtcrMSpar<-ymscheck(OxtcrMSpar)
     cat("\n")
     Oxtcr.ms(length(OxtcrMSpar$subject),OxtcrMSpar$c,OxtcrMSpar$tau,OxtcrMSpar$D,OxtcrMSpar$ht,OxtcrMSpar$age,OxtcrMSpar$smoke,OxtcrMSpar$Gender,OxtcrMSpar$CHF)
     cat("\n\n")
     cat("**********************************************************\n")
     cat("   You can PgUp/PgDown to scroll through your checking    \n")
     cat("   convergence plots.                                     \n")  
     cat("**********************************************************\n\n")
     options("graphics.record"=TRUE)
     samplesHistory("*",mfrow=c(3,1), ask = FALSE)
     samplesDensity("*", mfrow = c(3, 2), ask = FALSE)
     samplesAutoC("*",1, mfrow = c(3, 2), ask = FALSE)
     cat("***********************************************************\n")
     cat("    --Oxtriphylline CR output data information--           \n")
     cat("    cl_F = clerance/bioavailability (L/hr)                 \n")
     cat("    Css_pr = predicted steady-state conc.(mg/L)            \n")
     cat("***********************************************************\n")   
     show(samplesStats("*"))
     cat("\n") 
     C<-TheCRcpr(0.65,OxtcrMSpar$D,OxtcrMSpar$tau)
     sim<-matrix(C[ ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Css_pr (mg/L)")     
     show(coutput)
     cat("\n")   
     cat("          Pressing Enter to show individual summary report                  \n")
     readline()
     Oxtcrms.pkoutput(OxtcrMSpar,coutput)      
     cal.again()                                                                                                                                                     
  } 
  else if (pick == 3){
     cat("\n\n") 
     Oxt.menu()
  }      
}



# Theophylline
The.menu <- function()
{
  file.menu <- c("immdediate release",
                 "control release",
                 "Go back one upper level")
  pick <- menu(file.menu, title = "<< Theophylline input form menu >>")
  if (pick == 1){
     cat("\n\n")      
     Their.model()
  } 
  else if (pick == 2){
     cat("\n\n") 
     Thecr.model()
  }           
  else if (pick == 3){
     cat("\n\n") 
     Theall.menu()
  }      
}



# Theophylline immdediate release model
Their.model <- function()
{
  file.menu <- c("single subj with single conc",              
                 "single subj with mutiple conc (sampling times must more than twice)",
                 "multiple subj with each single conc",
                 "multiple subj and mutiple conc (each subj's sampling times must more than twice)",
                 "Go back one upper level")
  pick <- menu(file.menu, title = "<< data type >>") 
  if (pick == 1){                                                                    
     cat("\n")                                                                      
     cat("***********************************************************\n")
     cat("    --Theophylline IR input data information--             \n")
     cat("    Gender = Male=1 ; Female=0                             \n")
     cat("    age = age (yr)                                         \n")
     cat("    ht = height (cm)                                       \n") 
     cat("    CHF = 1 for yes ; otherwise = 0                        \n")
     cat("    smoke = 1 for a amoker ; otherwise 0                   \n") 
     cat("    D = dose for each dosing interval (mg)                 \n") 
     cat("    tau = dosing interval (hr)                             \n")
     cat("    ts = sampling time (hr)                                \n")   
     cat("    C = measured steady-state conc.                        \n")
     cat("***********************************************************\n\n")
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     TheirSSpar<-data.frame(parameter=c("Gender","age (yr)","ht (cm)","CHF","smoke","D (mg)","tau (hr)","ts (hr)","c (mg/L)"),value=c(0))                    
     TheirSSpar<-edit(TheirSSpar)                                                                                                                     
     TheirSSpar<-ycheck(TheirSSpar)   
     cat("\n")                                                                                                                 
     Their.ss(TheirSSpar[9,2],TheirSSpar[7,2],TheirSSpar[8,2],TheirSSpar[6,2],TheirSSpar[3,2],TheirSSpar[2,2],TheirSSpar[5,2],TheirSSpar[1,2],TheirSSpar[4,2])
     get(getOption("device"))()
     samplesHistory("*",mfrow=c(3,1), ask = FALSE)
     get(getOption("device"))()
     samplesDensity("*", mfrow = c(3, 2), ask = FALSE)
     get(getOption("device"))()
     samplesAutoC("*",1, mfrow = c(3, 2), ask = FALSE)
     cat("\n\n")
     cat("***********************************************************\n")
     cat("    --Theophylline IR output data information--            \n")
     cat("    cl_F = clerance/bioavailability (L/hr)                 \n")
     cat("    V_F = volume of distribution/bioavailability (L)       \n")
     cat("    Cmss_pr = predicted steady-state measured conc.(mg/L) \n")
     cat("    Cpss_pr = predicted steady-state peak conc.(mg/L)     \n")
     cat("    Ctss_pr = predicted steady-state trough conc.(mg/L)   \n")
     cat("***********************************************************\n")
     show(samplesStats("*"))
     cat("\n") 
     C<-TheIRsscpr(1,TheirSSpar[6,2],TheirSSpar[7,2],TheirSSpar[8,2])
     sim<-matrix(C[1 ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Cmss_pr (mg/L)")
     output1<-coutput
     show(coutput)
     r=log(1.85-(samplesStats("cl_F")/samplesStats("v_F")))/(1.85-(samplesStats("cl_F")/samplesStats("v_F")))
     C<-TheIRsscpr(1,TheirSSpar[6,2],TheirSSpar[7,2],r)
     sim<-matrix(C[1 ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Cpss_pr (mg/L)")
     output2<-coutput
     show(coutput)
     C<-TheIRsscpr(1,TheirSSpar[6,2],TheirSSpar[7,2],TheirSSpar[7,2])
     sim<-matrix(C[1 ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Ctss_pr (mg/L)")
     output3<-coutput
     show(coutput)     
     cat("\n")  
     Their.more(TheirSSpar,output1,output2,output3)                                                                                                                                     
  } 
   else if (pick == 2){     
     cat("\n")                                                                      
     cat("***********************************************************\n")
     cat("    --Theophylline IR input data information--             \n")
     cat("    Gender = Male=1 ; Female=0                             \n")
     cat("    age = age (yr)                                         \n")
     cat("    ht = height (cm)                                       \n") 
     cat("    CHF = 1 for yes ; otherwise = 0                        \n")
     cat("    smoke = 1 for a amoker ; otherwise 0                   \n") 
     cat("    D = dose for each dosing interval (mg)                 \n") 
     cat("    tau = dosing interval (hr)                             \n") 
     cat("***********************************************************\n\n")
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     TheirSMMpar<-data.frame(parameter=c("Gender","age (yr)","ht (cm)","CHF","smoke","D (mg)","tau (hr)"),value=c(0))
     TheirSMMpar<-edit(TheirSMMpar)
     TheirSMMpar<-ycheck(TheirSMMpar)
     cat("\n")
     cat("***********************************************************\n")
     cat("    --Theophylline IR input data information--             \n")
     cat("    c = measured steady-state conc.(mg/L)                  \n")
     cat("    ts = sampling time since infusion end                  \n")
     cat("***********************************************************\n")
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     TheirSMpar<-data.frame(ts=c(0),conc=c(0))                                                                                                                                 
     TheirSMpar<-edit(TheirSMpar)                                               
     TheirSMpar<-mscheck(TheirSMpar)                                            
     cat("\n")
     Their.sm(length(TheirSMpar$ts),TheirSMpar$conc,TheirSMpar$ts,TheirSMMpar[7,2],TheirSMMpar[6,2],TheirSMMpar[3,2],TheirSMMpar[2,2],TheirSMMpar[5,2],TheirSMMpar[1,2],TheirSMMpar[4,2])
     cat("\n\n")
     cat("**********************************************************\n")
     cat("   You can PgUp/PgDown to scroll through your checking    \n")
     cat("   convergence plots.                                     \n")  
     cat("**********************************************************\n\n")
     options("graphics.record"=TRUE)
     samplesHistory("*",mfrow=c(3,1), ask = FALSE)
     samplesDensity("*", mfrow = c(3, 2), ask = FALSE)
     samplesAutoC("*",1, mfrow = c(3, 2), ask = FALSE)
     cat("***********************************************************\n")
     cat("    --Theophylline IR output data information--            \n")
     cat("    cl_F = clerance/bioavailability (L/hr)                 \n")
     cat("    V_F = volume of distribution/bioavailability (L)       \n")
     cat("    Cpss_pr = predicted steady-state peak conc.(mg/L)     \n")
     cat("    Ctss_pr = predicted steady-state trough conc.(mg/L)   \n")
     cat("***********************************************************\n")   
     show(samplesStats("*"))
     cat("\n")
     r=log(1.85-(samplesStats("cl_F")/samplesStats("v_F")))/(1.85-(samplesStats("cl_F")/samplesStats("v_F")))
     C<-TheIRsscpr(1,TheirSMMpar[6,2],TheirSMMpar[7,2],r)
     sim<-matrix(C[1 ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Cpss_pr (mg/L)")
     output1<-coutput
     show(coutput) 
     C<-TheIRsscpr(1,TheirSMMpar[6,2],TheirSMMpar[7,2],TheirSMMpar[7,2])
     sim<-matrix(C[1 ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Ctss_pr (mg/L)")
     output2<-coutput
     show(coutput)     
     cat("\n")     
     Theirsm.more(TheirSMMpar,TheirSMpar,output1,output2)                                                                                                                                                                 
  } 
     else if (pick == 3){
     rm(list=ls(all=TRUE))
     cat("\n")                                                                       
     cat("***********************************************************\n")
     cat("    --Theophylline IR input data information--             \n")
     cat("    Gender = Male=1 ; Female=0                             \n")
     cat("    age = age (yr)                                         \n")
     cat("    ht = height (cm)                                       \n") 
     cat("    CHF = 1 for yes ; otherwise = 0                        \n")
     cat("    smoke = 1 for a amoker ; otherwise 0                   \n") 
     cat("    D = dose for each dosing interval (mg)                 \n") 
     cat("    tau = dosing interval (hr)                             \n")
     cat("    ts = sampling time (hr)                                \n")   
     cat("    C = measured steady-state conc.                        \n")
     cat("***********************************************************\n\n")
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     TheirMSpar<-data.frame(subject=c(1,2),Gender=c(0),age=c(0),ht=c(0),CHF=c(0),smoke=c(0),D=c(0),tau=c(0),ts=c(0),c=c(0))
     TheirMSpar<-edit(TheirMSpar)
     TheirMSpar<-ymscheck(TheirMSpar)
     cat("\n")
     Their.ms(length(TheirMSpar$subject),TheirMSpar$c,TheirMSpar$tau,TheirMSpar$ts,TheirMSpar$D,TheirMSpar$ht,TheirMSpar$age,TheirMSpar$smoke,TheirMSpar$Gender,TheirMSpar$CHF)
     cat("\n\n")
     cat("**********************************************************\n")
     cat("   You can PgUp/PgDown to scroll through your checking    \n")
     cat("   convergence plots.                                     \n")  
     cat("**********************************************************\n\n")
     options("graphics.record"=TRUE)
     samplesHistory("*",mfrow=c(3,1), ask = FALSE)
     samplesDensity("*", mfrow = c(3, 2), ask = FALSE)
     samplesAutoC("*",1, mfrow = c(3, 2), ask = FALSE)
     cat("***********************************************************\n")
     cat("    --Theophylline IR output data information--            \n")
     cat("    cl_F = clerance/bioavailability (L/hr)                 \n")
     cat("    V_F = volume of distribution/bioavailability (L)       \n")
     cat("    Cmss_pr = predicted steady-state measured conc.(mg/L) \n")
     cat("    Cpss_pr = predicted steady-state peak conc.(mg/L)     \n")
     cat("    Ctss_pr = predicted steady-state trough conc.(mg/L)   \n")
     cat("***********************************************************\n")    
     show(samplesStats("*"))
     cat("\n")
     C<-TheIRsscpr(1,TheirMSpar$D,TheirMSpar$tau,TheirMSpar$ts)
     sim<-matrix(C[ ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Cmss_pr (mg/L)")
     output1<-coutput
     show(coutput)
     r=log(1.85-(samplesStats("cl_F")/samplesStats("v_F")))/(1.85-(samplesStats("cl_F")/samplesStats("v_F")))
     C<-TheIRsscpr(1,TheirMSpar$D,TheirMSpar$tau,r)
     sim<-matrix(C[ ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Cpss_pr (mg/L)")
     output2<-coutput
     show(coutput)
     C<-TheIRsscpr(1,TheirMSpar$D,TheirMSpar$tau,TheirMSpar$tau)
     sim<-matrix(C[ ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Ctss_pr (mg/L)")
     output3<-coutput
     show(coutput)     
     cat("\n") 
     cat("          Pressing Enter to show individual summary report                  \n")
     readline()
     Theirms.pkoutput(TheirMSpar,output1,output2,output3)   
     cal.again()                                                                                                                                                  
  } 
     else if (pick == 4){     
     cat("\n")                                                                      
     cat("***********************************************************\n")
     cat("    --Theophylline IR input data information--             \n")
     cat("    Gender = Male=1 ; Female=0                             \n")
     cat("    age = age (yr)                                         \n")
     cat("    ht = height (cm)                                       \n") 
     cat("    CHF = 1 for yes ; otherwise = 0                        \n")
     cat("    smoke = 1 for a amoker ; otherwise 0                   \n") 
     cat("    D = dose for each dosing interval (mg)                 \n") 
     cat("    tau = dosing interval (hr)                             \n") 
     cat("***********************************************************\n\n")
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     TheirMMpar<-data.frame(subject=c(1,2),Gender=c(0),age=c(0),ht=c(0),CHF=c(0),smoke=c(0),D=c(0),tau=c(0))
     TheirMMpar<-edit(TheirMMpar)
     TheirMMpar<-ymscheck(TheirMMpar)
     cat("\n")
     cat("***********************************************************\n")
     cat("    --Theophylline IR input data information--             \n")
     cat("    c = measured steady-state conc.(mg/L)                  \n")
     cat("    ts = sampling time since infusion end                  \n")
     cat("***********************************************************\n\n")
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     TheirMMMpar<-data.frame(subject=c(1),ts=c(0),conc=c(0))
     TheirMMMpar<-edit(TheirMMMpar)
     TheirMMMpar<-mscheck(TheirMMMpar)
     cat("\n")
     cat("***********************************************************\n")
     cat("    --Theophylline IR output data information--            \n")
     cat("    cl_F = clerance/bioavailability (L/hr)                 \n")
     cat("    V_F = volume of distribution/bioavailability (L)       \n")
     cat("    Cpss_pr = predicted steady-state peak conc.(mg/L)     \n")
     cat("    Ctss_pr = predicted steady-state trough conc.(mg/L)   \n")
     cat("***********************************************************\n")
     for(i in 1:length(unique(TheirMMpar$subject))){
     a=length(TheirMMMpar$ts[TheirMMMpar$subject==i])
     b=TheirMMMpar$conc[TheirMMMpar$subject==i]
     C=TheirMMMpar$ts[TheirMMMpar$subject==i]
     d=TheirMMpar$tau[TheirMMpar$subject==i]
     e=TheirMMpar$D[TheirMMpar$subject==i]
     f=TheirMMpar$ht[TheirMMpar$subject==i]
     g=TheirMMpar$age[TheirMMpar$subject==i]
     h=TheirMMpar$smoke[TheirMMpar$subject==i]
     l=TheirMMpar$Gender[TheirMMpar$subject==i]
     J=TheirMMpar$CHF[TheirMMpar$subject==i]
     Their.mm(a,b,C,d,e,f,g,h,l,J,i)
     cat("\n")
     cat("**************************************************************************\n")
     cat("                 << Subject",i,">>                           \n\n" )
     cat("cl_F = clerance/bioavailability (L/hr)                         \n")
     cat("v_F = volume of distribution/bioavailability (L)               \n\n")
     windows()
     samplesHistory("*",mfrow=c(3,1),ask=FALSE)
     windows()
     samplesDensity("*",mfrow=c(3,2),ask=FALSE)
     windows()
     samplesAutoC("*",1,mfrow=c(3,2),ask=FALSE)
     show(samplesStats("*"))
     cat("\n")
     r=log(1.85-(samplesStats("cl_F")/samplesStats("v_F")))/(1.85-(samplesStats("cl_F")/samplesStats("v_F")))
     C<-TheIRsscpr(1,e,d,r)
     sim<-matrix(C[1 ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Ctss_pr (mg/L)")
     show(coutput)  
     C<-TheIRsscpr(1,e,d,d)
     sim<-matrix(C[1 ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Ctss_pr (mg/L)")
     show(coutput)     
     cat("\n")  
     cat("\n**************************************************************************\n")
     }
     cal.again()
  } 
  else if (pick == 5){
     cat("\n\n") 
     The.menu()
  }      
}



# 2. 
# Theophylline control release model
Thecr.model <- function()
{
  file.menu <- c("single subj with single conc",                 
                 "multiple subj with each single conc",
                 "Go back one upper level")
  pick <- menu(file.menu, title = "<< data type >>") 
  if (pick == 1){                                                                    
     cat("\n")                                                                      
     cat("***********************************************************\n")
     cat("    --Theophylline CR input data information--             \n")
     cat("    Gender = Male=1 ; Female=0                             \n")
     cat("    age = age (yr)                                         \n")
     cat("    ht = height (cm)                                       \n") 
     cat("    CHF = 1 for yes ; otherwise = 0                        \n")
     cat("    smoke = 1 for a amoker ; otherwise 0                   \n") 
     cat("    D = dose for each dosing interval (mg)                 \n") 
     cat("    tau = dosing interval (hr)                             \n")
     cat("    C = measured steady-state conc.                        \n")
     cat("***********************************************************\n\n")
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     ThecrSSpar<-data.frame(parameter=c("Gender","age (yr)","ht (cm)","CHF","smoke","D (mg)","tau (hr)","c (mg/L)"),value=c(0))                    
     ThecrSSpar<-edit(ThecrSSpar)                                                                                                                     
     ThecrSSpar<-ycheck(ThecrSSpar) 
     cat("\n")                                                                                                                   
     Thecr.ss(ThecrSSpar[8,2],ThecrSSpar[7,2],ThecrSSpar[6,2],ThecrSSpar[3,2],ThecrSSpar[2,2],ThecrSSpar[5,2],ThecrSSpar[1,2],ThecrSSpar[4,2])
     get(getOption("device"))()
     samplesHistory("*",mfrow=c(3,1), ask = FALSE)
     get(getOption("device"))()
     samplesDensity("*", mfrow = c(3, 2), ask = FALSE)
     get(getOption("device"))()
     samplesAutoC("*",1, mfrow = c(3, 2), ask = FALSE)
     cat("\n\n")
     cat("***********************************************************\n")
     cat("    --Theophylline CR output data information--            \n")
     cat("    cl_F = clerance/bioavailability (L/hr)                 \n")
     cat("    Css_pr = predicted steady-state conc.(mg/L)            \n")
     cat("***********************************************************\n")
     show(samplesStats("*"))
     cat("\n") 
     C<-TheCRcpr(1,ThecrSSpar[6,2],ThecrSSpar[7,2])
     sim<-matrix(C[1 ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Css_pr (mg/L)")     
     show(coutput)
     cat("\n")   
     Thecr.more(ThecrSSpar,coutput)                                                                                                                                     
  } 
    else if (pick == 2){
     rm(list=ls(all=TRUE))
     cat("\n")                                                                      
     cat("***********************************************************\n")
     cat("    --Theophylline CR input data information--             \n")
     cat("    Gender = Male=1 ; Female=0                             \n")
     cat("    age = age (yr)                                         \n")
     cat("    ht = height (cm)                                       \n") 
     cat("    CHF = 1 for yes ; otherwise = 0                        \n")
     cat("    smoke = 1 for a amoker ; otherwise 0                   \n") 
     cat("    D = dose for each dosing interval (mg)                 \n") 
     cat("    tau = dosing interval (hr)                             \n")
     cat("    C = measured steady-state conc.                        \n")
     cat("***********************************************************\n\n")
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     ThecrMSpar<-data.frame(subject=c(1,2),Gender=c(0),age=c(0),ht=c(0),CHF=c(0),smoke=c(0),D=c(0),tau=c(0),c=c(0))
     ThecrMSpar<-edit(ThecrMSpar)
     ThecrMSpar<-ymscheck(ThecrMSpar)
     cat("\n")
     Thecr.ms(length(ThecrMSpar$subject),ThecrMSpar$c,ThecrMSpar$tau,ThecrMSpar$D,ThecrMSpar$ht,ThecrMSpar$age,ThecrMSpar$smoke,ThecrMSpar$Gender,ThecrMSpar$CHF)
     cat("\n\n")
     cat("**********************************************************\n")
     cat("   You can PgUp/PgDown to scroll through your checking    \n")
     cat("   convergence plots.                                     \n")  
     cat("**********************************************************\n\n")
     options("graphics.record"=TRUE)
     samplesHistory("*",mfrow=c(3,1), ask = FALSE)
     samplesDensity("*", mfrow = c(3, 2), ask = FALSE)
     samplesAutoC("*",1, mfrow = c(3, 2), ask = FALSE)
     cat("***********************************************************\n")
     cat("    --Theophylline CR output data information--            \n")
     cat("    cl_F = clerance/bioavailability (L/hr)                 \n")
     cat("    Css_pr = predicted steady-state conc.(mg/L)            \n")
     cat("***********************************************************\n")    
     show(samplesStats("*"))
     cat("\n") 
     C<-TheCRcpr(1,ThecrMSpar$D,ThecrMSpar$tau)
     sim<-matrix(C[ ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Css_pr (mg/L)")     
     show(coutput)
     cat("\n")   
     cat("          Pressing Enter to show individual summary report                  \n")
     readline()
     Thecrms.pkoutput(ThecrMSpar,coutput)        
     cal.again()                                                                                                                                             
  } 
  else if (pick == 3){
     cat("\n\n") 
     The.menu()
  }      
}



