% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pk_mods.R
\name{pk_basic_solution_3cpt_metab}
\alias{pk_basic_solution_3cpt_metab}
\title{Solution to three-compartment IV model}
\usage{
pk_basic_solution_3cpt_metab(
  kR,
  k10,
  k12,
  k21,
  k13,
  k31,
  v1,
  v2,
  v3,
  ke0,
  c0 = c(0, 0, 0, 0)
)
}
\arguments{
\item{kR}{Infusion rate (e.g. ml/min).}

\item{k10}{Rate of excretion from central compartment.}

\item{k12}{Rate of transfer from compartment 1 to compartment 2.}

\item{k21}{Rate of transfer from compartment 2 to compartment 1.}

\item{k13}{Rate of transfer from compartment 1 to compartment 3.}

\item{k31}{Rate of transfer from compartment 3 to compartment 1.}

\item{v1}{Volume of compartment 1.}

\item{v2}{Volume of compartment 2.}

\item{v3}{Volume of compartment 3.}

\item{ke0}{Rate of transfer from effect-site compartment to compartment 1.}

\item{c0}{Initial concentrations. Defaults to 0 in each compartment.}
}
\value{
Numeric matrix of concentrations for a constant infusion rate
}
\description{
3 compartment IV infusion with first-order absorption between compartments and with an additional effect-site compartment.
The analytical solutions implemented in this function are provided in "ADVAN-style analytical solutions for common pharmacokinetic models" by
Abuhelwa et al. 2015.
}
\details{
This function takes in arguments for each of the absorption and elimination rate constants of a three-compartment model
as well as initial concentrations, c0. ke0 gives the rate of elimination from the effect-site compartment into the
central compartment (i.e. k41). The rate of absorption into the effect-site compartment is set at 1/10,000 the value of ke0.
The function returns a set of functions that calculate the concentration in each of the four compartments as a function of
time.
}
\examples{
data(eleveld_pk)
data(eleveld_pd)
pk_vars <- c("V1","V2","V3","CL","Q2","Q3")
pd_vars <- c("E50","KE0","EMAX","GAM","GAM1","RESD")
pk_pars <- subset(eleveld_pk, ID == 403, select = pk_vars)
pd_pars <- subset(eleveld_pd, ID == 403, select = pd_vars)

sol <- pk_basic_solution_3cpt_metab(kR = 1,
                                    k10 = pk_pars$CL / pk_pars$V1,
                                    k12 = pk_pars$Q2 / pk_pars$V1,
                                    k21 = pk_pars$Q2 / pk_pars$V2,
                                    k13 = pk_pars$Q3 / pk_pars$V1,
                                    k31 = pk_pars$Q3 / pk_pars$V3,
                                    v1 = pk_pars$V1,
                                    v2 = pk_pars$V2,
                                    v3 = pk_pars$V3,
                                    ke0 = pd_pars$KE0,
                                    c0 = c(0,0,0,0))
# concentration in central and effect site compartments
tms <- seq(0,1,0.1)
cbind(sol$c_1(tms), sol$c_4(tms))
}
