% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pk_mods.R
\name{gen_eleveld_pd_pars}
\alias{gen_eleveld_pd_pars}
\title{Eleveld model PD parameters}
\usage{
gen_eleveld_pd_pars(theta, eta, patient_vars)
}
\arguments{
\item{theta}{Vector of fixed effects}

\item{eta}{Vector of random effects}

\item{patient_vars}{Named list of observed patient characteristics}
}
\value{
Numeric vector of PD parameters for Eleveld propofol model associated
with a set of patient covariates.
}
\description{
Function to generate PD parameters for Eleveld model.
}
\examples{
data(eleveld_pd)
# PD fixed effect values and random effect variances from Eleveld et al. (2018)
eleveld_theta_pd_est <- c(3.08,0.146,93.0,1.47,8.03,0.0517,-0.00635,1.24,1.89)
eleveld_eta_pd_var <- c(0.242,0.702,0.230)
patient_covariates <- subset(eleveld_pd, ID == 403,
select = c("AGE","WGT","HGT","M1F2","PMA","TECH","A1V2"))
gen_eleveld_pd_pars(theta = eleveld_theta_pd_est,
                    eta = eleveld_eta_pd_var,
                    patient_vars = patient_covariates)
}
