% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pkpd_assist.R
\name{restrict_sigmoid}
\alias{restrict_sigmoid}
\title{Restrict target sigmoid values}
\usage{
restrict_sigmoid(t50, tfinal = 10, eps = 1, BIS0 = 100, BISfinal = 50 - eps)
}
\arguments{
\item{t50}{parameter of Emax model}

\item{tfinal}{end of the induction period}

\item{eps}{distance between BISfinal and the target function at tfinal}

\item{BIS0}{starting BIS value}

\item{BISfinal}{asymptote of Emax model}
}
\value{
Returns a numeric vector of Emax sigmoidal parameters restricted to pass through
point (tfinal, BISfinal+eps).
}
\description{
Function to place restriction on gamma and E50 parameters of target sigmoid
such that it passes through point (tfinal, BISfinal+eps)
}
\examples{
dose <- data.frame(time = c(0.5,4,4.5,10), infrt = c(100,0,100,0))
create_intvl(dose)
}
