% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_config_set.R
\name{tar_config_set}
\alias{tar_config_set}
\title{Write configuration settings to _targets.yaml.}
\usage{
tar_config_set(store = NULL)
}
\arguments{
\item{store}{Character of length 1, path to the data store of the pipeline.
If \code{NULL}, the \code{store} setting is left unchanged in \verb{_targets.yaml}.
Usually, the data store lives at \verb{_targets}.
Set \code{store} to a custom directory
to specify a path other than \verb{_targets}. The path need not exist
before the pipeline begins, and it need not end with "_targets",
but it must be writeable.
For optimal performance, choose a storage location
with fast read/write access.}
}
\value{
\code{NULL} (invisibly)
}
\description{
\code{tar_config_set()} writes special custom settings
to an optional \verb{_targets.yaml} configuration file at the
current project. Do not invoke while the pipeline is running.
}
\details{
\verb{_targets.yaml} is an optional YAML configuration file
with settings specific to a given project. You can write it
by hand or modify it with \code{tar_config_set()}.
In order to work properly, \verb{_targets.yaml} must live at the
root of the project (next to \verb{_targets.R}).
The currently supported configuration settings are
documented as the arguments of \code{tar_config_set()}.

\code{tar_config_set()} always writes a \verb{_targets.yaml} file
with a full set of configuration settings even when no
arguments are supplied. To reset options completely,
simply remove \verb{_targets.yaml}.
}
\examples{
if (identical(Sys.getenv("TAR_LONG_EXAMPLES"), "true")) {
tar_dir({ # tar_dir() runs code from a temporary directory.
tar_script(list(tar_target(x, 1 + 1)))
tar_config_get("store") # NULL (data store defaults to "_targets/")
store_path <- tempfile()
tar_config_set(store = store_path)
tar_config_get("store") # Shows a temp file.
tar_make() # Writes to the custom data store identified in _targets.yaml.
tar_read(x) # tar_read() knows about _targets.yaml too.
file.exists("_targets") # FALSE
file.exists(store_path) # TRUE
})
}
}
\seealso{
Other configuration: 
\code{\link{tar_config_get}()},
\code{\link{tar_envvars}()},
\code{\link{tar_option_get}()},
\code{\link{tar_option_reset}()},
\code{\link{tar_option_set}()}
}
\concept{configuration}
