% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_unscript.R
\name{tar_unscript}
\alias{tar_unscript}
\title{Remove target script helper files.}
\usage{
tar_unscript(script = targets::tar_config_get("script"))
}
\arguments{
\item{script}{Character of length 1, path to the
target script file. Defaults to \code{tar_config_get("script")},
which in turn defaults to \verb{_targets.R}. When you set
this argument, the value of \code{tar_config_get("script")}
is temporarily changed for the current function call.
See \code{\link[=tar_script]{tar_script()}},
\code{\link[=tar_config_get]{tar_config_get()}}, and \code{\link[=tar_config_set]{tar_config_set()}} for details
about the target script file and how to set it
persistently for a project.}
}
\value{
\code{NULL} (invisibly).
}
\description{
Remove target script helper files (default: \verb{_targets_r/})
that were created by Target Markdown.
}
\details{
Target Markdown code chunks create R scripts in a folder
called \verb{_targets_r/} in order to aid the automatically supplied
\verb{_targets.R} file. Over time, the number of script files
starts to build up, and \code{targets} has no way of automatically
removing helper script files that are no longer necessary.
To keep your pipeline up to date
with the code chunks in the Target Markdown document(s),
it is good practice to call \code{tar_unscript()} at the beginning
of your first Target Markdown document. That way,
extraneous/discarded targets are automatically
removed from the pipeline when the document starts render.

If the target script is at some alternative path,
e.g. \code{custom/script.R}, the helper scripts are in \verb{custom/script_r/}.
\code{\link[=tar_unscript]{tar_unscript()}} works on the helper scripts as long as your
project configuration settings correctly identify the correct
target script.
}
\examples{
tar_dir({ # tar_dir() runs code from a temporary directory.
tar_unscript()
})
}
