% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_timestamp.R
\name{tar_timestamp}
\alias{tar_timestamp}
\title{Get the timestamp(s) of a target.}
\usage{
tar_timestamp(
  name = NULL,
  format = NULL,
  tz = NULL,
  parse = NULL,
  store = targets::tar_config_get("store")
)
}
\arguments{
\item{name}{Symbol, name of the target. If \code{NULL} (default)
then \code{tar_timestamp()} will attempt to return the timestamp
of the target currently running. Must be called inside a target's
command or a supporting function in order to work.}

\item{format}{Deprecated in \code{targets} version 0.6.0 (2021-07-21).}

\item{tz}{Deprecated in \code{targets} version 0.6.0 (2021-07-21).}

\item{parse}{Deprecated in \code{targets} version 0.6.0 (2021-07-21).}

\item{store}{Character of length 1, path to the
\code{targets} data store. Defaults to \code{tar_config_get("store")},
which in turn defaults to \verb{_targets/}.
When you set this argument, the value of \code{tar_config_get("store")}
is temporarily changed for the current function call.
See \code{\link[=tar_config_get]{tar_config_get()}} and \code{\link[=tar_config_set]{tar_config_set()}} for details
about how to set the data store path persistently
for a project.}
}
\value{
If the target is not recorded in the metadata
or cannot be parsed correctly, then
\code{tar_timestamp()} returns a \code{POSIXct} object at \verb{1970-01-01 UTC}.
}
\description{
Get the timestamp associated with a target's
last successful run.
}
\details{
\code{tar_timestamp()} checks the metadata in \verb{_targets/meta/meta},
not the actual returned data of the target.
The timestamp depends on the storage format of the target.
If storage is local, e.g. formats like \code{"rds"} and \code{"file"},
then the time stamp is the latest modification time
of the target data files at the time the target
last successfully ran. For non-local formats like
\code{"aws_rds"} and \code{"url"}, then \code{targets} chooses instead
to simply record the time the target last successfully ran.
}
\examples{
if (identical(Sys.getenv("TAR_EXAMPLES"), "true")) {
tar_dir({ # tar_dir() runs code from a temporary directory.
tar_script({
  list(tar_target(x, 1))
}, ask = FALSE)
tar_make()
# Get the timestamp.
tar_timestamp(x)
# We can use the timestamp to cancel the target
# if it already ran within the last hour.
# Be sure to set `cue = tar_cue(mode = "always")`
# if you want the target to always check the timestamp.
tar_script({
  list(
  tar_target(
    x,
    tar_cancel((Sys.time() - tar_timestamp()) < 3600),
    cue = tar_cue(mode = "always")
  )
)}, ask = FALSE)
tar_make()
})
}
}
\seealso{
Other time: 
\code{\link{tar_newer}()},
\code{\link{tar_older}()},
\code{\link{tar_timestamp_raw}()}
}
\concept{time}
