% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_age.R
\name{tar_age}
\alias{tar_age}
\title{Create a target that runs when the last run gets old}
\usage{
tar_age(
  name,
  command,
  age,
  pattern = NULL,
  tidy_eval = targets::tar_option_get("tidy_eval"),
  packages = targets::tar_option_get("packages"),
  library = targets::tar_option_get("library"),
  format = targets::tar_option_get("format"),
  repository = targets::tar_option_get("repository"),
  iteration = targets::tar_option_get("iteration"),
  error = targets::tar_option_get("error"),
  memory = targets::tar_option_get("memory"),
  garbage_collection = targets::tar_option_get("garbage_collection"),
  deployment = targets::tar_option_get("deployment"),
  priority = targets::tar_option_get("priority"),
  resources = targets::tar_option_get("resources"),
  storage = targets::tar_option_get("storage"),
  retrieval = targets::tar_option_get("retrieval"),
  cue = targets::tar_option_get("cue"),
  description = targets::tar_option_get("description")
)
}
\arguments{
\item{name}{Name of the target.
\code{tar_cue_age()} expects an unevaluated symbol for the \code{name}
argument, whereas \code{tar_cue_age_raw()} expects a character string
for \code{name}.}

\item{command}{R code to run the target and return a value.}

\item{age}{A \code{difftime} object of length 1, such as
\code{as.difftime(3, units = "days")}. If the target's output data
files are older than \code{age} (according to the most recent
time stamp over all the target's output files)
then the target will rerun.
On the other hand, if at least one data file is
younger than \code{Sys.time() - age}, then the ordinary
invalidation rules apply, and the target may or not rerun.
If you want to force the target to run every 3 days,
for example, set \code{age = as.difftime(3, units = "days")}.}

\item{pattern}{Code to define a dynamic branching branching for a target.
In \code{\link[targets:tar_target]{tar_target()}}, \code{pattern} is an unevaluated expression, e.g.
\code{tar_target(pattern = map(data))}.
In \code{\link[targets:tar_target_raw]{tar_target_raw()}}, \code{command} is an evaluated expression, e.g.
\code{tar_target_raw(pattern = quote(map(data)))}.

To demonstrate dynamic branching patterns, suppose we have
a pipeline with numeric vector targets \code{x} and \code{y}. Then,
\code{tar_target(z, x + y, pattern = map(x, y))} implicitly defines
branches of \code{z} that each compute \code{x[1] + y[1]}, \code{x[2] + y[2]},
and so on. See the user manual for details.}

\item{tidy_eval}{Logical, whether to enable tidy evaluation
when interpreting \code{command} and \code{pattern}. If \code{TRUE}, you can use the
"bang-bang" operator \verb{!!} to programmatically insert
the values of global objects.}

\item{packages}{Character vector of packages to load right before
the target runs or the output data is reloaded for
downstream targets. Use \code{tar_option_set()} to set packages
globally for all subsequent targets you define.}

\item{library}{Character vector of library paths to try
when loading \code{packages}.}

\item{format}{Logical, whether to rerun the target if the user-specified
storage format changed. The storage format is user-specified through
\code{\link[targets:tar_target]{tar_target()}} or \code{\link[targets:tar_option_set]{tar_option_set()}}.}

\item{repository}{Logical, whether to rerun the target if the user-specified
storage repository changed. The storage repository is user-specified
through \code{\link[targets:tar_target]{tar_target()}} or \code{\link[targets:tar_option_set]{tar_option_set()}}.}

\item{iteration}{Logical, whether to rerun the target if the user-specified
iteration method changed. The iteration method is user-specified through
\code{\link[targets:tar_target]{tar_target()}} or \code{\link[targets:tar_option_set]{tar_option_set()}}.}

\item{error}{Character of length 1, what to do if the target
stops and throws an error. Options:
\itemize{
\item \code{"stop"}: the whole pipeline stops and throws an error.
\item \code{"continue"}: the whole pipeline keeps going.
\item \code{"null"}: The errored target continues and returns \code{NULL}.
The data hash is deliberately wrong so the target is not
up to date for the next run of the pipeline. In addition,
as of \code{targets} version 1.8.0.9011, a value of \code{NULL} is given
to upstream dependencies with \code{error = "null"} if loading fails.
\item \code{"abridge"}: any currently running targets keep running,
but no new targets launch after that.
\item \code{"trim"}: all currently running targets stay running. A queued
target is allowed to start if:
\enumerate{
\item It is not downstream of the error, and
\item It is not a sibling branch from the same \code{\link[targets:tar_target]{tar_target()}} call
(if the error happened in a dynamic branch).
}

The idea is to avoid starting any new work that the immediate error
impacts. \code{error = "trim"} is just like \code{error = "abridge"},
but it allows potentially healthy regions of the dependency graph
to begin running.
(Visit \url{https://books.ropensci.org/targets/debugging.html}
to learn how to debug targets using saved workspaces.)
}}

\item{memory}{Character of length 1, memory strategy. Possible values:
\itemize{
\item \code{"auto"} (default): equivalent to \code{memory = "transient"} in almost
all cases. But to avoid superfluous reads from disk,
\code{memory = "auto"} is equivalent to \code{memory = "persistent"} for
for non-dynamically-branched targets that other targets
dynamically branch over. For example: if your pipeline has
\code{tar_target(name = y, command = x, pattern = map(x))},
then \code{tar_target(name = x, command = f(), memory = "auto")}
will use persistent memory in order to avoid rereading all of \code{x}
for every branch of \code{y}.
\item \code{"transient"}: the target gets unloaded
after every new target completes.
Either way, the target gets automatically loaded into memory
whenever another target needs the value.
\item \code{"persistent"}: the target stays in memory
until the end of the pipeline (unless \code{storage} is \code{"worker"},
in which case \code{targets} unloads the value from memory
right after storing it in order to avoid sending
copious data over a network).
}

For cloud-based file targets
(e.g. \code{format = "file"} with \code{repository = "aws"}),
the \code{memory} option applies to the
temporary local copy of the file:
\code{"persistent"} means it remains until the end of the pipeline
and is then deleted,
and \code{"transient"} means it gets deleted as soon as possible.
The former conserves bandwidth,
and the latter conserves local storage.}

\item{garbage_collection}{Logical: \code{TRUE} to run \code{base::gc()}
just before the target runs, in whatever R process it is about to run
(which could be a parallel worker).
\code{FALSE} to omit garbage collection.
Numeric values get converted to \code{FALSE}.
The \code{garbage_collection} option in \code{\link[targets:tar_option_set]{tar_option_set()}}
is independent of the
argument of the same name in \code{\link[targets:tar_target]{tar_target()}}.}

\item{deployment}{Character of length 1. If \code{deployment} is
\code{"main"}, then the target will run on the central controlling R process.
Otherwise, if \code{deployment} is \code{"worker"} and you set up the pipeline
with distributed/parallel computing, then
the target runs on a parallel worker. For more on distributed/parallel
computing in \code{targets}, please visit
\url{https://books.ropensci.org/targets/crew.html}.}

\item{priority}{Deprecated on 2025-04-08 (\code{targets} version 1.10.1.9013).
\code{targets} has moved to a more efficient scheduling algorithm
(\url{https://github.com/ropensci/targets/issues/1458})
which cannot support priorities.
The \code{priority} argument of \code{\link[targets:tar_target]{tar_target()}} no longer has a reliable
effect on execution order.}

\item{resources}{Object returned by \code{tar_resources()}
with optional settings for high-performance computing
functionality, alternative data storage formats,
and other optional capabilities of \code{targets}.
See \code{tar_resources()} for details.}

\item{storage}{Character string to control when the output of the target
is saved to storage. Only relevant when using \code{targets}
with parallel workers (\url{https://books.ropensci.org/targets/crew.html}).
Must be one of the following values:
\itemize{
\item \code{"worker"} (default): the worker saves/uploads the value.
\item \code{"main"}: the target's return value is sent back to the
host machine and saved/uploaded locally.
\item \code{"none"}: \code{targets} makes no attempt to save the result
of the target to storage in the location where \code{targets}
expects it to be. Saving to storage is the responsibility
of the user. Use with caution.
}}

\item{retrieval}{Character string to control when the current target
loads its dependencies into memory before running.
(Here, a "dependency" is another target upstream that the current one
depends on.) Only relevant when using \code{targets}
with parallel workers (\url{https://books.ropensci.org/targets/crew.html}).
Must be one of the following values:
\itemize{
\item \code{"auto"} (default): equivalent to \code{retrieval = "worker"} in almost all
cases. But to avoid unnecessary reads from disk, \code{retrieval = "auto"}
is equivalent to \code{retrieval = "main"} for dynamic branches that
branch over non-dynamic targets. For example: if your pipeline has
\code{tar_target(x, command = f())}, then
\code{tar_target(y, command = x, pattern = map(x), retrieval = "auto")}
will use \code{"main"} retrieval in order to avoid rereading all of \code{x}
for every branch of \code{y}.
\item \code{"worker"}: the worker loads the target's dependencies.
\item \code{"main"}: the target's dependencies are loaded on the host machine
and sent to the worker before the target runs.
\item \code{"none"}: \code{targets} makes no attempt to load its
dependencies. With \code{retrieval = "none"}, loading dependencies
is the responsibility of the user. Use with caution.
}}

\item{cue}{A \code{targets::tar_cue()} object. (See the "Cue objects"
section for background.) This cue object should contain any
optional secondary invalidation rules, anything except
the \code{mode} argument. \code{mode} will be automatically determined
by the \code{age} argument of \code{tar_age()}.}

\item{description}{Character of length 1, a custom free-form human-readable
text description of the target. Descriptions appear as target labels
in functions like \code{\link[targets:tar_manifest]{tar_manifest()}} and \code{\link[targets:tar_visnetwork]{tar_visnetwork()}},
and they let you select subsets of targets for the \code{names} argument of
functions like \code{\link[targets:tar_make]{tar_make()}}. For example,
\code{tar_manifest(names = tar_described_as(starts_with("survival model")))}
lists all the targets whose descriptions start with the character
string \code{"survival model"}.}
}
\value{
A target object. See the "Target objects" section for background.
}
\description{
\code{tar_age()} creates a target that reruns
itself when it gets old enough.
In other words, the target reruns periodically at regular
intervals of time.
}
\details{
\code{tar_age()} uses the cue from \code{\link[=tar_cue_age]{tar_cue_age()}}, which
uses the time stamps from \code{targets::tar_meta()$time}.
See the help file of \code{targets::tar_timestamp()}
for an explanation of how this time stamp is calculated.
}
\section{Dynamic branches at regular time intervals}{

Time stamps are not recorded for whole dynamic targets,
so \code{tar_age()} is not a good fit for dynamic branching.
To invalidate dynamic branches at regular intervals,
it is recommended to use \code{targets::tar_older()} in combination
with \code{targets::tar_invalidate()} right before calling \code{tar_make()}.
For example,
\code{tar_invalidate(any_of(tar_older(Sys.time - as.difftime(1, units = "weeks"))))} # nolint
invalidates all targets more than a week old. Then, the next \code{tar_make()}
will rerun those targets.
}

\section{Target objects}{

Most \code{tarchetypes} functions are target factories,
which means they return target objects
or lists of target objects.
Target objects represent skippable steps of the analysis pipeline
as described at \url{https://books.ropensci.org/targets/}.
Please read the walkthrough at
\url{https://books.ropensci.org/targets/walkthrough.html}
to understand the role of target objects in analysis pipelines.

For developers,
\url{https://wlandau.github.io/targetopia/contributing.html#target-factories}
explains target factories (functions like this one which generate targets)
and the design specification at
\url{https://books.ropensci.org/targets-design/}
details the structure and composition of target objects.
}

\examples{
if (identical(Sys.getenv("TAR_LONG_EXAMPLES"), "true")) {
targets::tar_dir({ # tar_dir() runs code from a temporary directory.
targets::tar_script({
  library(tarchetypes)
  list(
    tarchetypes::tar_age(
      data,
      data.frame(x = seq_len(26)),
      age = as.difftime(0.5, units = "secs")
    )
  )
})
targets::tar_make()
Sys.sleep(0.6)
targets::tar_make()
})
}
}
\seealso{
Other cues: 
\code{\link{tar_cue_age}()},
\code{\link{tar_cue_force}()},
\code{\link{tar_cue_skip}()}
}
\concept{cues}
