% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compile-cell.R
\name{cell}
\alias{cell}
\title{Construct a table cell from an object}
\usage{
cell(x, ...)
}
\arguments{
\item{x}{R object to attach attributes too}

\item{...}{Each additional argument becomes an attribute for the object}
}
\value{
The modified R object
}
\description{
Any R object can be used as a cell value. Attributes
are used to store additional classs of that cell
attached to the object. This is a helper function
to attach all the additional attributes to the
provided object
}
\details{
Certain attributes have special meaning:
- 'names' is appended to the front of a value, e.g. "P=" for a p-value.
- 'sep' is used to join values, e.g. ", " for a list of values.
- 'class' denotes special rendering handling, e.g. generally passed as CSS class to HTML5
- 'reference' a list of reference symbols to put inside the cell
- 'row' and 'col' should refer to the row / column if key generation is needed
- 'subrow' and 'subcol' further delinate the key value of a cell for key generation
}
