% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractors.R
\name{method_selector}
\alias{method_selector}
\title{Method Selector}
\usage{
method_selector(clustering, only, additional_data = NULL)
}
\arguments{
\item{only}{<\code{\link[dplyr:dplyr_data_masking]{data-masking}}> Expressions that
return a logical value, and are defined in terms of the variables in
\code{object} and/or \code{additional_data}.

The default \code{NULL} selects all clusterings in \code{object}.}

\item{additional_data}{A data frame with additional data that may be
(left-)joined onto the \code{parameters} in \code{object}. This is often
used in conjuction with \code{only} to select specific clusterings based on
\code{additional_data}.}
}
\value{
A \code{parameters} data frame with at least the following columns
\itemize{
\item \code{cluster_name} the name of the clustering cluster_name.
\item \code{clustering} the name of the clustering group before the number of
clusters is chosen.
\item \code{linkage} the linkage criteria.
\item \code{alpha} the normalization tuning.
\item \code{beta} the timing importance tuning.
\item \code{gamma} the dose importance tuning.
\item \code{theta} the ATC measure tuning.
\item \code{k} the number of clusters.
}

where each row specifies the parameters for the chosen methods. Any
additional columns present in the the outcome are from the
\code{additional_data}.
}
\description{
The \code{method_selector()} is a filtering function for extracting only the
relevant \code{parameters} from a <\code{medic}> object.
}
\details{
The \code{method_selector()} function is a filtering function used for extracting
the characteristics of the chosen method. This function is used in all of
the investigative functions called by \code{\link[=summary]{summary()}}.
}
\seealso{
\code{\link[=cluster_selector]{cluster_selector()}} is another selector method used through out
the package.
}
\keyword{internal}
