helpContent <- function(){
  importmenu <- "
<body lang=IT link=blue vlink='#96607D' style='tab-interval:35.4pt;word-wrap:
  break-word'>

<div class=WordSection1>

<p class=MsoNormal style='mso-margin-top-alt:auto;mso-margin-bottom-alt:auto;
mso-outline-level:3'><b><span lang=EN-US style='font-size:14.0pt;font-family:
  'Times New Roman',serif;mso-fareast-font-family:'Times New Roman';color:black;
mso-font-kerning:0pt;mso-ligatures:none;mso-ansi-language:EN-US;mso-fareast-language:
  IT'>Import<o:p></o:p></span></b></p>

<p class=MsoNormal style='mso-margin-top-alt:auto;mso-margin-bottom-alt:auto;
text-align:justify'><span lang=EN-US style='font-family:'Times New Roman',serif;
mso-fareast-font-family:'Times New Roman';color:black;mso-font-kerning:0pt;
mso-ligatures:none;mso-ansi-language:EN-US;mso-fareast-language:IT'>TALL allows
importing one or multiple text files in various formats for immediate and
flexible analysis. <o:p></o:p></span></p>

<p class=MsoNormal style='mso-margin-top-alt:auto;mso-margin-bottom-alt:auto;
text-align:justify'><span lang=EN-US style='font-family:'Times New Roman',serif;
mso-fareast-font-family:'Times New Roman';color:black;mso-font-kerning:0pt;
mso-ligatures:none;mso-ansi-language:EN-US;mso-fareast-language:IT'>Follow
these steps:<o:p></o:p></span></p>

<p class=MsoNormal style='mso-margin-top-alt:auto;mso-margin-bottom-alt:auto;
mso-outline-level:3'><b><span lang=EN-US style='font-size:14.0pt;font-family:
  'Times New Roman',serif;mso-fareast-font-family:'Times New Roman';color:black;
mso-font-kerning:0pt;mso-ligatures:none;mso-ansi-language:EN-US;mso-fareast-language:
  IT'>Supported Formats<o:p></o:p></span></b></p>

<ol start=1 type=1>
 <li class=MsoNormal style='color:black;mso-margin-top-alt:auto;mso-margin-bottom-alt:
  auto;mso-list:l0 level1 lfo1;tab-stops:list 36.0pt'><b><span lang=EN-US
     style='font-family:'Times New Roman',serif;mso-fareast-font-family:'Times New Roman';
mso-font-kerning:0pt;mso-ligatures:none;mso-ansi-language:EN-US;
mso-fareast-language:IT'>Plain Text</span></b><span lang=EN-US
     style='font-family:'Times New Roman',serif;mso-fareast-font-family:'Times New Roman';
mso-font-kerning:0pt;mso-ligatures:none;mso-ansi-language:EN-US;
mso-fareast-language:IT'>&nbsp;(</span><span lang=EN-US style='font-size:
  10.0pt;font-family:'Times New Roman',serif;mso-fareast-font-family:'Times New Roman';
mso-font-kerning:0pt;mso-ligatures:none;mso-ansi-language:EN-US;
mso-fareast-language:IT'>.txt</span><span lang=EN-US style='font-family:
  'Times New Roman',serif;mso-fareast-font-family:'Times New Roman';
mso-font-kerning:0pt;mso-ligatures:none;mso-ansi-language:EN-US;
mso-fareast-language:IT'>): Text files can be imported in different
     scenarios:<o:p></o:p></span></li>
 <ul type=circle>
  <li class=MsoNormal style='color:black;mso-margin-top-alt:auto;mso-margin-bottom-alt:
  auto;mso-list:l0 level2 lfo1;tab-stops:list 72.0pt'><b><span lang=EN-US
      style='font-family:'Times New Roman',serif;mso-fareast-font-family:'Times New Roman';
mso-font-kerning:0pt;mso-ligatures:none;mso-ansi-language:EN-US;
mso-fareast-language:IT'>A single file containing a single document</span></b><span
      lang=EN-US style='font-family:'Times New Roman',serif;mso-fareast-font-family:
  'Times New Roman';mso-font-kerning:0pt;mso-ligatures:none;mso-ansi-language:
  EN-US;mso-fareast-language:IT'>: Suitable for straightforward analysis of
      one text.<o:p></o:p></span></li>
  <li class=MsoNormal style='color:black;mso-margin-top-alt:auto;mso-margin-bottom-alt:
  auto;mso-list:l0 level2 lfo1;tab-stops:list 72.0pt'><b><span lang=EN-US
      style='font-family:'Times New Roman',serif;mso-fareast-font-family:'Times New Roman';
mso-font-kerning:0pt;mso-ligatures:none;mso-ansi-language:EN-US;
mso-fareast-language:IT'>Single file with multiple documents divided by
      alphanumeric codes</span></b><span lang=EN-US style='font-family:'Times New Roman',serif;
mso-fareast-font-family:'Times New Roman';mso-font-kerning:0pt;
mso-ligatures:none;mso-ansi-language:EN-US;mso-fareast-language:IT'>&nbsp;(e.g.,&nbsp;</span><span
      lang=EN-US style='font-size:10.0pt;font-family:'Times New Roman',serif;
mso-fareast-font-family:'Times New Roman';mso-font-kerning:0pt;
mso-ligatures:none;mso-ansi-language:EN-US;mso-fareast-language:IT'>Chapter</span><span
      lang=EN-US style='font-family:'Times New Roman',serif;mso-fareast-font-family:
  'Times New Roman';mso-font-kerning:0pt;mso-ligatures:none;mso-ansi-language:
  EN-US;mso-fareast-language:IT'>,&nbsp;</span><span lang=EN-US
      style='font-size:10.0pt;font-family:'Times New Roman',serif;mso-fareast-font-family:
  'Times New Roman';mso-font-kerning:0pt;mso-ligatures:none;mso-ansi-language:
  EN-US;mso-fareast-language:IT'>0001</span><span lang=EN-US
      style='font-family:'Times New Roman',serif;mso-fareast-font-family:'Times New Roman';
mso-font-kerning:0pt;mso-ligatures:none;mso-ansi-language:EN-US;
mso-fareast-language:IT'>,&nbsp;</span><span lang=EN-US style='font-size:
  10.0pt;font-family:'Times New Roman',serif;mso-fareast-font-family:'Times New Roman';
mso-font-kerning:0pt;mso-ligatures:none;mso-ansi-language:EN-US;
mso-fareast-language:IT'>****</span><span lang=EN-US style='font-family:
  'Times New Roman',serif;mso-fareast-font-family:'Times New Roman';
mso-font-kerning:0pt;mso-ligatures:none;mso-ansi-language:EN-US;
mso-fareast-language:IT'>):<o:p></o:p></span></li>
  <ul type=square>
   <li class=MsoNormal style='color:black;mso-margin-top-alt:auto;mso-margin-bottom-alt:
  auto;mso-list:l0 level3 lfo1;tab-stops:list 108.0pt'><span lang=EN-US
       style='font-family:'Times New Roman',serif;mso-fareast-font-family:'Times New Roman';
mso-font-kerning:0pt;mso-ligatures:none;mso-ansi-language:EN-US;
mso-fareast-language:IT'>TALL recognizes these separators and allows
       further splitting using the&nbsp;<b>Edit -&gt; Split</b>&nbsp;menu.<o:p></o:p></span></li>
  </ul>
  <li class=MsoNormal style='color:black;mso-margin-top-alt:auto;mso-margin-bottom-alt:
  auto;mso-list:l0 level2 lfo1;tab-stops:list 72.0pt'><b><span lang=EN-US
      style='font-family:'Times New Roman',serif;mso-fareast-font-family:'Times New Roman';
mso-font-kerning:0pt;mso-ligatures:none;mso-ansi-language:EN-US;
mso-fareast-language:IT'>Multiple&nbsp;</span></b><b><span lang=EN-US
      style='font-size:10.0pt;font-family:'Times New Roman',serif;mso-fareast-font-family:
  'Times New Roman';mso-font-kerning:0pt;mso-ligatures:none;mso-ansi-language:
  EN-US;mso-fareast-language:IT'>.txt</span></b><b><span lang=EN-US
      style='font-family:'Times New Roman',serif;mso-fareast-font-family:'Times New Roman';
mso-font-kerning:0pt;mso-ligatures:none;mso-ansi-language:EN-US;
mso-fareast-language:IT'>&nbsp;files where each file is a single document</span></b><span
      lang=EN-US style='font-family:'Times New Roman',serif;mso-fareast-font-family:
  'Times New Roman';mso-font-kerning:0pt;mso-ligatures:none;mso-ansi-language:
  EN-US;mso-fareast-language:IT'>:<o:p></o:p></span></li>
  <ul type=square>
   <li class=MsoNormal style='color:black;mso-margin-top-alt:auto;mso-margin-bottom-alt:
  auto;mso-list:l0 level3 lfo1;tab-stops:list 108.0pt'><span lang=EN-US
       style='font-family:'Times New Roman',serif;mso-fareast-font-family:'Times New Roman';
mso-font-kerning:0pt;mso-ligatures:none;mso-ansi-language:EN-US;
mso-fareast-language:IT'>Users can either select all files from a folder
       or import a zipped folder.<o:p></o:p></span></li>
   <li class=MsoNormal style='color:black;mso-margin-top-alt:auto;mso-margin-bottom-alt:
  auto;mso-list:l0 level3 lfo1;tab-stops:list 108.0pt'><span lang=EN-US
       style='font-family:'Times New Roman',serif;mso-fareast-font-family:'Times New Roman';
mso-font-kerning:0pt;mso-ligatures:none;mso-ansi-language:EN-US;
mso-fareast-language:IT'>Each document will be assigned an ID
       corresponding to the file name.<o:p></o:p></span></li>
  </ul>
 </ul>
 <li class=MsoNormal style='color:black;mso-margin-top-alt:auto;mso-margin-bottom-alt:
  auto;mso-list:l0 level1 lfo1;tab-stops:list 36.0pt'><b><span lang=EN-US
     style='font-family:'Times New Roman',serif;mso-fareast-font-family:'Times New Roman';
mso-font-kerning:0pt;mso-ligatures:none;mso-ansi-language:EN-US;
mso-fareast-language:IT'>Tabular Data</span></b><span lang=EN-US
     style='font-family:'Times New Roman',serif;mso-fareast-font-family:'Times New Roman';
mso-font-kerning:0pt;mso-ligatures:none;mso-ansi-language:EN-US;
mso-fareast-language:IT'>&nbsp;(</span><span lang=EN-US style='font-size:
  10.0pt;font-family:'Times New Roman',serif;mso-fareast-font-family:'Times New Roman';
mso-font-kerning:0pt;mso-ligatures:none;mso-ansi-language:EN-US;
mso-fareast-language:IT'>.csv</span><span lang=EN-US style='font-family:
  'Times New Roman',serif;mso-fareast-font-family:'Times New Roman';
mso-font-kerning:0pt;mso-ligatures:none;mso-ansi-language:EN-US;
mso-fareast-language:IT'>,&nbsp;</span><span lang=EN-US style='font-size:
  10.0pt;font-family:'Times New Roman',serif;mso-fareast-font-family:'Times New Roman';
mso-font-kerning:0pt;mso-ligatures:none;mso-ansi-language:EN-US;
mso-fareast-language:IT'>.xlsx</span><span lang=EN-US style='font-family:
  'Times New Roman',serif;mso-fareast-font-family:'Times New Roman';
mso-font-kerning:0pt;mso-ligatures:none;mso-ansi-language:EN-US;
mso-fareast-language:IT'>) - Suitable for structured datasets, such as reviews,
     tweets, or survey responses.<o:p></o:p></span></li>
 <ul type=circle>
  <li class=MsoNormal style='color:black;mso-margin-top-alt:auto;mso-margin-bottom-alt:
  auto;mso-list:l0 level2 lfo1;tab-stops:list 72.0pt'><span lang=EN-US
      style='font-family:'Times New Roman',serif;mso-fareast-font-family:'Times New Roman';
mso-font-kerning:0pt;mso-ligatures:none;mso-ansi-language:EN-US;
mso-fareast-language:IT'>Text to analyze should be in a dedicated column named
      “text”.<o:p></o:p></span></li>
  <li class=MsoNormal style='color:black;mso-margin-top-alt:auto;mso-margin-bottom-alt:
  auto;mso-list:l0 level2 lfo1;tab-stops:list 72.0pt'><span lang=EN-US
      style='font-family:'Times New Roman',serif;mso-fareast-font-family:'Times New Roman';
mso-font-kerning:0pt;mso-ligatures:none;mso-ansi-language:EN-US;
mso-fareast-language:IT'>Each row is treated as an individual document.<o:p></o:p></span></li>
 </ul>
 <li class=MsoNormal style='color:black;mso-margin-top-alt:auto;mso-margin-bottom-alt:
  auto;mso-list:l0 level1 lfo1;tab-stops:list 36.0pt'><b><span lang=EN-US
     style='font-family:'Times New Roman',serif;mso-fareast-font-family:'Times New Roman';
mso-font-kerning:0pt;mso-ligatures:none;mso-ansi-language:EN-US;
mso-fareast-language:IT'>Documents</span></b><span lang=EN-US
     style='font-family:'Times New Roman',serif;mso-fareast-font-family:'Times New Roman';
mso-font-kerning:0pt;mso-ligatures:none;mso-ansi-language:EN-US;
mso-fareast-language:IT'>&nbsp;(</span><span lang=EN-US style='font-size:
  10.0pt;font-family:'Times New Roman',serif;mso-fareast-font-family:'Times New Roman';
mso-font-kerning:0pt;mso-ligatures:none;mso-ansi-language:EN-US;
mso-fareast-language:IT'>.pdf</span><span lang=EN-US style='font-family:
  'Times New Roman',serif;mso-fareast-font-family:'Times New Roman';
mso-font-kerning:0pt;mso-ligatures:none;mso-ansi-language:EN-US;
mso-fareast-language:IT'>) - Ideal for importing reports, articles or
     books.<o:p></o:p></span></li>
 <ul type=circle>
  <li class=MsoNormal style='color:black;mso-margin-top-alt:auto;mso-margin-bottom-alt:
  auto;mso-list:l0 level2 lfo1;tab-stops:list 72.0pt'><span lang=EN-US
      style='font-family:'Times New Roman',serif;mso-fareast-font-family:'Times New Roman';
mso-font-kerning:0pt;mso-ligatures:none;mso-ansi-language:EN-US;
mso-fareast-language:IT'>TALL extracts text automatically but may require
      pre-processing for image-only or complex-layout PDFs.<o:p></o:p></span></li>
 </ul>
</ol>

<p class=MsoNormal style='mso-margin-top-alt:auto;mso-margin-bottom-alt:auto;
mso-outline-level:3'><b><span lang=EN-US style='font-size:14.0pt;font-family:
  'Times New Roman',serif;mso-fareast-font-family:'Times New Roman';color:black;
mso-font-kerning:0pt;mso-ligatures:none;mso-ansi-language:EN-US;mso-fareast-language:
  IT'>TALL Structured Files<o:p></o:p></span></b></p>

<p class=MsoNormal style='mso-margin-top-alt:auto;mso-margin-bottom-alt:auto'><span
lang=EN-US style='font-family:'Times New Roman',serif;mso-fareast-font-family:
  'Times New Roman';color:black;mso-font-kerning:0pt;mso-ligatures:none;
mso-ansi-language:EN-US;mso-fareast-language:IT'>TALL allows you to save your
progress and continue later by using <span class=GramE>“.tall</span>”&nbsp;structured
files:<o:p></o:p></span></p>

<ul type=disc>
 <li class=MsoNormal style='color:black;mso-margin-top-alt:auto;mso-margin-bottom-alt:
  auto;mso-list:l1 level1 lfo2;tab-stops:list 36.0pt'><b><span lang=EN-US
     style='font-family:'Times New Roman',serif;mso-fareast-font-family:'Times New Roman';
mso-font-kerning:0pt;mso-ligatures:none;mso-ansi-language:EN-US;
mso-fareast-language:IT'>Save Progress:</span></b><span lang=EN-US
     style='font-family:'Times New Roman',serif;mso-fareast-font-family:'Times New Roman';
mso-font-kerning:0pt;mso-ligatures:none;mso-ansi-language:EN-US;
mso-fareast-language:IT'>&nbsp;Export your session as a&nbsp;</span><span
     lang=EN-US style='font-size:10.0pt;font-family:'Times New Roman',serif;
mso-fareast-font-family:'Times New Roman';mso-font-kerning:0pt;mso-ligatures:
  none;mso-ansi-language:EN-US;mso-fareast-language:IT'>.tall</span><span
     lang=EN-US style='font-family:'Times New Roman',serif;mso-fareast-font-family:
  'Times New Roman';mso-font-kerning:0pt;mso-ligatures:none;mso-ansi-language:
  EN-US;mso-fareast-language:IT'>&nbsp;file to preserve imported data,
     configurations, and analysis steps.<o:p></o:p></span></li>
 <li class=MsoNormal style='color:black;mso-margin-top-alt:auto;mso-margin-bottom-alt:
  auto;mso-list:l1 level1 lfo2;tab-stops:list 36.0pt'><b><span lang=EN-US
     style='font-family:'Times New Roman',serif;mso-fareast-font-family:'Times New Roman';
mso-font-kerning:0pt;mso-ligatures:none;mso-ansi-language:EN-US;
mso-fareast-language:IT'>Load Files:</span></b><span lang=EN-US
     style='font-family:'Times New Roman',serif;mso-fareast-font-family:'Times New Roman';
mso-font-kerning:0pt;mso-ligatures:none;mso-ansi-language:EN-US;
mso-fareast-language:IT'>&nbsp;Reimport a&nbsp;</span><span lang=EN-US
     style='font-size:10.0pt;font-family:'Times New Roman',serif;mso-fareast-font-family:
  'Times New Roman';mso-font-kerning:0pt;mso-ligatures:none;mso-ansi-language:
  EN-US;mso-fareast-language:IT'>.tall</span><span lang=EN-US
     style='font-family:'Times New Roman',serif;mso-fareast-font-family:'Times New Roman';
mso-font-kerning:0pt;mso-ligatures:none;mso-ansi-language:EN-US;
mso-fareast-language:IT'>&nbsp;file to resume your work anytime.<o:p></o:p></span></li>
</ul>

<p class=MsoNormal><span lang=EN-US style='mso-ansi-language:EN-US'><o:p>&nbsp;</o:p></span></p>

</div>

</body>
"

  multiwordcreation <- "
<body lang=IT style='tab-interval:35.4pt;word-wrap:break-word'>

<div class=WordSection1>

<p class=MsoNormal><b><span lang=EN-US style='font-size:14.0pt;font-family:
'Times New Roman',serif;mso-ansi-language:EN-US'>Multiword Creation <o:p></o:p></span></b></p>

<p class=MsoNormal><span lang=EN-US style='font-family:'Times New Roman',serif;
mso-ansi-language:EN-US'><o:p>&nbsp;</o:p></span></p>

<p class=MsoNormal style='text-align:justify'><span lang=EN-US
style='font-family:'Times New Roman',serif;mso-ansi-language:EN-US'>TALL
performs a <i>Rapid Automatic Keyword Extraction</i> (RAKE) algorithm (Rose <i>et
al.</i>, 2010) that uses a delimiter-based approach to identify candidate
keywords and scores them using word co-occurrences that appear in the candidate
keywords.<o:p></o:p></span></p>

<p class=MsoNormal style='text-align:justify'><span lang=EN-US
style='font-family:'Times New Roman',serif;mso-ansi-language:EN-US'><o:p>&nbsp;</o:p></span></p>

<p class=MsoNormal style='text-align:justify'><b><span lang=EN-US
style='font-size:14.0pt;font-family:'Times New Roman',serif;mso-ansi-language:
EN-US'><o:p>&nbsp;</o:p></span></b></p>

<p class=MsoNormal style='text-align:justify'><b><span lang=EN-US
style='font-size:14.0pt;font-family:'Times New Roman',serif;mso-ansi-language:
EN-US'>References<o:p></o:p></span></b></p>

<p class=MsoNormal style='text-align:justify'><span lang=EN-US
style='font-family:'Times New Roman',serif;mso-ansi-language:EN-US'><o:p>&nbsp;</o:p></span></p>

<p class=References><span lang=EN-US style='font-family:'Times New Roman',serif'>Rose
S., Engel D., Cramer N. and Cowley W. (2010). Automatic keyword extraction from
individual documents, Wiley Online Library, 1-20 <o:p></o:p></span></p>

<p class=MsoNormal><span lang=EN-US style='mso-ansi-language:EN-US'><o:p>&nbsp;</o:p></span></p>

</div>

</body>
"

  reinert <- "
  <body lang=IT link='#467886' vlink='#96607D' style='tab-interval:35.4pt;
word-wrap:break-word'>

  <div class=WordSection1>

    <p class=MsoNormal><span class=SpellE><b><span style='font-size:14.0pt;
font-family:'Times New Roman',serif'>References</span></b></span><b><span
    style='font-size:14.0pt;font-family:'Times New Roman',serif'><o:p></o:p></span></b></p>

      <p class=MsoNormal><span class=SpellE><span style='font-family:'Times New Roman',serif'>Reinert</span></span><span
    style='font-family:'Times New Roman',serif'> M, <i>Une <span class=SpellE>méthode</span>
      de <span class=SpellE>classification</span> <span class=SpellE>descendante</span>
      <span class=SpellE><span class=GramE>hiérarchique</span></span><span
    class=GramE> :</span> <span class=SpellE>application</span> à l'<span
class=SpellE>analyse</span> <span class=SpellE>lexicale</span> par <span
class=SpellE>contexte</span></i>, <b>Cahiers de l'<span class=SpellE>analyse</span>
      <span class=SpellE>des</span> <span class=SpellE>données</span></b>, Volume 8, <span
    class=SpellE>Numéro</span> 2, 1983. <o:p></o:p></span></p>


      <p class=MsoNormal><span class=SpellE><span style='font-family:'Times New Roman',serif'>Reinert</span></span><span
    style='font-family:'Times New Roman',serif'> M., <i>Alceste une <span
    class=SpellE>méthodologie</span> d'<span class=SpellE>analyse</span> <span
class=SpellE>des</span> <span class=SpellE>données</span> <span class=SpellE>textuelles</span>
et une <span class=SpellE>application</span>: Aurelia De Gerard De Nerval</i>, <span
class=SpellE><b>Bulletin</b></span><b> de <span class=SpellE>Méthodologie</span>
<span class=SpellE>Sociologique</span></b>, Volume 26, <span class=SpellE>Numéro</span>
1, 1990. </span><span lang=EN-US style='font-family:'Times New Roman',serif;
    mso-ansi-language:EN-US'>DOI: <a
href='https://doi.org/10.1177/075910639002600103' target='_blank'>10.1177/075910639002600103</a>.<o:p></o:p></span></p>



<p class=MsoNormal><span lang=EN-US style='font-family:'Times New Roman',serif;
    mso-ansi-language:EN-US'>Barnier J., P<span class=SpellE>rivé</span> F., <i>rainette:
The Reinert Method for Textual Data Clustering</i>, 2023, <b>R CRAN Repository,</b>
DOI: <a href='https://doi.org/10.32614/CRAN.package.rainette' target='_blank'>10.32614/<span
class=SpellE>CRAN.package.rainette</span></a>.<o:p></o:p></span></p>

</div>

</body>
   "

  correspondenceanalysis <- "
<body lang=IT style='tab-interval:35.4pt;word-wrap:break-word'>

<div class=WordSection1>

<p class=MsoNormal><b><span style='font-size:14.0pt;font-family:'Times New Roman',serif'>Correspondence
Analysis </span></b><span style='font-size:14.0pt;font-family:'Times New Roman',serif'><o:p></o:p></span></p>

<p style='text-align:justify'><b><span lang=EN-US style='mso-fareast-font-family:
Aptos;mso-fareast-theme-font:minor-latin;mso-ansi-language:EN-US;mso-fareast-language:
EN-US'>Correspondence Analysis (CA)</span></b><span lang=EN-US
style='mso-fareast-font-family:Aptos;mso-fareast-theme-font:minor-latin;
mso-ansi-language:EN-US;mso-fareast-language:EN-US'>&nbsp;</span><span
lang=EN-US style='mso-ansi-language:EN-US'>(</span><span lang=EN-US
style='mso-fareast-font-family:'Times New Roman';mso-fareast-theme-font:major-fareast;
mso-ansi-language:EN-US'>Benzécri, 1982</span><span lang=EN-US
style='mso-ansi-language:EN-US'>; Lebart et al., 1997) </span><span lang=EN-US
style='mso-fareast-font-family:Aptos;mso-fareast-theme-font:minor-latin;
mso-ansi-language:EN-US;mso-fareast-language:EN-US'>is a foundational technique
to explore semantic relationships among words within a text collection. By
reducing dimensionality, CA represents the most relevant information in a
low-rank vector space, capturing latent structures in the data. These
structures are visualized on factorial maps, allowing users to identify
patterns and associations between terms or documents. However, one limitation
of CA is that the new features generated through dimensionality reduction may
lack clear interpretability, making the results harder to analyze directly.<o:p></o:p></span></p>

<p style='text-align:justify'><span lang=EN-US style='mso-fareast-font-family:
Aptos;mso-fareast-theme-font:minor-latin;mso-ansi-language:EN-US;mso-fareast-language:
EN-US'>TALL integrates a&nbsp;<b>tandem approach to enhance interpretability</b>,
which combines CA with clustering techniques. This sequential method first
applies CA to transform the original data into orthogonal and ordered features.
Hierarchical clustering is then performed, as it allows for exploring multiple
levels of aggregation simultaneously, providing non-overlapping clusters that
are easier to interpret (Misuraca and Spano, 2020).<o:p></o:p></span></p>

<p class=References><span style='font-family:'Times New Roman',serif;
mso-ansi-language:IT'><o:p>&nbsp;</o:p></span></p>

<p class=References style='mso-margin-top-alt:auto;mso-margin-bottom-alt:auto'><b
style='mso-bidi-font-weight:normal'><span lang=EN-US style='font-size:14.0pt;
font-family:'Times New Roman',serif'>References<o:p></o:p></span></b></p>

<p class=References style='mso-margin-top-alt:auto;mso-margin-bottom-alt:auto'><span
style='font-family:'Times New Roman',serif;mso-ansi-language:
IT'>Misuraca M. and Spano M. (2020). </span><i><span lang=EN-US
style='font-family:'Times New Roman',serif'>Unsupervised
Analytic Strategies to Explore Large Document Collections. </span></i><span
lang=EN-US style='font-family:'Times New Roman',serif'>Heidelberg:
SPRINGER, 06, 17-28.<o:p></o:p></span></p>

<p class=References style='mso-margin-top-alt:auto;mso-margin-bottom-alt:auto;
margin-left:0cm;text-indent:0cm'><span lang=EN-US style='
font-family:'Times New Roman',serif'>Benzécri J.P. (1982). <i>Histoire et préhistoire
de l’analyse des données</i>. Dunod, Paris. <o:p></o:p></span></p>

<p class=References style='mso-margin-top-alt:auto;mso-margin-bottom-alt:auto;
margin-left:0cm;text-indent:0cm'><span lang=EN-US style='
font-family:'Times New Roman',serif'>Lebart L., Salem A. and Berry L. (1997). <i>Exploring
textual data</i>, volume 4. Springer Science &amp; Business Media. <o:p></o:p></span></p>

<p class=MsoNormal><o:p>&nbsp;</o:p></p>

</div>

</body>
"

  cowordanalysis <- "
<body lang=IT style='tab-interval:35.4pt;word-wrap:break-word'>

<div class=WordSection1>

<p class=MsoNormal style='mso-margin-top-alt:auto;mso-margin-bottom-alt:auto;
text-align:justify'><b><span lang=EN-US style='font-size:14.0pt;font-family:
'Times New Roman',serif;mso-ansi-language:EN-US'>Co-word analysis <o:p></o:p></span></b></p>

<p class=MsoNormal style='mso-margin-top-alt:auto;mso-margin-bottom-alt:auto;
text-align:justify'><i><span lang=EN-US style='font-family:'Times New Roman',serif;
mso-ansi-language:EN-US'>Network</span></i><span lang=EN-US style='font-family:
'Times New Roman',serif;mso-ansi-language:EN-US'> (Co-word analysis) (<span
style='mso-bidi-font-weight:bold'>Callon <i>et al.</i>, 1983</span>) analyzes
co-occurrence patterns of words within texts, highlighting subsets of words
strictly related through community detection algorithms (<span
style='mso-bidi-font-weight:bold'>Fortunato and <span class=SpellE>Hric</span>,
2016</span>). <o:p></o:p></span></p>

<p class=MsoNormal style='mso-margin-top-alt:auto;mso-margin-bottom-alt:auto;
text-align:justify'><span lang=EN-US style='font-family:'Times New Roman',serif;
mso-ansi-language:EN-US'>Among the different alternatives, TALL applies a <span
class=SpellE>walktrap</span> algorithm for community detection (Pons and <span
class=SpellE>Latapy</span>, 2006)<o:p></o:p></span></p>

<p class=References><span lang=EN-US style='font-size:12.0pt;font-family:'Times New Roman',serif'><o:p>&nbsp;</o:p></span></p>

<p class=References style='mso-margin-top-alt:auto;mso-margin-bottom-alt:auto'><b
style='mso-bidi-font-weight:normal'><span lang=EN-US style='font-size:14.0pt;
font-family:'Times New Roman',serif'>References<o:p></o:p></span></b></p>

<p class=References style='mso-margin-top-alt:auto;mso-margin-bottom-alt:auto'><span
lang=EN-US style='font-family:'Times New Roman',serif'>Callon
M., <span class=SpellE>Courtial</span> J.-P., Turner W.A. and <span
class=SpellE>Bauin</span> S. (1983). From translations to problematic networks:
An introduction to co-word analysis. <i>Social science information</i>,
22(2):191-235. <o:p></o:p></span></p>

<p class=References style='mso-margin-top-alt:auto;mso-margin-bottom-alt:auto'><span
lang=EN-US style='font-family:'Times New Roman',serif'>Fortunato
S. and <span class=SpellE>Hric</span> D. (2016). Community detection in
networks: A user guide. <i>Physics Reports</i>, 659:1-44, <span class=SpellE>nov.</span><o:p></o:p></span></p>

<p class=References style='mso-margin-top-alt:auto;mso-margin-bottom-alt:auto'><span
lang=EN-US style='font-family:'Times New Roman',serif'>Pons P. and <span
class=SpellE>Latapy</span> M. (2006) Computing communities in large networks
using random walks, https://arxiv.org/abs/physics/0512106.</span><span
lang=EN-US style='font-family:'Times New Roman',serif;mso-ansi-language:EN-US'><o:p></o:p></span></p>

</div>

</body>
"

  tmkchoice <- "
<body lang=IT style='tab-interval:35.4pt;word-wrap:break-word'>

<div class=WordSection1>

<p class=MsoNormal style='mso-margin-top-alt:auto;mso-margin-bottom-alt:auto;
tab-stops:134.7pt'><b><span lang=EN-US style='font-size:14.0pt;font-family:
'Times New Roman',serif;mso-ansi-language:EN-US'>Topic Modeling: K Choice<o:p></o:p></span></b></p>

<p class=MsoNormal style='mso-margin-top-alt:auto;mso-margin-bottom-alt:auto;
text-align:justify;tab-stops:134.7pt'><span lang=EN-US style='font-family:'Times New Roman',serif;
mso-ansi-language:EN-US'>TALL estimates the number of topics automatically
through the four measures proposed by <span style='mso-bidi-font-weight:bold'>Griffiths
and <span class=SpellE>Steyvers</span>, <span class=GramE>2004<span
style='mso-bidi-font-weight:normal'>;<span style='mso-spacerun:yes'>  </span></span><span
class=SpellE>Deveaud</span></span> <i>et al</i>.</span>, <span
style='mso-bidi-font-weight:bold'>2014;</span> <span style='mso-bidi-font-weight:
bold'>Cao <i>et al</i>.</span>, 2009; <span style='mso-bidi-font-weight:bold'>Arun<i>
et al</i>.</span>, <span style='mso-bidi-font-weight:bold'>2010</span>, but
users can also explore different solutions by setting the number of the desired
topics in the Model Estimation Menu.<o:p></o:p></span></p>

<p class=MsoNormal style='mso-margin-top-alt:auto;mso-margin-bottom-alt:auto;
text-align:justify;tab-stops:134.7pt'><span lang=EN-US style='font-family:'Times New Roman',serif;
mso-ansi-language:EN-US'><o:p>&nbsp;</o:p></span></p>

<p class=MsoNormal style='mso-margin-top-alt:auto;mso-margin-bottom-alt:auto;
text-align:justify;tab-stops:134.7pt'><b><span lang=EN-US style='font-size:
14.0pt;font-family:'Times New Roman',serif;mso-ansi-language:EN-US'>References<o:p></o:p></span></b></p>

<p class=References style='mso-margin-top-alt:auto;mso-margin-bottom-alt:auto;
tab-stops:134.7pt'><span lang=EN-US style='font-family:'Times New Roman',serif'>Griffiths
T.L. and <span class=SpellE>Steyvers</span> M. (2004). Finding scientific
topics. <i>Proceedings of the National academy of <span class=GramE>Sciences</span></i>,
101(suppl 1):5228-5235. <o:p></o:p></span></p>

<p class=References style='mso-margin-top-alt:auto;mso-margin-bottom-alt:auto;
tab-stops:134.7pt'><span class=SpellE><span lang=EN-US style='
font-family:'Times New Roman',serif'>Deveaud</span></span><span lang=EN-US
style='font-family:'Times New Roman',serif'> R., <span
class=SpellE>Sanjuan</span> E. and <span class=SpellE>Bellot</span> P. (2014).
Accurate and effective latent concept modeling for ad hoc information
retrieval. <i>Document numérique</i>, 17:61-84, 06. <o:p></o:p></span></p>

<p class=References style='mso-margin-top-alt:auto;mso-margin-bottom-alt:auto;
tab-stops:134.7pt'><span lang=EN-US style='font-family:'Times New Roman',serif'>Cao
J., Xia T., Li J., Zhang Y. and Tang S. (2009). A density-based method for
adaptive <span class=SpellE>lda</span> model selection. Advances in Machine
Learning and Computational Intelligence. <i>Neurocomputing</i>,
72(7):1775-1781. <o:p></o:p></span></p>

<p class=MsoNormal style='mso-margin-top-alt:auto;mso-margin-bottom-alt:auto;
tab-stops:134.7pt'><span lang=EN-US style='font-family:'Times New Roman',serif;
mso-ansi-language:EN-US'>Arun R., Suresh V., Veni Madhavan C.E. and Narasimha
Murthy M.N. (2010). On finding the natural number of topics with latent <span
class=SpellE>dirichlet</span> allocation: Some observations. In Mohammed J.
Zaki, Jeffrey Xu Yu, B. Ravindran, and Vikram Pudi, editors, <i>Advances in
Knowledge Discovery and Data Mining</i>, pages 391-402, Berlin, Heidelberg. </span><span
style='font-family:'Times New Roman',serif'>Springer <span class=SpellE>Berlin</span>
Heidelberg</span></p>

</div>

</body>
"

  tmmodelestimation <- "
<body lang=IT style='tab-interval:35.4pt;word-wrap:break-word'>

<div class=WordSection1>

<p class=MsoNormal style='mso-margin-top-alt:auto;mso-margin-bottom-alt:auto;
tab-stops:134.7pt'><b><span lang=EN-US style='font-size:14.0pt;font-family:
'Times New Roman',serif;mso-ansi-language:EN-US'>Topic Modeling: Model
Estimation<o:p></o:p></span></b></p>

<p style='text-align:justify'><i><span lang=EN-US style='mso-ansi-language:
EN-US'>Topic Modeling</span></i><span lang=EN-US style='mso-ansi-language:EN-US'>
includes a family of generative statistical models used to discover semantic
patterns reflecting the underlying (not observable) topics of a document
collection. <o:p></o:p></span></p>

<p style='text-align:justify'><span lang=EN-US style='mso-ansi-language:EN-US'>With
these models, it is possible to discover the topics of a document collection
and assign a probabilistic membership of documents to the latent topic space,
allowing one to consider a lower-dimensional space. Moreover, the topics
extracted with topic models are easily human-interpretable because each topic
is characterized by the terms most strongly associated with it. <o:p></o:p></span></p>

<p class=MsoNormal style='margin-top:6.0pt;text-align:justify'><span
lang=EN-US style='font-family:'Times New Roman',serif;mso-ansi-language:EN-US'>To
identify both prominent topics and their distribution within documents, TALL
performs the well-known Latent Dirichlet Allocation (LDA) algorithm (<span
class=SpellE><span style='mso-bidi-font-weight:bold'>Blei</span></span><span
style='mso-bidi-font-weight:bold'> <i>et al.</i>, 2003)</span>.<span
style='mso-spacerun:yes'>  </span><o:p></o:p></span></p>

<p class=MsoNormal style='margin-top:6.0pt;text-align:justify'><span
lang=EN-US style='font-family:'Times New Roman',serif;mso-ansi-language:EN-US'><o:p>&nbsp;</o:p></span></p>

<p class=MsoNormal style='mso-margin-top-alt:auto;mso-margin-bottom-alt:auto;
text-align:justify;tab-stops:134.7pt'><span lang=EN-US style='font-family:'Times New Roman',serif;
mso-ansi-language:EN-US'><o:p>&nbsp;</o:p></span></p>

<p class=MsoNormal style='mso-margin-top-alt:auto;mso-margin-bottom-alt:auto;
text-align:justify;tab-stops:134.7pt'><b><span lang=EN-US style='font-size:
14.0pt;font-family:'Times New Roman',serif;mso-ansi-language:EN-US'>References<o:p></o:p></span></b></p>

<p class=References><span class=SpellE><span lang=EN-US style='
font-family:'Times New Roman',serif'>Blei</span></span><span lang=EN-US
style='font-family:'Times New Roman',serif'> D.M., Ng A.Y. and
Jordan M.I. (2003). Latent <span class=SpellE>dirichlet</span> allocation. <i>Journal
of machine Learning research</i>, 3(Jan):993-1022. <o:p></o:p></span></p>

<p class=References style='mso-margin-top-alt:auto;mso-margin-bottom-alt:auto;
tab-stops:134.7pt'><span lang=EN-US><o:p>&nbsp;</o:p></span></p>

</div>

</body>
"

  polaritydetection <- "
<body lang=IT style='tab-interval:35.4pt;word-wrap:break-word'>

<div class=WordSection1>

<p class=MsoNormal style='mso-margin-top-alt:auto;mso-margin-bottom-alt:auto;
tab-stops:134.7pt'><b><span lang=EN-US style='font-size:14.0pt;font-family:
'Times New Roman',serif;mso-ansi-language:EN-US'>Polarity detection<o:p></o:p></span></b></p>

<p class=MsoNormal style='mso-margin-top-alt:auto;mso-margin-bottom-alt:auto;
text-align:justify'><i><span lang=EN-US style='font-family:'Times New Roman',serif;
mso-ansi-language:EN-US'>Polarity Detection</span></i><span lang=EN-US
style='font-family:'Times New Roman',serif;mso-ansi-language:EN-US'> allows us to
determine the polarity (positive, negative, neutral) of documents.<o:p></o:p></span></p>

<p class=MsoNormal style='mso-margin-top-alt:auto;mso-margin-bottom-alt:auto;
text-align:justify'><span lang=EN-US style='font-family:'Times New Roman',serif;
color:black;mso-ansi-language:EN-US'>TALL calculates document polarity by
leveraging sentiment lexicons and contextual adjustments through valence
shifters. Words are assigned polarity scores based on their presence in a
lexicon (e.g., positive words are assigned +1, and negative words -1). These
scores are dynamically modified using valence shifters, such as negators,
amplifiers, and de-amplifiers, which adjust the intensity or direction of the
sentiment. The polarity scores are then aggregated across the document, with an
optional normalization step to constrain the final score within a range [-1,1].<span
class=apple-converted-space>&nbsp;</span></span><span lang=EN-US
style='font-family:'Times New Roman',serif;mso-ansi-language:EN-US'><o:p></o:p></span></p>

<p class=MsoNormal style='mso-margin-top-alt:auto;mso-margin-bottom-alt:auto;
text-align:justify'><b><span lang=EN-US style='font-family:'Times New Roman',serif;
mso-ansi-language:EN-US'>Polarized lexicons in TALL</span></b><span lang=EN-US
style='font-family:'Times New Roman',serif;mso-ansi-language:EN-US'><o:p></o:p></span></p>

<p class=MsoNormal style='mso-margin-top-alt:auto;mso-margin-bottom-alt:auto;
text-align:justify'><b><span lang=EN-US style='font-family:'Times New Roman',serif;
mso-ansi-language:EN-US'>Hu and Liu (2004) - Opinion Lexicon - </span></b><span
lang=EN-US style='font-family:'Times New Roman',serif;mso-ansi-language:EN-US'>One
of the foundational resources for sentiment analysis in consumer reviews. It
categorizes words into positive and negative sentiment classes, focusing on
terms commonly found in product reviews. Widely used in analyzing consumer
sentiment, especially in e-commerce and review platforms, due to its
comprehensive list of opinion words. (N.B. English texts)<o:p></o:p></span></p>

<p class=MsoNormal style='mso-margin-top-alt:auto;mso-margin-bottom-alt:auto;
text-align:justify'><b><span lang=EN-US style='font-family:'Times New Roman',serif;
mso-ansi-language:EN-US'>Loughran and McDonald (2016) - Financial Sentiment
Dictionary - </span></b><span lang=EN-US style='font-family:'Times New Roman',serif;
mso-ansi-language:EN-US'>Created specifically for financial texts, it addresses
the limitations of general-purpose sentiment dictionaries in financial
contexts. It includes categories such as “positive,” “negative,” “uncertainty,”
“litigious,” and “constraining,” tailored for finance-related sentiment
analysis. (N.B. English texts)<o:p></o:p></span></p>

<p class=MsoNormal style='mso-margin-top-alt:auto;mso-margin-bottom-alt:auto;
text-align:justify'><b><span lang=EN-US style='font-family:'Times New Roman',serif;
mso-ansi-language:EN-US'>NRC Emotion Lexicon (Mohammad and Turney, 2010) - </span></b><span
lang=EN-US style='font-family:'Times New Roman',serif;mso-ansi-language:EN-US'>Developed
by the National Research Council (NRC) of Canada, this lexicon goes beyond
simple polarity, capturing a wider range of emotions. Suitable for detecting
nuanced emotional tones in diverse text types, ranging from social media posts
to literature, due to its detailed emotion categories. <o:p></o:p></span></p>

<p class=MsoNormal style='mso-margin-top-alt:auto;mso-margin-bottom-alt:auto;
text-align:justify'><span lang=EN-US style='font-family:'Times New Roman',serif;
mso-ansi-language:EN-US'><o:p>&nbsp;</o:p></span></p>

<p class=MsoNormal style='mso-margin-top-alt:auto;mso-margin-bottom-alt:auto;
text-align:justify;tab-stops:134.7pt'><b><span lang=EN-US style='font-size:
14.0pt;font-family:'Times New Roman',serif;mso-ansi-language:EN-US'>References<o:p></o:p></span></b></p>

<p class=References style='mso-margin-top-alt:auto;mso-margin-bottom-alt:auto'><span
lang=EN-US style='font-family:'Times New Roman',serif'>Hu M.
and Liu B. (2004). Mining and summarizing customer reviews. In <i>Proceedings
of the Tenth ACM SIGKDD International Conference on Knowledge Discovery and
Data Mining</i>, KDD ’04, 168-177, New York, NY, USA. Association for Computing
Machinery. <o:p></o:p></span></p>

<p class=References style='mso-margin-top-alt:auto;mso-margin-bottom-alt:auto'><span
lang=EN-US style='font-family:'Times New Roman',serif'>Loughran
T. and McDonald B. (2016). Textual analysis in accounting and finance: A
survey. <i>Journal of Accounting Research</i>, 54(4):1187-1230. <o:p></o:p></span></p>

<p class=MsoNormal style='mso-margin-top-alt:auto;mso-margin-bottom-alt:auto;
text-align:justify'><span lang=EN-US style='font-family:'Times New Roman',serif;
mso-ansi-language:EN-US'>Mohammad S. and Turney P. (2010). Emotions evoked by
common words and phrases: Using Mechanical Turk to create an emotion lexicon.
In <i>Proceedings of the NAACL HLT 2010 Workshop on Computational Approaches to
Analysis and Generation of Emotion in Text, 26</i>-<i>34, Los Angeles, CA,
June. </i></span><i><span style='font-family:'Times New Roman',serif'>Association
for <span class=SpellE>Computational</span> <span class=SpellE>Linguistics</span>.</span></i><span
lang=EN-US style='font-family:'Times New Roman',serif;mso-ansi-language:EN-US'><o:p></o:p></span></p>

</div>

</body>
"

  summarization <- "
<body lang=IT style='tab-interval:35.4pt;word-wrap:break-word'>

<div class=WordSection1>

<p class=MsoNormal style='mso-margin-top-alt:auto;mso-margin-bottom-alt:auto;
tab-stops:134.7pt'><b><span lang=EN-US style='font-size:14.0pt;font-family:
'Times New Roman',serif;mso-ansi-language:EN-US'>Summarization<o:p></o:p></span></b></p>

<p class=MsoNormal><span lang=EN-US style='font-family:'Times New Roman',serif;
mso-ansi-language:EN-US'>TALL employs an extractive summarization technique,
which involves selecting the most relevant sentences from the document and
organizing them systematically. Sentences in the summary are directly sourced
from the original text. <o:p></o:p></span></p>

<p class=MsoNormal style='margin-top:6.0pt;text-align:justify'><span
lang=EN-US style='font-family:'Times New Roman',serif;mso-ansi-language:EN-US'>TALL
performs the <span class=SpellE><i>TextRank</i></span><i> </i>algorithm (<span
class=SpellE><span style='mso-bidi-font-weight:bold'>Mihalcea</span></span><span
style='mso-bidi-font-weight:bold'> and T<span class=SpellE>arau, 20</span>04</span>),
based on applying Google’s PageRank (Page <i><span style='mso-bidi-font-weight:
bold'>et al</span></i><span style='mso-bidi-font-weight:bold'>.</span>, <span
style='mso-bidi-font-weight:bold'>1998</span>) to the network of sentences to
extract the most relevant ones.<span style='mso-spacerun:yes'>  </span><o:p></o:p></span></p>

<p class=MsoNormal style='mso-margin-top-alt:auto;mso-margin-bottom-alt:auto;
text-align:justify;tab-stops:134.7pt'><span lang=EN-US style='font-family:'Times New Roman',serif;
mso-ansi-language:EN-US'><o:p>&nbsp;</o:p></span></p>

<p class=MsoNormal style='mso-margin-top-alt:auto;mso-margin-bottom-alt:auto;
text-align:justify;tab-stops:134.7pt'><b><span lang=EN-US style='font-size:
14.0pt;font-family:'Times New Roman',serif;mso-ansi-language:EN-US'>References<o:p></o:p></span></b></p>

<p class=References><span class=SpellE><span lang=EN-US style='
font-family:'Times New Roman',serif'>Mihalcea</span></span><span lang=EN-US
style='font-family:'Times New Roman',serif'> R. and <span
class=SpellE>Tarau</span> P. (2004). <span class=SpellE>TextRank</span>:
Bringing order into text. In <i>Proceedings of the 2004 Conference on Empirical
Methods in Natural Language Processing</i>, 404-411, Barcelona, Spain, July.
Association for Computational Linguistics. <o:p></o:p></span></p>

<p class=MsoNormal style='mso-margin-top-alt:auto;mso-margin-bottom-alt:auto;
text-align:justify'><span lang=EN-US style='font-family:'Times New Roman',serif;
mso-ansi-language:EN-US'>Page L., Brin S., Motwani R. and Winograd T. (1998).
The PageRank Citation Ranking: Bringing Order to the Web. </span><span
style='font-family:'Times New Roman',serif'>Technical report, Stanford Digital
Library Technologies Project.</span><span lang=EN-US style='font-family:'Times New Roman',serif;
mso-ansi-language:EN-US'><o:p></o:p></span></p>

</div>

</body>
"

  return(list(importmenu = importmenu,
              multiwordcreation = multiwordcreation,
              reinert = reinert,
              correspondenceanalysis = correspondenceanalysis,
              cowordanalysis = cowordanalysis,
              tmkchoice = tmkchoice,
              tmmodelestimation = tmmodelestimation,
              polaritydetection = polaritydetection,
              summarization = summarization
              ))
}



