% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tab.R
\name{tab_totaltab}
\alias{tab_totaltab}
\title{Add total table to a \code{\link[tabxplor]{tab}}}
\usage{
tab_totaltab(
  tabs,
  totaltab = c("table", "line", "no"),
  name = "Ensemble",
  data = NULL
)
}
\arguments{
\item{tabs}{A \code{tibble} of class \code{tab}, made with \code{\link{tab_plain}} or
\code{\link{tab_many}}.}

\item{totaltab}{If there are subtables, corresponding to the levels of tab_vars,
\code{totaltab = "table"} add a complete total table.
\code{totaltab = "line"} add a total table of only one row with the general total.
\code{totaltab = "no"} remove any existing total table.}

\item{name}{The name of the total table, as a single string.}

\item{data}{The original database used to calculate the \code{tab} : it is only useful
for mean columns (of numeric variables), in order to calculate the variances
necessary to calculate confidence intervals with \code{\link{tab_ci}}.}
}
\value{
A \code{tibble} of class \code{tab}. Rows belonging to the total table can then
be detected using \code{\link{is_tottab}}.
}
\description{
Add total table to a \code{\link[tabxplor]{tab}}
}
\examples{
\donttest{ data <- dplyr::starwars \%>\%
tab_prepare(sex, hair_color, gender, other_if_less_than = 5,
            na_drop_all = sex)

data \%>\%
  tab_plain(sex, hair_color, gender) \%>\%
  tab_totaltab("line")
  }
}
