% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tab_classes.R
\name{tab_kable}
\alias{tab_kable}
\title{Print a tabxplor table in html}
\usage{
tab_kable(
  tabs,
  theme = c("light", "dark"),
  color_type = NULL,
  html_24_bit = NULL,
  tooltips = TRUE,
  popover = NULL,
  color_legend = TRUE,
  caption = NULL,
  html_font = "\\"Arial\\", arial, helvetica, sans-serif",
  get_data = FALSE,
  wrap_rows = 35,
  wrap_cols = 15,
  whitespace_only = TRUE,
  ...
)
}
\arguments{
\item{tabs}{A table made with \code{\link{tab}} or \code{\link{tab_many}}.}

\item{theme}{By default, a white table with black text, Set to \code{"dark"} for a
black table with white text.}

\item{color_type}{Set to \code{"text"} to color the text, \code{"bg"} to color the
background. By default it takes \code{getOption("tabxplor.color_style_type")}.}

\item{html_24_bit}{Should specific 24bits colors palettes be used ? Default to
\code{getOption("tabxplor.color_html_24_bit")}}

\item{tooltips}{By default, html tooltips are used to display additional informations
at mouse hover. Set to \code{FALSE} to discard.}

\item{popover}{By default, takes \code{getOption("tabxplor.kable_popover")}. When
\code{FALSE}, html tooltips are of the base kind : they can't be used with floating table of
content in \pkg{rmarkdown} documents. Set to \code{TRUE} to use \pkg{kableExtra} html
popovers instead, which are compatible with floating toc. Remember
to enable the \code{popover} module by copying the following code into your document :
\code{<script>
$(document).ready(function(){
  $('[data-toggle="popover"]').popover();
});
</script>
}}

\item{color_legend}{Print colors legend below the table ?
You can then use a \code{css} chunk in rmarkdown to change popovers colors.}

\item{caption}{The table caption. For formatting, you need to use a \code{css}
with \verb{caption\{\}}in rmarkdown.}

\item{html_font}{A string for HTML css font. For example,
\code{html_font = '"Arial Narrow", arial, helvetica, sans-serif'}.}

\item{get_data}{Get the transformed data instead of the html table.}

\item{wrap_rows}{By default, rownames are wrapped when larger than 30 characters.}

\item{wrap_cols}{By default, colnames are wrapped when larger than 12 characters.}

\item{whitespace_only}{Set to \code{FALSE} to wrap also on non whitespace characters.}

\item{...}{Other arguments to pass to \code{\link[kableExtra:kable_styling]{kableExtra::kable_styling}}.}
}
\value{
A html table (opened in the viewer in RStudio). Differences from totals,
confidence intervals, contribution to variance, and unweighted counts,
are available in an html tooltip at cells hover.
}
\description{
Print a tabxplor table in html
}
\examples{
\donttest{
tabs <- tab(forcats::gss_cat, race, marital, year, pct = "row", color = "diff")
tab_kable(tabs, theme = "light", color_type = "text")
}
}
