/*
 * Decompiled with CFR 0.152.
 */
package technology.tabula;

import java.util.Comparator;
import java.util.List;
import java.util.Stack;

public class QuickSort {
    private static final Comparator<? extends Comparable> objComp = new Comparator<Comparable>(){

        @Override
        public int compare(Comparable object1, Comparable object2) {
            return object1.compareTo(object2);
        }
    };

    private QuickSort() {
    }

    public static <T> void sort(List<T> list, Comparator<T> cmp) {
        QuickSort.quicksort(list, cmp);
    }

    public static <T extends Comparable> void sort(List<T> list) {
        QuickSort.sort(list, objComp);
    }

    private static <T> void quicksort(List<T> list, Comparator<T> cmp) {
        Stack<Integer> stack = new Stack<Integer>();
        stack.push(0);
        stack.push(list.size());
        while (!stack.isEmpty()) {
            int left;
            int right = (Integer)stack.pop();
            if (right - (left = ((Integer)stack.pop()).intValue()) < 2) continue;
            int p = left + (right - left) / 2;
            p = QuickSort.partition(list, cmp, p, left, right);
            stack.push(p + 1);
            stack.push(right);
            stack.push(left);
            stack.push(p);
        }
    }

    private static <T> int partition(List<T> list, Comparator<T> cmp, int p, int start, int end) {
        int l = start;
        int h = end - 2;
        T piv = list.get(p);
        QuickSort.swap(list, p, end - 1);
        while (l < h) {
            if (cmp.compare(list.get(l), piv) <= 0) {
                ++l;
                continue;
            }
            if (cmp.compare(piv, list.get(h)) <= 0) {
                --h;
                continue;
            }
            QuickSort.swap(list, l, h);
        }
        int idx = h;
        if (cmp.compare(list.get(h), piv) < 0) {
            ++idx;
        }
        QuickSort.swap(list, end - 1, idx);
        return idx;
    }

    private static <T> void swap(List<T> list, int i, int j) {
        T tmp = list.get(i);
        list.set(i, list.get(j));
        list.set(j, tmp);
    }
}

