% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/plot_spot.R
\docType{methods}
\name{plot_spot}
\alias{plot_spot}
\alias{plot_spot-method}
\alias{plot_spot,matrix-method}
\alias{plot_spot,dist-method}
\alias{plot_spot,OccurrenceMatrix-method}
\title{Spot Plot}
\usage{
plot_spot(object, ...)

\S4method{plot_spot}{matrix}(object, threshold = NULL, diag = TRUE, upper = TRUE, ...)

\S4method{plot_spot}{dist}(object, diag = FALSE, upper = FALSE, ...)

\S4method{plot_spot}{OccurrenceMatrix}(object, diag = FALSE, upper = FALSE, ...)
}
\arguments{
\item{object}{An abundance matrix to be plotted.}

\item{...}{Extra parameters to be passed to \code{threshold}.}

\item{threshold}{A \code{\link{function}} that takes a numeric vector as argument and
returns a numeric threshold value. If \code{NULL} (the default), no threshold is
computed.}

\item{diag}{A \code{\link{logical}} scalar indicating whether the diagonal of the
matrix should be plotted.}

\item{upper}{A \code{\link{logical}} scalar indicating whether the upper triangle of
the matrix should be plotted.}
}
\value{
A \link[ggplot2:ggplot]{ggplot2::ggplot} object.
}
\description{
Plots a spot matrix.
}
\details{
The spot matrix can be considered as a variant of the
\link[=plot_bertin]{Bertin diagram} where the data are first transformed to
relative frequencies.
}
\note{
Adapted from Dan Gopstein's original
\href{https://dgopstein.github.io/articles/spot-matrix/}{idea}.
}
\examples{
## Plot spot diagram of count data...
data("mississippi", package = "folio")
counts <- as_count(mississippi)

### ...without threshod
plot_spot(counts)
### ...with the  column means as threshold
plot_spot(counts, threshold = mean)
### ...with the column medians as threshold
plot_spot(counts, threshold = median)
}
\seealso{
Other plot: 
\code{\link{plot_bar}},
\code{\link{plot_diversity}},
\code{\link{plot_line}},
\code{\link{plot_matrix}}
}
\author{
N. Frerebeau
}
\concept{plot}
