% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/notes.R
\name{note_slice}
\alias{note_slice}
\alias{note_sort}
\alias{note_rotate}
\alias{note_shift}
\alias{note_arpeggiate}
\title{Slice, sort, rotate, shift and arpeggiate notes}
\usage{
note_slice(notes, ...)

note_sort(notes, decreasing = FALSE)

note_rotate(notes, n = 0)

note_shift(notes, n = 0)

note_arpeggiate(notes, n = 0, step = 12)
}
\arguments{
\item{notes}{character, a noteworthy string, space-delimited or vector of
individual entries.}

\item{...}{For \code{note_slice()}, an integer or logical vector.}

\item{decreasing}{logical, short in decreasing order.}

\item{n}{integer, number of rotations or extensions of note sequence. See
details.}

\item{step}{integer, number of semitone steps from the first (or last) note
in \code{notes} at which to begin repeating the shifted \code{notes} sequence as an
arpeggio. See examples.}
}
\value{
character
}
\description{
Helper functions for indexing and moving notes within noteworthy strings.
}
\details{
\code{note_slice()} subsets the timesteps of a noteworthy string by integer index
or logical vector of length equal to the number of timesteps.

\code{note_sort()} sorts the timesteps of a noteworthy string by pitch. When a tie
exists by root note, the next note in chords are compared, if they exist.
For example, \verb{a,} sorts lower than \verb{a,ce}.

\code{note_rotate()} simply rotates anything space-delimited or vectorized in
place. It allows chords. Octave numbering is ignored if present.

For \code{note_shift()} the entire sequence is shifted up or down in pitch, as if
inverting a broken chord. If \code{notes} contains chords, they are broken into
successive notes. Then all notes are ordered by pitch. Finally shifting
occurs.

Instead of a moving window, \code{note_arpeggiate()} grows its sequence from the
original set of timesteps by repeating the entire sequence \code{n} times (\code{n}
must be positive). Each repeated sequence contributing to the arpeggio is
offset by \code{step} semitones from the original. \code{step} can be negative. It
defaults to 12, increasing all \code{notes} by one octave.
}
\examples{
x <- "bd'f#' a c'e'g' b ba c'g' gd'g'd''"
note_sort(x)
note_sort(x, decreasing = TRUE)

x <- "e_2 a_, c#f#a#"
note_slice(x, 2:3)
note_slice(x, c(FALSE, TRUE, TRUE))

note_rotate(x, 1)

note_shift("c e g", 1)
note_shift("c e g", -4)

note_arpeggiate("c e g ceg", 3)
note_arpeggiate("c e g", 3, step = -12)
note_arpeggiate("g e c", 3, step = -12)
note_arpeggiate("c e_ g_ a", 3, step = 3)
note_arpeggiate("c a g_ e_", 3, step = -3)
}
