% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chords.R
\name{chords}
\alias{chords}
\alias{chord_min}
\alias{chord_maj}
\alias{chord_min7}
\alias{chord_dom7}
\alias{chord_7s5}
\alias{chord_maj7}
\alias{chord_min6}
\alias{chord_maj6}
\alias{chord_dim}
\alias{chord_dim7}
\alias{chord_m7b5}
\alias{chord_aug}
\alias{chord_5}
\alias{chord_sus2}
\alias{chord_sus4}
\alias{chord_dom9}
\alias{chord_7s9}
\alias{chord_maj9}
\alias{chord_add9}
\alias{chord_min9}
\alias{chord_madd9}
\alias{chord_min11}
\alias{chord_7s11}
\alias{chord_maj7s11}
\alias{chord_11}
\alias{chord_maj11}
\alias{chord_13}
\alias{chord_min13}
\alias{chord_maj13}
\alias{xm}
\alias{xM}
\alias{xm7}
\alias{x7}
\alias{x7s5}
\alias{xM7}
\alias{xm6}
\alias{xM6}
\alias{xdim}
\alias{xdim7}
\alias{xm7b5}
\alias{xaug}
\alias{x5}
\alias{xs2}
\alias{xs4}
\alias{x9}
\alias{x7s9}
\alias{xM9}
\alias{xadd9}
\alias{xm9}
\alias{xma9}
\alias{xm11}
\alias{x7s11}
\alias{xM7s11}
\alias{x_11}
\alias{xM11}
\alias{x_13}
\alias{xm13}
\alias{xM13}
\title{Chord constructors}
\usage{
chord_min(notes, key = "c", style = "default")

chord_maj(notes, key = "c", style = "default")

chord_min7(notes, key = "c", style = "default")

chord_dom7(notes, key = "c", style = "default")

chord_7s5(notes, key = "c", style = "default")

chord_maj7(notes, key = "c", style = "default")

chord_min6(notes, key = "c", style = "default")

chord_maj6(notes, key = "c", style = "default")

chord_dim(notes, key = "c", style = "default")

chord_dim7(notes, key = "c", style = "default")

chord_m7b5(notes, key = "c", style = "default")

chord_aug(notes, key = "c", style = "default")

chord_5(notes, key = "c", style = "default")

chord_sus2(notes, key = "c", style = "default")

chord_sus4(notes, key = "c", style = "default")

chord_dom9(notes, key = "c", style = "default")

chord_7s9(notes, key = "c", style = "default")

chord_maj9(notes, key = "c", style = "default")

chord_add9(notes, key = "c", style = "default")

chord_min9(notes, key = "c", style = "default")

chord_madd9(notes, key = "c", style = "default")

chord_min11(notes, key = "c", style = "default")

chord_7s11(notes, key = "c", style = "default")

chord_maj7s11(notes, key = "c", style = "default")

chord_11(notes, key = "c", style = "default")

chord_maj11(notes, key = "c", style = "default")

chord_13(notes, key = "c", style = "default")

chord_min13(notes, key = "c", style = "default")

chord_maj13(notes, key = "c", style = "default")

xm(notes, key = "c", style = "default")

xM(notes, key = "c", style = "default")

xm7(notes, key = "c", style = "default")

x7(notes, key = "c", style = "default")

x7s5(notes, key = "c", style = "default")

xM7(notes, key = "c", style = "default")

xm6(notes, key = "c", style = "default")

xM6(notes, key = "c", style = "default")

xdim(notes, key = "c", style = "default")

xdim7(notes, key = "c", style = "default")

xm7b5(notes, key = "c", style = "default")

xaug(notes, key = "c", style = "default")

x5(notes, key = "c", style = "default")

xs2(notes, key = "c", style = "default")

xs4(notes, key = "c", style = "default")

x9(notes, key = "c", style = "default")

x7s9(notes, key = "c", style = "default")

xM9(notes, key = "c", style = "default")

xadd9(notes, key = "c", style = "default")

xm9(notes, key = "c", style = "default")

xma9(notes, key = "c", style = "default")

xm11(notes, key = "c", style = "default")

x7s11(notes, key = "c", style = "default")

xM7s11(notes, key = "c", style = "default")

x_11(notes, key = "c", style = "default")

xM11(notes, key = "c", style = "default")

x_13(notes, key = "c", style = "default")

xm13(notes, key = "c", style = "default")

xM13(notes, key = "c", style = "default")
}
\arguments{
\item{notes}{character, a noteworthy string of chord root notes.}

\item{key}{key signature. See details.}

\item{style}{character, passed to \code{transpose}.}
}
\value{
character
}
\description{
These functions construct basic chord string notation from root \code{notes}.
}
\details{
Providing a \code{key} signature is used only to ensure flats or sharps for
accidentals.
An additional set of aliases with efficient names, of the
form \code{x*} where \code{*} is a chord modifier abbreviation, is provided
to complement the set of \code{chord_*} functions.

These functions create standard chords, not the multi-octave spanning types
of chords commonly played on guitar.
}
\examples{
chord_min("d")
chord_maj("d")
xM("d")
xm("c f g")
xm("c, f, g,", key = "e_")
}
\seealso{
\code{\link{transpose}}
}
