% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/types.castYear.R
\name{types.castYear}
\alias{types.castYear}
\title{Cast year}
\usage{
types.castYear(format, value)
}
\arguments{
\item{format}{no options (other than the default)}

\item{value}{year to cast}
}
\description{
Cast year. A calendar year as per \href{https://www.w3.org/TR/xmlschema-2/#gYear}{XMLSchema gYear}. 
Usual lexical representation is: YYYY.
}
\examples{

types.castYear(format = "default", value = 2000)

types.castYear(format = "default", value = "2010")

}
\seealso{
\href{https://specs.frictionlessdata.io//table-schema/#year}{Types and formats specifications}
}
