#' html2unicode
#' 
#' Converts HTML encoded special letters to unicode.
#' @param x A character vector or matrix.
#' @return A character vector or matrix.
#' @references https://www.w3.org/TR/REC-html40/sgml/entities.html
#' @examples
#' html2unicode(x<-"&#34;, &#161;, &#162;.")
#' @export
html2unicode<-function(x){
if(length(grep("&#",x))>0){
x<-gsub("&#0*30;"," ",x)
x<-gsub("&#0*31"," ",x)
x<-gsub("&#0*32;"," ",x)
x<-gsub("&#0*33;","!",x)
x<-gsub("&#0*34;","\u0022",x) # backslash
x<-gsub("&#0*38;","&",x)
x<-gsub("&#0*39;","'",x)
x<-gsub("&#0*40;","(",x)
x<-gsub("&#0*41;",")",x)
x<-gsub("&#0*42;","*",x)
x<-gsub("&#0*43;","+",x)
x<-gsub("&#0*44;",",",x)
x<-gsub("&#0*45;","-",x)
x<-gsub("&#0*46;",".",x)
x<-gsub("&#0*47;","/",x)

x<-gsub("&#0*58;",",",x)
x<-gsub("&#0*59;",";",x)
x<-gsub("&#0*60;","<",x)
x<-gsub("&#0*61;","=",x)
x<-gsub("&#0*62;",">",x)
x<-gsub("&#0*63;","?",x)
x<-gsub("&#0*64;","@",x)
x<-gsub("&#0*91;","[",x)
x<-gsub("&#0*93;","]",x)
x<-gsub("&#0*94;","^",x)
x<-gsub("&#0*95;","_",x)
x<-gsub("&#123;","{",x)
x<-gsub("&#124;","|",x)
x<-gsub("&#125;","}",x)
x<-gsub("&#160;"," ",x)
x<-gsub("&#173;","",x)
x<-gsub("&#8211;","-",x)
x<-gsub("&#8249;","<",x)
x<-gsub("&#8250;",">",x)
# go on?

if(length(grep("&#",x))>0){
  x<-gsub("&#169;","\u00A9",x)
  x<-gsub("&#170;","\u00AA",x)
x<-gsub("&#171;","\u00AB",x)
x<-gsub("&#172;","\u00AC",x)
x<-gsub("&#174;","\u00AE",x)
x<-gsub("&#175;","\u00AF",x)
x<-gsub("&#176;","\u00B0",x)
x<-gsub("&#177;","\u00B1",x)
x<-gsub("&#178;","\u00B2",x)
x<-gsub("&#179;","\u00B3",x)
x<-gsub("&#180;","\u00B4",x)
x<-gsub("&#181;","\u00B5",x)
x<-gsub("&#182;","\u00B6",x)
x<-gsub("&#183;","\u00B7",x)
x<-gsub("&#184;","\u00B8",x)
x<-gsub("&#185;","\u00B9",x)
x<-gsub("&#186;","\u00BA",x)
x<-gsub("&#187;","\u00BB",x)
x<-gsub("&#188;","\u00BC",x)
x<-gsub("&#189;","\u00BD",x)
x<-gsub("&#190;","\u00BE",x)
x<-gsub("&#191;","\u00BF",x)
x<-gsub("&#192;","\u00C0",x)
x<-gsub("&#193;","\u00C1",x)
x<-gsub("&#194;","\u00C2",x)
x<-gsub("&#195;","\u00C3",x)
x<-gsub("&#196;","\u00C4",x)
x<-gsub("&#197;","\u00C5",x)
x<-gsub("&#198;","\u00C6",x)
x<-gsub("&#199;","\u00C7",x)
x<-gsub("&#200;","\u00C8",x)
x<-gsub("&#201;","\u00C9",x)
x<-gsub("&#202;","\u00CA",x)
x<-gsub("&#203;","\u00CB",x)
x<-gsub("&#204;","\u00CC",x)
# go on?

if(length(grep("&#",x))>0){
x<-gsub("&#205;","\u00CD",x)
x<-gsub("&#206;","\u00CE",x)
x<-gsub("&#207;","\u00CF",x)
x<-gsub("&#208;","\u00D0",x)
x<-gsub("&#209;","\u00D1",x)
x<-gsub("&#210;","\u00D2",x)
x<-gsub("&#211;","\u00D3",x)
x<-gsub("&#212;","\u00D4",x)
x<-gsub("&#213;","\u00D5",x)
x<-gsub("&#214;","\u00D6",x)
x<-gsub("&#215;","\u00D7",x)
x<-gsub("&#216;","\u00D8",x)
x<-gsub("&#217;","\u00D9",x)
x<-gsub("&#218;","\u00DA",x)
x<-gsub("&#219;","\u00DB",x)
x<-gsub("&#220;","\u00DC",x)
x<-gsub("&#221;","\u00DD",x)
x<-gsub("&#222;","\u00DE",x)
x<-gsub("&#223;","\u00DF",x)
x<-gsub("&#225;","\u00E1",x)
x<-gsub("&#226;","\u00E2",x)
x<-gsub("&#227;","\u00E3",x)
x<-gsub("&#228;","\u00E4",x)
x<-gsub("&#229;","\u00E5",x)
x<-gsub("&#230;","\u00E6",x)
x<-gsub("&#231;","\u00E7",x)
x<-gsub("&#232;","\u00E8",x)
x<-gsub("&#233;","\u00E9",x)
x<-gsub("&#234;","\u00EA",x)
x<-gsub("&#235;","\u00EB",x)
x<-gsub("&#236;","\u00EC",x)
x<-gsub("&#237;","\u00ED",x)
x<-gsub("&#238;","\u00EE",x)
x<-gsub("&#239;","\u00EF",x)
x<-gsub("&#240;","\u00F0",x)
x<-gsub("&#241;","\u00F1",x)
x<-gsub("&#242;","\u00F2",x)
x<-gsub("&#243;","\u00F3",x)
x<-gsub("&#244;","\u00F4",x)
x<-gsub("&#245;","\u00F5",x)
x<-gsub("&#246;","\u00F6",x)
x<-gsub("&#247;","\u00F7",x)
x<-gsub("&#248;","\u00F8",x)
x<-gsub("&#249;","\u00F9",x)
x<-gsub("&#250;","\u00FA",x)
x<-gsub("&#251;","\u00FB",x)
x<-gsub("&#252;","\u00FC",x)
x<-gsub("&#253;","\u00FD",x)
x<-gsub("&#254;","\u00FE",x)
x<-gsub("&#255;","\u00FF",x)
x<-gsub("&#402;","\u0192",x)
x<-gsub("&#913;","\u0391",x)
x<-gsub("&#914;","\u0392",x)
x<-gsub("&#915;","\u0393",x)
x<-gsub("&#916;","\u0394",x)
x<-gsub("&#917;","\u0395",x)
x<-gsub("&#918;","\u0396",x)
x<-gsub("&#919;","\u0397",x)
x<-gsub("&#920;","\u0398",x)
x<-gsub("&#921;","\u0399",x)
x<-gsub("&#922;","\u039A",x)
x<-gsub("&#923;","\u039B",x)
x<-gsub("&#924;","\u039C",x)
x<-gsub("&#925;","\u039D",x)
x<-gsub("&#926;","\u039E",x)
x<-gsub("&#927;","\u039F",x)
x<-gsub("&#928;","\u03A0",x)
x<-gsub("&#929;","\u03A1",x)
x<-gsub("&#931;","\u03A3",x)
x<-gsub("&#932;","\u03A4",x)
x<-gsub("&#933;","\u03A5",x)
x<-gsub("&#934;","\u03A6",x)
x<-gsub("&#935;","\u03A7",x)
x<-gsub("&#936;","\u03A8",x)
x<-gsub("&#937;","\u03A9",x)
x<-gsub("&#945;","\u03B1",x)
x<-gsub("&#946;","\u03B2",x)
x<-gsub("&#947;","\u03B3",x)
x<-gsub("&#948;","\u03B4",x)
x<-gsub("&#949;","\u03B5",x)
x<-gsub("&#950;","\u03B6",x)
x<-gsub("&#951;","\u03B7",x)
x<-gsub("&#952;","\u03B8",x)
x<-gsub("&#953;","\u03B9",x)
x<-gsub("&#954;","\u03BA",x)
x<-gsub("&#955;","\u03BB",x)
x<-gsub("&#956;","\u03BC",x)
x<-gsub("&#957;","\u03BD",x)
x<-gsub("&#958;","\u03BE",x)
x<-gsub("&#959;","\u03BF",x)
x<-gsub("&#960;","\u03C0",x)
x<-gsub("&#961;","\u03C1",x)
x<-gsub("&#962;","\u03C2",x)
x<-gsub("&#963;","\u03C3",x)
x<-gsub("&#964;","\u03C4",x)
x<-gsub("&#965;","\u03C5",x)
x<-gsub("&#966;","\u03C6",x)
x<-gsub("&#967;","\u03C7",x)
x<-gsub("&#968;","\u03C8",x)
x<-gsub("&#969;","\u03C9",x)
x<-gsub("&#977;","\u03D1",x)
x<-gsub("&#978;","\u03D2",x)
x<-gsub("&#982;","\u03D6",x)
x<-gsub("&#8226;","\u2022",x)
x<-gsub("&#8230;","\u2026",x)
x<-gsub("&#8242;","\u2032",x)
x<-gsub("&#8243;","\u2033",x)
x<-gsub("&#8254;","\u203E",x)
x<-gsub("&#8260;","\u2044",x)
x<-gsub("&#8472;","\u2118",x)
x<-gsub("&#8465;","\u2111",x)
x<-gsub("&#8476;","\u211C",x)
x<-gsub("&#8482;","\u2122",x)
x<-gsub("&#8592;","\u2190",x)
x<-gsub("&#8593;","\u2191",x)
x<-gsub("&#8594;","\u2192",x)
x<-gsub("&#8595;","\u2193",x)
x<-gsub("&#8596;","\u2194",x)
x<-gsub("&#8629;","\u21B5",x)
x<-gsub("&#8656;","\u21D0",x)
x<-gsub("&#8657;","\u21D1",x)
x<-gsub("&#8658;","\u21D2",x)
x<-gsub("&#8659;","\u21D3",x)
x<-gsub("&#8660;","\u21D4",x)
x<-gsub("&#8704;","\u2200",x)
x<-gsub("&#8706;","\u2202",x)
x<-gsub("&#8707;","\u2203",x)
x<-gsub("&#8709;","\u2205",x)
x<-gsub("&#8711;","\u2207",x)
x<-gsub("&#8712;","\u2208",x)
x<-gsub("&#8713;","\u2209",x)
x<-gsub("&#8715;","\u220B",x)
x<-gsub("&#8719;","\u220F",x)
x<-gsub("&#8721;","\u2211",x)
x<-gsub("&#8722;","\u2212",x)
x<-gsub("&#8727;","\u2217",x)
x<-gsub("&#8730;","\u221A",x)
x<-gsub("&#8733;","\u221D",x)
x<-gsub("&#8734;","\u221E",x)
x<-gsub("&#8736;","\u2220",x)
x<-gsub("&#8743;","\u2227",x)
x<-gsub("&#8744;","\u2228",x)
x<-gsub("&#8745;","\u2229",x)
x<-gsub("&#8746;","\u222A",x)
x<-gsub("&#8747;","\u222B",x)
x<-gsub("&#8756;","\u2234",x)
x<-gsub("&#8764;","\u223C",x)
x<-gsub("&#8773;","\u2245",x)
x<-gsub("&#8776;","\u2248",x)
x<-gsub("&#8800;","\u2260",x)
x<-gsub("&#8801;","\u2261",x)
x<-gsub("&#8804;","\u2264",x)
x<-gsub("&#8805;","\u2265",x)
x<-gsub("&#8834;","\u2282",x)
x<-gsub("&#8835;","\u2283",x)
x<-gsub("&#8836;","\u2284",x)
x<-gsub("&#8838;","\u2286",x)
x<-gsub("&#8839;","\u2287",x)
x<-gsub("&#8853;","\u2295",x)
x<-gsub("&#8855;","\u2297",x)
x<-gsub("&#8869;","\u22A5",x)
x<-gsub("&#8901;","\u22C5",x)
x<-gsub("&#8968;","\u2308",x)
x<-gsub("&#8969;","\u2309",x)
x<-gsub("&#8970;","\u230A",x)
x<-gsub("&#8971;","\u230B",x)
x<-gsub("&#9001;","\u2329",x)
x<-gsub("&#9002;","\u232A",x)
x<-gsub("&#9674;","\u25CA",x)
x<-gsub("&#9824;","\u2660",x)
x<-gsub("&#9827;","\u2663",x)
x<-gsub("&#9829;","\u2665",x)
x<-gsub("&#9830;","\u2666",x)
x<-gsub("&#338;","\u0152",x)
x<-gsub("&#339;","\u0153",x)
x<-gsub("&#352;","\u0160",x)
x<-gsub("&#353;","\u0161",x)
x<-gsub("&#376;","\u0178",x)
x<-gsub("&#710;","\u02C6",x)
x<-gsub("&#732;","\u02DC",x)
x<-gsub("&#8194;","\u2002",x)
x<-gsub("&#8195;","\u2003",x)
x<-gsub("&#8201;","\u2009",x)
x<-gsub("&#8204;","\u200C",x)
x<-gsub("&#8205;","\u200D",x)
x<-gsub("&#8206;","\u200E",x)
x<-gsub("&#8207;","\u200F",x)
x<-gsub("&#8212;","\u2014",x)
x<-gsub("&#8216;","\u2018",x)
x<-gsub("&#8217;","\u2019",x)
x<-gsub("&#8218;","\u201A",x)
x<-gsub("&#8220;","\u201C",x)
x<-gsub("&#8221;","\u201D",x)
x<-gsub("&#8222;","\u201E",x)
x<-gsub("&#8224;","\u2020",x)
x<-gsub("&#8225;","\u2021",x)
x<-gsub("&#8240;","\u2030",x)
x<-gsub("&#8364;","\u20AC",x)

# rare signs
x<-gsub("&#161;","\u00A1",x)
x<-gsub("&#162;","\u00A2",x)
x<-gsub("&#163;","\u00A3",x)
x<-gsub("&#164;","\u00A4",x)
x<-gsub("&#165;","\u00A5",x)
x<-gsub("&#166;","\u00A6",x)
x<-gsub("&#167;","\u00A7",x)
x<-gsub("&#168;","\u00A8",x)
}}}
return(x)
}

