% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/XLtable1.r
\name{XLtable1}
\alias{XLtable1}
\title{"Table 1" Style List of Tables exported to a spreadsheet}
\usage{
XLtable1(wb, sheet, DF, colvar = NULL, fun = XLoneWay, title = "Table 1",
  colTitle = NULL, colNames = NULL, row1 = 1, col1 = 1, digits = NULL,
  useNA = "ifany", ..., purge = FALSE)
}
\arguments{
\item{wb}{a \code{\link[XLConnect]{workbook-class}} object}

\item{sheet}{numeric or character: a worksheet name (character) or position (numeric) within \code{wb}.}

\item{DF}{a rectangular array with all variables to be tabulated.}

\item{colvar}{vector; specifies the variable to cross-tabulate for \code{fun=\link{XLtwoWay}} (see 'Details' for convenience options), or to stratify for \code{\link{XLunivariate}}. Has to be the entire variable, rather than just a name.}

\item{fun}{The \code{table1xls} function to apply for each variable. Default \code{\link{XLoneWay}}. Other supported functions are \code{\link{XLtwoWay},\link{XLunivariate}}.}

\item{title}{character: an optional overall title to the table. Default \code{"Table 1"}.}

\item{colTitle}{character: the title to be placed above the first column of the column variable. Default \code{NULL}.}

\item{colNames}{character: when relevant, more descriptive names for columns in case \code{colvar} is used. Default \code{NULL}, which will use the unique values of \code{colvar} as names.}

\item{row1, col1}{numeric: the first row and column occupied by the table (title included if relevant).}

\item{digits}{numeric: how many digits (after the decimal point) to show in the percents? Defaults to 1 if n>=500 or if using \code{\link{XLunivariate}}, and 0 otherwise.}

\item{useNA}{How to handle missing values. Passed on to \code{\link{table}} (see help on that function for options).}

\item{...}{additional arguments as needed, to pass on to \code{fun}; for example, non-default summary function choices for \code{\link{XLunivariate}}.}

\item{purge}{logical should \code{sheet} be created anew, by first removing the previous copy if it exists? (default \code{FALSE})}
}
\value{
The function returns invisibly, after writing the data into \code{sheet} and saving the file.
}
\description{
Formats and exports a series of shared-structure tables, and saves the file.
}
\details{
Auto-generation of a series of tables of the same type for a single dataset. One-way and two-way contingency tables and numerical summaries are all supported, but all summaries call the same atomic \code{fun}.

The function employs convenience conventions for two-way tabulation: first, if \code{colvar} is specified and \code{fun} is left blank, then \code{fun} will be set to \code{\link{XLtwoWay}}. Second, if \code{fun=XLtwoWay} and \code{colvar} is left blank, then \code{colvar} will be set to the last column of \code{DF}.

For numerical summaries, use \code{fun=XLunivariate}. If you specify \code{colvar}, two-way summaries stratified by \code{colvar} will be returned.

Note that this function does not mix and match. Just make several calls to \code{XLtable1} with different sub-datasets and different values of \code{fun}, and combine the results in your report document.

In a similar vein, two-way summaries do not return the marginal one-way summaries as a byproduct. For example, if you use \code{fun=XLtwoWay}, then in order to get column totals for the generated two-way output, you will need to call \code{XLtable1} again on the same data, using the default \code{fun=XLoneWay}.

See the \code{\link{XLtwoWay}} help page, for behavior regarding new-sheet creation, overwriting, etc.
}
\examples{
table1<-XLwriteOpen("table1.xls") 

## A default, option-free call generates one-way tables
XLtable1(table1,'cars1',mtcars[,c(2,8:11)])
## You can prettify a bit, first by changing variable names

names(mtcars)[c(2,8:11)]=c("Cylinders","V/S","Auto/Manual","Gears","Carbureutors")
XLtable1(table1,'cars1',mtcars[,c(2,8:11)],
         title="'mtcars': Summary of Categorical Variables",col1=4)

## Now two-way, generated implicitly by specifying 'colvar' (unless fun=XLunivariate)
XLtable1(table1,'cars2',mtcars[,8:11],colvar=mtcars$Cylinders,
         title="Cylinders vs. categorical variables",colTitle="Cylinders")

## Finally, two-way numerical summaries for continuous variables
names(mtcars)[c(1,3:7)]=c('MPG','Engine Vol.','HP',"Axle Ratio","Weight","Quarter Mile")
XLtable1(table1,'carsContinuous',mtcars[,c(1,3:7)],fun=XLunivariate,colvar=mtcars$Cylinders,
         title="Cylinders vs. continuous variables",colTitle="Cylinders")

cat("Look for",paste(getwd(),"table1.xls",sep='/'),"to see the results!\\n")
}
\seealso{
\code{\link{XLoneWay}},\code{\link{XLtwoWay}},\code{\link{XLunivariate}}.
}
\author{
Assaf P. Oron \code{<assaf.oron.at.seattlechildrens.org>}
}
