% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table1.R
\name{render.categorical.default}
\alias{render.categorical.default}
\title{Render categorical values for table output.}
\usage{
render.categorical.default(x, ...)
}
\arguments{
\item{x}{A vector of type \code{factor}, \code{character} or \code{logical}.}

\item{...}{Further arguments, passed to \code{\link{stats.apply.rounding}}.}
}
\value{
A \code{character} vector. Each element is to be displayed in a
separate cell in the table. The \code{\link{names}} of the vector are the
labels to use in the table. However, the first names should be empty as it
will be replaced by the name of the variable. Empty strings are allowed and
result in empty table cells.
}
\description{
Called from \code{\link{table1}} by default to render categorical (i.e.
\code{factor}, \code{character} or \code{logical}) values for displaying in the table.
}
\examples{
y <- factor(sample(0:1, 99, replace=TRUE), labels=c("Female", "Male"))
y[1:10] <- NA
render.categorical.default(y)
}
\keyword{utilities}
