% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/font_info.R
\name{glyph_info}
\alias{glyph_info}
\title{Query glyph-specific information from fonts}
\usage{
glyph_info(
  glyphs,
  family = "",
  italic = FALSE,
  bold = FALSE,
  size = 12,
  res = 72,
  path = NULL,
  index = 0
)
}
\arguments{
\item{glyphs}{A vector of glyphs. Strings will be split into separate glyphs
automatically}

\item{family}{The name of the font families to match}

\item{italic}{logical indicating the font slant}

\item{bold}{logical indicating whether the font weight}

\item{size}{The pointsize of the font to use for size related measures}

\item{res}{The ppi of the size related mesures}

\item{path, index}{path an index of a font file to circumvent lookup based on
family and style}
}
\value{
A data.frame with information about each glyph, containing the following
columns:

\describe{
\item{glyph}{The glyph as a character}
\item{index}{The index of the glyph in the font file}
\item{width}{The width of the glyph}
\item{height}{The height of the glyph}
\item{x_bearing}{The horizontal distance from the origin to the leftmost part of the glyph}
\item{y_bearing}{The vertical distance from the origin to the top part of the glyph}
\item{x_advance}{The horizontal distance to move the cursor after adding the glyph}
\item{y_advance}{The vertical distance to move the cursor after adding the glyph}
\item{bbox}{The tight bounding box surrounding the glyph}
}
}
\description{
This function allows you to extract information about the individual glyphs
in a font, based on a specified size. All size related measures are in
pixel-units. The function is vectorised to the length of the \code{glyphs} vector.
}
