% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/som_clas.R
\name{som_clas}
\alias{som_clas}
\title{Self-Organizing Maps classification}
\usage{
som_clas(
  x,
  xdim,
  ydim,
  iter = 2000,
  alpha = c(0.05, 0.01),
  dist.fcts = "euclidean",
  mode = "online",
  cores = 1,
  norm = T
)
}
\arguments{
\item{x}{data.frame. A data.frame with the following variables: \code{lon, lat, time, value, anom_value}. See \code{tidy_nc}.}

\item{xdim}{Integer. X dimension of the grid. See \code{somgrid} from \code{kohonen} package.}

\item{ydim}{Integer. Y dimension of the grid. See \code{somgrid} from \code{kohonen} package.}

\item{iter}{integer. Number of iterations.}

\item{alpha}{vector. learning rate. See \code{som} from \code{kohonen} package for details.}

\item{dist.fcts}{character. vector of distance functions to be used for the individual data layers. See \code{som} from \code{kohonen} package for details.}

\item{mode}{carachter. type of learning algorithm. Default "on-line". See \code{kohonen} package for details.}

\item{cores}{Integer. Parallel processing only available for "pbatch" algorithm.}

\item{norm}{logical. Default \code{TRUE}. \code{norm = TRUE} is recommended for classifying two ore more variables.}
}
\value{
A list with: \itemize{
   \item{A data.frame containing the dates and the weather types.}
   \item{A data frame containing the gridded data grouped by circulation types.}
   \item{An object of class \code{kohonen} with all the components returned by the function \code{som}}
}
}
\description{
\code{som_clas} allows to perform a SOM synoptic classification
}
\examples{
# Load data
data(z500)
# Tidying our atmospheric variables (500 hPa geopotential height).
z500_tidy <- tidy_nc(x = list(z500),
             name_vars = c("z500"))

# SOM classification
som_cl <- som_clas(z500_tidy, xdim = 4, ydim = 4, iter = 200)


}
\references{
{
Wehrens, R. and BuydenL. (2007)
\emph{Self- and Super-organizing Maps in R: The kohonen Package}
Journal of Statistical Software, 21(5), 1 - 19.
}
}
\seealso{
\code{\link{tidy_nc}}
}
