% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raster_clas.R
\name{raster_clas}
\alias{raster_clas}
\title{Raster conversion of the Synoptic Classification}
\usage{
raster_clas(longitude, latitude, grouped_data)
}
\arguments{
\item{longitude}{Numeric vector containing longitudes}

\item{latitude}{Numeric vector containing latitudes}

\item{grouped_data}{Data frame. S-mode data frame containing an integer column with the weather types. i.e. output obtained from \code{synoptclas} function.}
}
\value{
a Raster Stack containing the circulation weather types.
}
\description{
This function convert the dataframe of the synoptic classification data into a Raster Stack format.
}
\examples{
# Load data (mslp)
data(mslp)
# Converting our data, but without modifying time period
smode_mslp <- tidy_cuttime_nc(mslp, only_convert = TRUE)
# classification performance
smode_clas <- synoptclas(smode_mslp$smode_data, ncomp = 6)
# convert all the precipitation maps based on CWT to a raster stack
raster_clas(longitude = mslp$lon, latitude = mslp$lat,
            grouped_data = smode_clas$grouped_data)

}
