/*
 * Decompiled with CFR 0.152.
 */
package main;

import beagleutil.Samples;
import blbutil.InputIterator;
import blbutil.StringUtil;
import java.io.File;
import java.util.Arrays;

public class NuclearFamilies {
    private final File pedFile;
    private final Samples samples;
    private final int[] single;
    private final int[] duoOffspring;
    private final int[] trioOffspring;
    private final int[] mother;
    private final int[] father;

    public NuclearFamilies(Samples samples, File file) {
        this.pedFile = file;
        this.samples = samples;
        this.father = new int[samples.nSamples()];
        this.mother = new int[samples.nSamples()];
        boolean[] blArray = new boolean[samples.nSamples()];
        Arrays.fill(this.father, -1);
        Arrays.fill(this.mother, -1);
        if (file != null) {
            NuclearFamilies.identifyParents(samples, file, blArray, this.father, this.mother);
        }
        int[] nArray = this.counts(blArray, this.father, this.mother);
        this.single = new int[nArray[0]];
        this.duoOffspring = new int[nArray[1]];
        this.trioOffspring = new int[nArray[2]];
        NuclearFamilies.fillArrays(samples, blArray, this.father, this.mother, this.single, this.duoOffspring, this.trioOffspring);
    }

    private int[] counts(boolean[] blArray, int[] nArray, int[] nArray2) {
        assert (blArray.length == nArray.length);
        assert (blArray.length == nArray2.length);
        int[] nArray3 = new int[3];
        for (int i = 0; i < blArray.length; ++i) {
            int n = 0;
            if (nArray[i] >= 0) {
                ++n;
            }
            if (nArray2[i] >= 0) {
                ++n;
            }
            if (n == 0) {
                if (blArray[i]) continue;
                nArray3[0] = nArray3[0] + 1;
                continue;
            }
            int n2 = n;
            nArray3[n2] = nArray3[n2] + 1;
        }
        return nArray3;
    }

    private static void identifyParents(Samples samples, File file, boolean[] blArray, int[] nArray, int[] nArray2) {
        String string = "0";
        boolean[] blArray2 = new boolean[samples.nSamples()];
        try (InputIterator inputIterator = InputIterator.fromGzipFile(file);){
            while (inputIterator.hasNext()) {
                int n;
                String string2 = ((String)inputIterator.next()).trim();
                if (string2.length() <= 0) continue;
                String[] stringArray = NuclearFamilies.getPedFields(string2);
                String string3 = stringArray[1];
                String string4 = stringArray[2];
                String string5 = stringArray[3];
                int n2 = samples.index(string3);
                if (n2 == -1) continue;
                if (blArray2[n2]) {
                    String string6 = "duplicate sample in pedigree file: " + string3;
                    throw new IllegalArgumentException(string6);
                }
                blArray2[n2] = true;
                if (!string4.equals(string) && (n = samples.index(string4)) != -1) {
                    blArray[n] = true;
                    nArray[n2] = n;
                }
                if (string5.equals(string) || (n = samples.index(string5)) == -1) continue;
                blArray[n] = true;
                nArray2[n2] = n;
            }
        }
    }

    private static String[] getPedFields(String string) {
        String[] stringArray = StringUtil.getFields(string, 5);
        if (stringArray.length < 4) {
            String string2 = "invalid line in ped file: " + string;
            throw new IllegalArgumentException(string2);
        }
        return stringArray;
    }

    private static void fillArrays(Samples samples, boolean[] blArray, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, int[] nArray5) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = samples.nSamples();
        block5: for (int i = 0; i < n4; ++i) {
            int n5 = NuclearFamilies.nParents(i, nArray, nArray2);
            switch (n5) {
                case 0: {
                    if (blArray[i]) continue block5;
                    nArray3[n++] = i;
                    continue block5;
                }
                case 1: {
                    nArray4[n2++] = i;
                    continue block5;
                }
                case 2: {
                    nArray5[n3++] = i;
                    continue block5;
                }
                default: {
                    assert (false);
                    continue block5;
                }
            }
        }
        assert (n == nArray3.length);
        assert (n2 == nArray4.length);
        assert (n3 == nArray5.length);
    }

    private static int nParents(int n, int[] nArray, int[] nArray2) {
        int n2 = 0;
        if (nArray[n] >= 0) {
            ++n2;
        }
        if (nArray2[n] >= 0) {
            ++n2;
        }
        return n2;
    }

    public Samples samples() {
        return this.samples;
    }

    public int nSamples() {
        return this.samples.nSamples();
    }

    public File pedFile() {
        return this.pedFile;
    }

    public int nSingles() {
        return this.single.length;
    }

    public int nDuos() {
        return this.duoOffspring.length;
    }

    public int nTrios() {
        return this.trioOffspring.length;
    }

    public int single(int n) {
        return this.single[n];
    }

    public int duoParent(int n) {
        int n2 = this.duoOffspring[n];
        if (this.father[n2] >= 0) {
            return this.father[n2];
        }
        assert (this.mother[n2] >= 0);
        return this.mother[n2];
    }

    public int duoOffspring(int n) {
        return this.duoOffspring[n];
    }

    public int trioFather(int n) {
        return this.father[this.trioOffspring[n]];
    }

    public int trioMother(int n) {
        return this.mother[this.trioOffspring[n]];
    }

    public int trioOffspring(int n) {
        return this.trioOffspring[n];
    }

    public int father(int n) {
        return this.father[n];
    }

    public int mother(int n) {
        return this.mother[n];
    }
}

