% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_geodata.R
\name{get_geodata}
\alias{get_geodata}
\title{Get Swiss Geodata}
\usage{
get_geodata(geolevel = "municipality", latest = T, verbose = F, call_res)
}
\arguments{
\item{geolevel}{geographical level. Options: "national", "canton", "district", "municipality", "zh_counting_districts" or "lakes".}

\item{latest}{if \code{TRUE}, the latest data is retrieved. If \code{FALSE}, geo data from the beginning of the year is retrieved. 
The API does not support finer distinctions. For more detailed information on the exact status of the data, please use 
\code{verbode = TRUE}.}

\item{verbose}{if \code{TRUE}, the date from which the data originates is displayed.}

\item{call_res}{result of a previous call to the geodata API. Optional argument.}
}
\value{
a simple feature collection of the desired spatial units with corresponding IDs.
}
\description{
\code{get_geodata} retrieves the latest geodata provided by the Federal Statistical Office in connection with federal votes.
}
\examples{

# Get latest geodata at municipal level
get_geodata()

# Get latest geodata at cantonal level
get_geodata(geolevel = "canton")

}
