% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidiers_stl.R
\name{tidiers_stl}
\alias{tidiers_stl}
\alias{sw_tidy.stl}
\alias{sw_tidy_decomp.stl}
\alias{sw_tidy_decomp.stlm}
\title{Tidying methods for STL (Seasonal, Trend, Level) decomposition of time series}
\usage{
\method{sw_tidy}{stl}(x, ...)

\method{sw_tidy_decomp}{stl}(x, timetk_idx = FALSE, rename_index = "index",
  ...)

\method{sw_tidy_decomp}{stlm}(x, timetk_idx = FALSE, rename_index = "index",
  ...)
}
\arguments{
\item{x}{An object of class "stl" or "stlm"}

\item{...}{Not used.}

\item{timetk_idx}{Used with \code{sw_tidy_decomp}.
When \code{TRUE}, uses a timetk index (irregular, typically date or datetime) if present.}

\item{rename_index}{Used with \code{sw_tidy_decomp}.
A string representing the name of the index generated.}
}
\value{
\strong{\code{sw_tidy()}} wraps \code{sw_tidy_decomp()}

\strong{\code{sw_tidy_decomp()}} returns a tibble with the following time series attributes:
\itemize{
\item \code{index}: An index is either attempted to be extracted from the model or
a sequential index is created for plotting purposes
\item \code{season}: The seasonal component
\item \code{trend}: The trend component
\item \code{remainder}: observed - (season + trend)
\item \code{seasadj}: observed - season (or trend + remainder)
}
}
\description{
Tidying methods for STL (Seasonal, Trend, Level) decomposition of time series
}
\examples{
library(forecast)
library(sweep)

fit_stl <- USAccDeaths \%>\%
    stl(s.window = "periodic")

sw_tidy_decomp(fit_stl)

}
\seealso{
\code{\link[=stl]{stl()}}
}
