% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rnd.R
\name{rnd}
\alias{rnd}
\title{Relative Norm Distance}
\usage{
rnd(w, S_words, A_words, B_words, verbose = FALSE)
}
\arguments{
\item{w}{a numeric matrix of word embeddings, e.g. from \code{\link{read_word2vec}}}

\item{S_words}{a character vector of the first set of target words. In an example of studying gender stereotype, it can include occupations such as programmer, engineer, scientists...}

\item{A_words}{a character vector of the first set of attribute words. In an example of studying gender stereotype, it can include words such as man, male, he, his.}

\item{B_words}{a character vector of the second set of attribute words. In an example of studying gender stereotype, it can include words such as woman, female, she, her.}

\item{verbose}{logical, whether to display information}
}
\value{
A list with class \code{"rnd"} containing the following components:
\describe{
\item{\code{$norm_diff}}{a vector of relative norm distances for every word in S_words}
\item{\code{$S_words}}{the input S_words}
\item{\code{$A_words}}{the input A_words}
\item{\code{$B_words}}{the input B_words}
}
\code{\link{rnd_es}} can be used to obtain the effect size of the test.
}
\description{
This function calculate the relative norm distance (RND) of word embeddings. If possible, please use \code{\link[=query]{query()}} instead.
}
\examples{
data(googlenews)
S1 <- c("janitor", "statistician", "midwife", "bailiff", "auctioneer",
"photographer", "geologist", "shoemaker", "athlete", "cashier", "dancer",
"housekeeper", "accountant", "physicist", "gardener", "dentist", "weaver",
"blacksmith", "psychologist", "supervisor", "mathematician", "surveyor",
"tailor", "designer", "economist", "mechanic", "laborer", "postmaster",
"broker", "chemist", "librarian", "attendant", "clerical", "musician",
"porter", "scientist", "carpenter", "sailor", "instructor", "sheriff",
"pilot", "inspector", "mason", "baker", "administrator", "architect",
"collector", "operator", "surgeon", "driver", "painter", "conductor",
"nurse", "cook", "engineer", "retired", "sales", "lawyer", "clergy",
"physician", "farmer", "clerk", "manager", "guard", "artist", "smith",
"official", "police", "doctor", "professor", "student", "judge",
"teacher", "author", "secretary", "soldier")
A1 <- c("he", "son", "his", "him", "father", "man", "boy", "himself",
"male", "brother", "sons", "fathers", "men", "boys", "males", "brothers",
"uncle", "uncles", "nephew", "nephews")
B1 <- c("she", "daughter", "hers", "her", "mother", "woman", "girl",
"herself", "female", "sister", "daughters", "mothers", "women", "girls",
"females", "sisters", "aunt", "aunts", "niece", "nieces")
garg_f1 <- rnd(googlenews, S1, A1, B1)
plot_bias(garg_f1)
}
\references{
Garg, N., Schiebinger, L., Jurafsky, D., & Zou, J. (2018). Word embeddings quantify 100 years of gender and ethnic stereotypes. Proceedings of the National Academy of Sciences, 115(16), E3635-E3644. \doi{10.1073/pnas.1720347115}
}
\author{
Chung-hong Chan
}
