prince.plot <-
function(prince,label=colnames(prince$o),smallest=-20,note=F,notecol="black",notecex=1,breaks=100,col=heat.colors(99),margins=c(5,7),key=T,cexRow=1,cexCol=1,xlab="Principal Components (Variation)",colsep=NULL,rowsep=NULL,sepcolor="black",sepwidth=c(0.05,0.05)){
   if(class(prince)!="prince"){stop("prince is not an object generated by the function prince")}
   if(smallest>0){stop("smallest has to be less than 0")}
   require(gplots)
   linp10<-log10(prince$linp)
   linp10<-replace(linp10,linp10<=smallest,smallest)
   prop<-round(prince$prop,0)
   heatmap.2(linp10,Colv=F,Rowv=F,dendrogram="none",trace="none",symbreaks=F,symkey=F,breaks=breaks,key=key,col=col,cexRow=cexRow,cexCol=cexCol,colsep=colsep,rowsep=rowsep,sepcolor=sepcolor,sepwidth=sepwidth,
            main="",labCol=paste(1:ncol(linp10)," (",prop,")",sep=""),margins=margins,labRow=label,xlab=xlab,
            cellnote=if(note==T){signif(prince$linp,1)}else{matrix(ncol=ncol(prince$linp),nrow=nrow(prince$linp))},notecol=notecol,notecex=notecex) 
    }


