% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics_calc_pairwise.R
\name{pairwise_metrics}
\alias{pairwise_metrics}
\title{Pairwise Metrics of Collective Motion in a Dataset}
\usage{
pairwise_metrics(
  data_list,
  geo = FALSE,
  verbose = FALSE,
  parallelize = FALSE,
  add_coords = FALSE
)
}
\arguments{
\item{data_list}{A list of dataframes with groups timeseries per set.
Columns must include: \code{id}, \code{t}, \code{set}, \code{head},
 \code{x}, \code{y}.}

\item{geo}{Logical, whether positions are geographic coordinates,
default = FALSE.}

\item{verbose}{Logical, whether to post updates on progress, default = FALSE.}

\item{parallelize}{Logical, whether to run the function in parallel over
timesteps, default = FALSE.}

\item{add_coords}{Logical, whether data on relative positions are converted
into geographic coordinates, default = 'FALSE'.}
}
\value{
A dataframe format of the input list, with new columns for nearest neighbor id (\code{nn_id}),
bearing angles (\code{bangl}), and distances (\code{nnd}). If \code{add_coords} is TRUE, the columns
\code{nnx} and \code{nny} are also added.
}
\description{
This function calculates the bearing angle and distance from each
focal individual of a group to its nearest neighbor over time, across
the sets of a dataset.
}
\examples{

data <- data.frame(
 set = rep("1", 50),
 t = as.POSIXct(rep(1:25, 2), origin = Sys.time()),
 id = c(rep(1, 25), rep(2, 25)),
 x = rnorm(50),
 y = rnorm(50),
 head = runif(50, 0, 2 * pi)
 )

pm <- pairwise_metrics(list(data), geo = FALSE)

}
\seealso{
\code{\link{nn_metrics}, \link{group_metrics_per_set}}
}
\author{
Marina Papadopoulou \email{m.papadopoulou.rug@gmail.com}
}
