% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.svrpath.R
\name{predict.svrpath}
\alias{predict.svrpath}
\title{Make predictions from a "svrpath" object}
\usage{
\method{predict}{svrpath}(object, newx, lambda = NULL, criterion = "sic",
  ...)
}
\arguments{
\item{object}{The svrpath object}

\item{newx}{Values of x to be predicted. This is a matrix with observations per row. Default is x in the epspath object.}

\item{lambda}{the value of the regularization paramter, lambda.}

\item{criterion}{It provides predictions at an optimal \code{lambda} selected by SIC or GACV. \code{"sic"} or \code{"gacv"}.}

\item{...}{Generic compatibility}
}
\value{
In each case, the desired prediction.
}
\description{
Provides a prediction value at a given \code{lambda} from \code{svrpath} object.
}
\examples{
set.seed(1)
n <- 30
p <- 50

x <- matrix(rnorm(n*p), n, p)
e <- rnorm(n, 0, 1)
beta <- c(1, 1, rep(0, p-2))
y <- x \%*\% beta + e
svr.eps <- 1
obj <- svrpath(x, y, svr.eps = svr.eps)
predict.svrpath(obj, lambda = 10) # or
predict(obj, criterion = 'sic')
}
\author{
Dohyun Kim, Seung Jun Shin
}
