% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svgtools.R
\name{changeText}
\alias{changeText}
\title{Change text of text elements}
\usage{
changeText(
  svg,
  element_name,
  text,
  alignment = NULL,
  in_group = NULL,
  hide_blank = FALSE
)
}
\arguments{
\item{svg}{XML document with SVG content}

\item{element_name}{Name (attribute 'id') of text (XML element 'text') or current text entry of text (XML element 'text').}

\item{text}{New text entry.}

\item{alignment}{Character value for text alignment. Accepts 'start', 'middle', and 'end' (default NULL = no change).}

\item{in_group}{Name (attribute 'id') of group (XML element 'g') that contains the text element (default NULL = no group, search the entire SVG).}

\item{hide_blank}{Should text elements with empty strings be hidden (set attribute 'display' to 'none')? (default FALSE)}
}
\value{
XML document with SVG content
}
\description{
Changes the text entry of XML element of type 'text'. The XML element may be found by its name (XML attribute 'id') or based on its current text entry.
}
\examples{
#read SVG file
fpath <- system.file("extdata", "fig1.svg", package="svgtools")
svg <- read_svg(file = fpath)

#change a text
svg <- changeText(svg = svg, element_name = "Category A", text = "low")
svg <- changeText(svg = svg, element_name = "Category B", text = "medium")
svg <- changeText(svg = svg, element_name = "Category C", text = "high")
}
