% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SVG.R
\name{svgstring}
\alias{svgstring}
\title{Access current SVG as a string.}
\usage{
svgstring(width = 10, height = 8, bg = "white", pointsize = 12,
  standalone = TRUE)
}
\arguments{
\item{width}{Height and width in inches.}

\item{height}{Height and width in inches.}

\item{bg}{Default background color for the plot (defaults to "white").}

\item{pointsize}{Default point size.}

\item{standalone}{Produce a standalone svg file? If \code{FALSE}, omits
xml header and default namespace.}

\item{...}{Arguments passed on to \code{\link{svglite}}.}
}
\value{
A function with no arguments: call the function to get the
  current value of the string.
}
\description{
This is a variation on \code{\link{svglite}} that makes it easy to access
the current value as a string.
}
\examples{
s <- svgstring(); s()

plot.new(); s();
text(0.5, 0.5, "Hi!"); s()
dev.off()

s <- svgstring()
plot(rnorm(5), rnorm(5))
s()
dev.off()
}

