% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cox_res.R
\name{get_cox_res}
\alias{get_cox_res}
\title{Run Cox Regression on a Single or Multiple Groups of Data}
\usage{
get_cox_res(in.df, endpoint, endpoint.code, features, group = NULL,
  broom.fun = c("tidy", "glance"))
}
\arguments{
\item{in.df}{Input data.frame.}

\item{endpoint}{Column name of the endpoint.}

\item{endpoint.code}{Column name of the endpoint status code.}

\item{features}{Vector containing the features to run cox regression on.}

\item{group}{Column name containing the groups to run cox regression on. If,
specified, cox regression is run separately for each group.}

\item{broom.fun}{Which broom function to run on the cox regression results.}
}
\value{
Cox regression results returned in a tidy data.frame format.
}
\description{
\code{get_cox_res} is a wrapper around coxph. It can run
univariate or multivariate cox regression. If the group parameter is used, 
then cox regression is run for each group separately.
}
\details{
The data is returned in a broom::tidy data.frame format.
}
\examples{
library("survival")
endpoint <- "time"
endpoint.code <- "status"

# Run Univariate Cox Regression on Single Feature
features <- "age"
test.df <- get_cox_res(colon, endpoint, endpoint.code, features)

# Run Univariate Cox Regression on Multiple Features
multi.features <- c("age", "obstruct")
get_cox_res(colon, endpoint, endpoint.code, multi.features)

# Run Univariate Cox Regression on Multiple Features For Each rx group
group <- "rx"
get_cox_res(colon, endpoint, endpoint.code, multi.features, group)

# Run Multivariate Cox Regression 
get_cox_res(colon, endpoint, endpoint.code, multi.features)

# Run Multivariate Cox Regression For Each rx Group
get_cox_res(colon, endpoint, endpoint.code, multi.features, group)
}
