% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hazards_fluctuate.R
\name{fluctuateHazards}
\alias{fluctuateHazards}
\title{Fluctuation for the Method of Cause-Specific Hazards}
\usage{
fluctuateHazards(dataList, allJ, ofInterestJ, nJ, uniqtrt, ntrt, t0, verbose,
  ...)
}
\arguments{
\item{dataList}{A list of \code{data.frame} objects.}

\item{allJ}{Numeric vector indicating the labels of all causes of failure.}

\item{ofInterestJ}{Numeric vector indicating \code{ftypeOfInterest} that was
passed to \code{hazard_tmle}.}

\item{nJ}{The number of unique failure types.}

\item{uniqtrt}{The values of \code{trtOfInterest} passed to \code{mean_tmle}.}

\item{ntrt}{The number of \code{trt} values of interest.}

\item{t0}{The timepoint at which \code{survtmle} was called to evaluate.}

\item{verbose}{A boolean indicating whether the function should print
messages to indicate progress.}

\item{...}{Other arguments. Not currently used.}
}
\value{
The function returns a list that is exactly the same as the input
        \code{dataList}, but with updated columns corresponding with
        estimated cumulative incidence at each time and estimated "clever
        covariates" at each time.
}
\description{
This function performs a fluctuation of an initial estimate of the
cause-specific hazard functions using a call to \code{glm} (i.e., a logistic
submodel) or a call to \code{optim} (to ensure fluctuations stay within model
space). The structure of the function is specific to how it is called within
\code{hazard_tmle}. In particular, \code{dataList} must have a very specific
structure for this function to run properly. The list should consist of
\code{data.frame} objects. The first will have the number of rows for each
observation equal to the \code{ftime} corresponding to that observation. The
subsequent entries will have \code{t0} rows for each observation and will set
\code{trt} column equal to each value of \code{trtOfInterest} in turn. The
function will fit a logistic regression with (a scaled version of) \code{Nj}
as outcome, the logit of the current (pseudo-) hazard estimate as offset and
the targeted minimum loss-based estimation "clever covariates". The function
then obtains predictions based on this fit on each of the \code{data.frame}
objects in \code{dataList}.
}
