% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_pycox.R
\name{get_pycox_optim}
\alias{get_pycox_optim}
\title{Get Pytorch Optimizer}
\usage{
get_pycox_optim(
  optimizer = "adam",
  net,
  rho = 0.9,
  eps = 1e-08,
  lr = 1,
  weight_decay = 0,
  learning_rate = 0.01,
  lr_decay = 0,
  betas = c(0.9, 0.999),
  amsgrad = FALSE,
  lambd = 1e-04,
  alpha = 0.75,
  t0 = 1e+06,
  momentum = 0,
  centered = TRUE,
  etas = c(0.5, 1.2),
  step_sizes = c(1e-06, 50),
  dampening = 0,
  nesterov = FALSE
)
}
\arguments{
\item{optimizer}{\code{(character(1))}\cr Optimizer, see details for list of implemented methods.}

\item{net}{\code{(torch.nn.modules.module.Module)}\cr Network architecture, can be built from
\link{build_pytorch_net}.}

\item{rho, lr, lr_decay}{\code{(numeric(1))}\cr Passed to \code{adadelta}.}

\item{eps}{\code{(numeric(1))}\cr Passed to all methods except \code{asgd}, \code{rprop}, and \code{sgd}.}

\item{weight_decay}{\code{(numeric(1))}\cr Passed to all methods except \code{rprop} and \code{sparse_adam}.}

\item{learning_rate}{\code{(numeric(1))}\cr Passed to all methods except \code{adadelta}.}

\item{betas}{\code{(numeric(2))}\cr Passed to \code{adam}, \code{adamax}, \code{adamw}, and \code{sparse_adam}.}

\item{amsgrad}{\code{(logical(1))}\cr Passed to \code{adam} and \code{adamw}.}

\item{lambd, t0}{\code{(numeric(1))}\cr Passed to \code{asgd}.}

\item{alpha}{\code{(numeric(1))}\cr Passed to \code{asgd} and \code{rmsprop}.}

\item{momentum}{\code{(numeric(1))}\cr Passed to \code{rmsprop} and \code{sgd}.}

\item{centered}{\code{(logical(1))}\cr Passed to \code{rmsprop}.}

\item{etas, step_sizes}{\code{(numeric(2))}\cr Passed to \code{rprop}.}

\item{dampening}{\code{(numeric(1))}\cr Passed to \code{sgd}.}

\item{nesterov}{\code{(logical(1))}\cr Passed to \code{sgd}.}
}
\description{
Helper function to return a constructed pytorch optimizer from \code{torch.optim}.
}
\details{
Implemented methods (with help pages) are
\itemize{
\item \code{"adadelta"} \cr \code{reticulate::py_help(torch$optim$Adadelta)}
\item \code{"adagrad"} \cr \code{reticulate::py_help(torch$optim$Adagrad)}
\item \code{"adam"} \cr \code{reticulate::py_help(torch$optim$Adam)}
\item \code{"adamax"} \cr \code{reticulate::py_help(torch$optim$Adamax)}
\item \code{"adamw"} \cr \code{reticulate::py_help(torch$optim$AdamW)}
\item \code{"asgd"} \cr \code{reticulate::py_help(torch$optim$ASGD)}
\item \code{"rmsprop"} \cr \code{reticulate::py_help(torch$optim$RMSprop)}
\item \code{"rprop"} \cr \code{reticulate::py_help(torch$optim$Rprop)}
\item \code{"sgd"} \cr \code{reticulate::py_help(torch$optim$SGD)}
\item \code{"sparse_adam"} \cr \code{reticulate::py_help(torch$optim$SparseAdam)}
}
}
