% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/server.R
\name{sd_server}
\alias{sd_server}
\title{Server logic for a surveydown survey}
\usage{
sd_server(
  db = NULL,
  required_questions = NULL,
  all_questions_required = FALSE,
  start_page = NULL,
  auto_scroll = FALSE,
  rate_survey = FALSE,
  language = "en",
  use_cookies = TRUE
)
}
\arguments{
\item{db}{A list containing database connection information created using
\code{sd_database()} function. Defaults to \code{NULL}.}

\item{required_questions}{Vector of character strings. The IDs of questions
that must be answered. Defaults to \code{NULL}.}

\item{all_questions_required}{Logical. If \code{TRUE}, all questions in the
survey will be required. Defaults to \code{FALSE}.}

\item{start_page}{Character string. The ID of the page to start on.
Defaults to \code{NULL}.}

\item{auto_scroll}{Logical. Whether to enable auto-scrolling to the next
question after answering. Defaults to \code{FALSE}.}

\item{rate_survey}{Logical. If \code{TRUE}, shows a rating question when exiting
the survey. If \code{FALSE}, shows a simple confirmation dialog.
Defaults to \code{FALSE}.}

\item{language}{Set the language for the survey system messages. Include
your own in a \code{translations.yml} file, or choose a built in one from
the following list: English (\code{"en"}), German (\code{"de"}), Spanish (\code{"es"}),
French (\code{"fr"}), Italian (\code{"it"}). Simplified Chinese (\code{"zh-CN"}).
Defaults to \code{"en"}.}

\item{use_cookies}{Logical. If \code{TRUE}, enables cookie-based session management
for storing and restoring survey progress. Defaults to \code{TRUE}.}
}
\value{
This function does not return a value; it sets up the server-side logic for
the 'shiny' application.
}
\description{
This function defines the server-side logic for a 'shiny' application used in
surveydown. It handles various operations such as conditional display,
progress tracking, page navigation, database updates for survey responses,
and exit survey functionality.
}
\details{
The function performs the following tasks:
\itemize{
\item Initializes variables and reactive values.
\item Implements conditional display logic for questions.
\item Tracks answered questions and updates the progress bar.
\item Handles page navigation and skip logic.
\item Manages required questions.
\item Performs database operation.
\item Controls auto-scrolling behavior based on the \code{auto_scroll} argument.
\item Uses sweetalert for warning messages when required questions are not
answered.
\item Handles the exit survey process based on the \code{rate_survey} argument.
}
}
\section{Progress Bar}{

The progress bar is updated based on the last answered question. It will jump
to the percentage corresponding to the last answered question and will never
decrease, even if earlier questions are answered later. The progress is
calculated as the ratio of the last answered question's index to the total
number of questions.
}

\section{Database Operations}{

If \code{db} is provided, the function will update the database with survey
responses. If \code{db} is \code{NULL} (ignore mode), responses will be saved to a local
CSV file.
}

\section{Auto-Scrolling}{

When \code{auto_scroll} is \code{TRUE}, the survey will automatically scroll to the
next question after the current question is answered. This behavior can be
disabled by setting \code{auto_scroll = FALSE}.
}

\section{Exit Survey}{

When \code{rate_survey = TRUE}, the function will show a rating question when
the user attempts to exit the survey. When \code{FALSE}, it will show a simple
confirmation dialog. The rating, if provided, is saved with the survey data.
}

\examples{
if (interactive()) {
  library(surveydown)

  # Get path to example survey file
  survey_path <- system.file("examples", "basic_survey.qmd",
                             package = "surveydown")

  # Copy to a temporary directory
  temp_dir <- tempdir()
  file.copy(survey_path, file.path(temp_dir, "survey.qmd"))
  orig_dir <- getwd()
  setwd(temp_dir)

  # Define a minimal server
  server <- function(input, output, session) {

    # sd_server() accepts these following parameters
    sd_server(
      db = NULL,
      required_questions = NULL,
      all_questions_required = FALSE,
      start_page = NULL,
      auto_scroll = FALSE,
      rate_survey = FALSE,
      language = "en",
      use_cookies = TRUE
    )
  }

  # Run the app
  shiny::shinyApp(ui = sd_ui(), server = server)

  # Clean up
  setwd(orig_dir)
}

}
\seealso{
\code{sd_database()}, \code{sd_ui()}
}
