% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{loss_integrate}
\alias{loss_integrate}
\title{Calculate integrated metrics based on time-dependent metrics.}
\usage{
loss_integrate(loss_function, ..., normalization = NULL, max_quantile = 1)
}
\arguments{
\item{loss_function}{\itemize{
\item A time dependent loss function taking arguments (y_true, risk, surv, times)
}}

\item{...}{\itemize{
\item other parameters, currently ignored
}}

\item{normalization}{\itemize{
\item either NULL, "t_max" or "survival". Decides what kind of weighting should be applied to the integrated metric. If "t_max", then the integral is calculated using dw(t) where w(t) = t/t_max. If "survival", then the integral is calculated using dw(t) where w(t) = (1 - S(t))/(1 - S(t_max)) and S(t) denotes the estimated marginal survival function. If NULL (default), the integral is calculated using dt.
}}

\item{max_quantile}{\itemize{
\item a number from the interval (0,1]. The integral will be calculated only up to the time value of \code{quantile(max_quantile)} of the observed event/censoring times in \code{y_true}.
}}
}
\value{
a function that can be used to calculate metrics (with parameters \code{y_true}, \code{risk}, \code{surv}, and \code{times})
}
\description{
This function allows for creating a function for calculation of integrated metrics based on a time dependent metric. A possibility to cut off the data at certain quantiles is implemented, as well as weighting the integrated metric by max time and marginal survival function [\href{https://onlinelibrary.wiley.com/doi/abs/10.1002/\%28SICI\%291097-0258\%2819990915/30\%2918\%3A17/18\%3C2529\%3A\%3AAID-SIM274\%3E3.0.CO\%3B2-5}{1}]
}
\section{References}{

\itemize{
\item [1] Graf, Erika, et al. \href{https://onlinelibrary.wiley.com/doi/abs/10.1002/\%28SICI\%291097-0258\%2819990915/30\%2918\%3A17/18\%3C2529\%3A\%3AAID-SIM274\%3E3.0.CO\%3B2-5}{"Assessment and comparison of prognostic classification schemes for survival data."} Statistics in Medicine 18.17‐18 (1999): 2529-2545.
}
}

