% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_surv_feature_importance.R
\name{plot.surv_feature_importance}
\alias{plot.surv_feature_importance}
\title{Plot Permuatational Feature Importance for Survival Models}
\usage{
\method{plot}{surv_feature_importance}(
  x,
  ...,
  title = "Time-dependent feature importance",
  subtitle = NULL,
  max_vars = 6,
  colors = NULL
)
}
\arguments{
\item{x}{an object of class \code{"surv_feature_importance"} to be plotted}

\item{...}{additional objects of class \code{"surv_feature_importance"} to be plotted together}

\item{title}{character, title of the plot}

\item{subtitle}{character, subtitle of the plot, if \code{NULL} automaticaly generated as "created for XXX, YYY models", where XXX and YYY are explainer labels}

\item{max_vars}{maximum number of variables to be plotted (least important variables are ignored)}

\item{colors}{character vector containing the colors to be used for plotting variables (containing either hex codes "#FF69B4", or names "blue")}
}
\value{
A \code{ggplot2} plot.
}
\description{
This function plots feature importance objects created for survival models.
}
\examples{
\donttest{
library(survival)
library(survex)

model <- coxph(Surv(time, status) ~ ., data = veteran, x = TRUE, model = TRUE, y = TRUE)
model_rf <- randomForestSRC::rfsrc(Surv(time, status) ~ ., data = veteran)
explainer <- explain(model)
explainer_rf <- explain(model_rf)

mp <- model_parts(explainer)
mp_rf <- model_parts(explainer_rf)

plot(mp, mp_rf)
}
}
\seealso{
Other functions for plotting 'model_parts_survival' objects: 
\code{\link{plot.model_parts_survival}()}
}
\concept{functions for plotting 'model_parts_survival' objects}
