% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theil.R
\name{plot.theil}
\alias{plot.theil}
\alias{plot.theil_list}
\alias{print.theil}
\alias{print.theil_list}
\title{Methods for Theil's index}
\usage{
\method{plot}{theil}(
  x,
  style = c("mean_qi", "lines"),
  M = 250,
  col = "black",
  fill = "black",
  alpha,
  lwd,
  base_size = 14,
  scale = 100,
  labels = x$summary$time,
  ...
)

\method{plot}{theil_list}(
  x,
  style = c("mean_qi", "lines"),
  M = 250,
  col = "black",
  fill = "black",
  alpha,
  lwd,
  between_title = "Between",
  within_title = "Within",
  total_title = "Total",
  scale = 100,
  plot = TRUE,
  ncol = 3,
  base_size = 14,
  ...
)

\method{print}{theil}(x, scale = 100, digits = 3, ...)

\method{print}{theil_list}(x, scale = 100, digits = 3, ...)
}
\arguments{
\item{x}{An object of class \verb{thiel' or }theil_list\verb{, as returned by calling }theil\verb{on a list of fitted}surveil` models}

\item{style}{If \code{style = "mean_qi"}, then the posterior mean and 95 percent credible interval will be plotted; if \code{style = "lines"}, then \code{M} samples from the joint probability distribution will be plotted.}

\item{M}{If \code{style = "lines"}, then \code{M} is the number of samples from the posterior distribution that will be plotted; the default is \code{M = 250}.}

\item{col}{Line color}

\item{fill}{Fill color}

\item{alpha}{For \code{style = "mean_qi"}, this controls the transparency for the credible interval (passed to \code{\link[ggplot2]{geom_ribbon}}) and defaults to \code{alpha = 0.5}; for \code{style = "lines"}, this controls the transparency of the lines and defaults to \code{alpha = 0.7}.}

\item{lwd}{Line width; for \code{style = "mean_qi"}, the default is \code{lwd = 1}; for \code{style = "lines"}, the default is \code{lwd = 0.05}.}

\item{base_size}{Passed to \code{theme_classic} to control size of plot elements (e.g., text)}

\item{scale}{Scale Theil's index by \code{scale}}

\item{labels}{x-axis labels (time periods)}

\item{...}{additional arguments}

\item{between_title}{Plot title for the between geography component of Theil's T; defaults to "Between".}

\item{within_title}{Plot title for the within geography component of Theil's T; defaults to "Within".}

\item{total_title}{Plot title for Theil's index; defaults to "Total".}

\item{plot}{If \code{FALSE}, return a list of \code{ggplot}s. Not used when \code{style = "lines"}.}

\item{ncol}{Number of columns for the plotting device. If \code{ncol = 1}, the three plots will be aligned vertically in one column; if \code{ncol = 3} they will b aligned horizontally in one row.}

\item{digits}{number of digits to print (passed to \code{\link[base]{print.data.frame}})}
}
\value{
\subsection{plot.theil}{

The plot method returns an object of class \code{ggplot}.
}

\subsection{plot.theil_list}{

If \code{style = "lines"}, the plot method for \code{theil_list} objects returns a \code{ggplot} with facets for each component of inequality (between-areas, within-areas, and total). For \code{style = "mean_qi"}, the plot method returns either a list of plots (all of class \code{ggplot}) or, when \code{plot = TRUE}, it will draw them to current plotting device using \code{\link[gridExtra]{grid.arrange}}.
}

\subsection{print.theil}{

The print returns nothing and method prints a summary of results to the R console.
}
}
\description{
Printing and plotting methods for Theil's inequality index
}
\seealso{
\code{\link[surveil]{theil}}
}
