% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{surv_brierscore}
\alias{surv_brierscore}
\title{Calculates time-dependent Brier Score}
\usage{
surv_brierscore(
  y_predicted_newdata,
  df_brier_train,
  df_newdata,
  time_point,
  weighted = TRUE
)
}
\arguments{
\item{y_predicted_newdata}{computed event probabilities (! not survival probabilities)}

\item{df_brier_train}{train data}

\item{df_newdata}{test data for which brier score is computed}

\item{time_point}{times at which BS calculated}

\item{weighted}{TRUE/FALSE for IPWC to use or not}
}
\value{
vector of time-dependent Brier Scores for all time_point
}
\description{
Calculates time-dependent Brier Scores for a vector of times. Calculations are similar to that in:
https://scikit-survival.readthedocs.io/en/stable/api/generated/sksurv.metrics.brier_score.html#sksurv.metrics.brier_score
https://github.com/sebp/scikit-survival/blob/v0.19.0.post1/sksurv/metrics.py#L524-L644
The function uses IPCW (inverse probability of censoring weights), computed using the Kaplan-Meier
survival function, where events are censored events from train data
}
