% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{Hess_rho}
\alias{Hess_rho}
\title{Hessian matrix of LCV and LAML wrt rho (log smoothing parameters)}
\usage{
Hess_rho(
  X_GL,
  X_GL_Q,
  GL_temp,
  haz_GL,
  deriv2_rho_beta,
  deriv_rho_beta,
  weights,
  tm,
  nb_smooth,
  p,
  n_legendre,
  deriv_rho_inv_Hess_beta,
  deriv_rho_Hess_unpen_beta,
  S_list,
  minus_eigen_inv_Hess_beta,
  temp_LAML,
  temp_LAML2,
  Vp,
  S_beta,
  beta,
  inverse_new_S,
  X,
  X_Q,
  temp_deriv3,
  temp_deriv4,
  event,
  expected,
  type,
  Ve,
  deriv_rho_Ve,
  mat_temp,
  deriv_mat_temp,
  eigen_mat_temp,
  method
)
}
\arguments{
\item{X_GL}{list of matrices (\code{length(X.GL)=n.legendre}) for Gauss-Legendre quadrature}

\item{X_GL_Q}{list of transformed matrices from X_GL in order to calculate only the diagonal of the fourth derivative of the likelihood}

\item{GL_temp}{list of vectors used to make intermediate calculations and save computation time}

\item{haz_GL}{list of all the matrix-vector multiplications X.GL[[i]]\%*\%beta for Gauss Legendre integration in order to save computation time}

\item{deriv2_rho_beta}{second derivatives of beta wrt rho (implicit differentiation)}

\item{deriv_rho_beta}{firt derivatives of beta wrt rho (implicit differentiation)}

\item{weights}{vector of weights for Gauss-Legendre integration on [-1;1]}

\item{tm}{vector of midpoints times for Gauss-Legendre integration; tm = 0.5*(t1 - t0)}

\item{nb_smooth}{number of smoothing parameters}

\item{p}{number of regression parameters}

\item{n_legendre}{number of nodes for Gauss-Legendre quadrature}

\item{deriv_rho_inv_Hess_beta}{list of first derivatives of Vp wrt rho}

\item{deriv_rho_Hess_unpen_beta}{list of first derivatives of Hessian of unpenalized log likelihood wrt rho}

\item{S_list}{List of all the rescaled penalty matrices multiplied by their associated smoothing parameters}

\item{minus_eigen_inv_Hess_beta}{vector of eigenvalues of Vp}

\item{temp_LAML}{temporary matrix used when method="LAML" to save computation time}

\item{temp_LAML2}{temporary matrix used when method="LAML" to save computation time}

\item{Vp}{Bayesian covariance matrix}

\item{S_beta}{List such that S_beta[[i]]=S_list[[i]]\%*\%beta}

\item{beta}{vector of estimated regression parameters}

\item{inverse_new_S}{inverse of the penalty matrix}

\item{X}{design matrix for the model}

\item{X_Q}{transformed design matrix in order to calculate only the diagonal of the fourth derivative of the likelihood}

\item{temp_deriv3}{temporary matrix for third derivatives calculation when type="net" to save computation time}

\item{temp_deriv4}{temporary matrix for fourth derivatives calculation when type="net" to save computation time}

\item{event}{vector of right-censoring indicators}

\item{expected}{vector of expected hazard rates}

\item{type}{"net" or "overall"}

\item{Ve}{frequentist covariance matrix}

\item{deriv_rho_Ve}{list of derivatives of Ve wrt rho}

\item{mat_temp}{temporary matrix used when method="LCV" to save computation time}

\item{deriv_mat_temp}{list of derivatives of mat_temp wrt rho}

\item{eigen_mat_temp}{vector of eigenvalues of mat_temp}

\item{method}{criterion used to select the smoothing parameters. Should be "LAML" or "LCV"; default is "LAML"}
}
\value{
Hessian matrix of LCV or LAML wrt rho
}
\description{
Hessian matrix of LCV and LAML wrt rho (log smoothing parameters)
}
