% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\docType{data}
\name{jackolantern_surreal_data}
\alias{jackolantern_surreal_data}
\title{Jack-o'-Lantern Surreal Data}
\format{
A data frame with 5,395 observations and 7 variables.
\itemize{
\item \code{y}: Response variable
\item \code{x1}: Predictor variable 1
\item \code{x2}: Predictor variable 2
\item \code{x3}: Predictor variable 3
\item \code{x4}: Predictor variable 4
\item \code{x5}: Predictor variable 5
\item \code{x6}: Predictor variable 6
}
}
\usage{
jackolantern_surreal_data
}
\description{
Data set containing a hidden image of a Jack-o'-Lantern lurking
in the residual plot of a full model being fit.
}
\examples{
# Load the Jack-o'-Lantern data
data <- jackolantern_surreal_data

# Fit a linear model to the surreal Jack-o'-Lantern data
model <- lm(y ~ ., data = data)

# Plot the residuals to reveal the hidden image
plot(model$fitted, model$resid, type = "n", main = "Residual plot from transformed data")
points(model$fitted, model$resid, pch = 16)
}
\references{
Stefansk, L.A. (2013). Hidden Images in the Helen Barton Lecture Series. Retrieved from
\url{https://www4.stat.ncsu.edu/~stefansk/NSF_Supported/Hidden_Images/UNCG_Helen_Barton_Lecture_Nov_2013/pumpkin_1_data_yx1x6.txt}
}
\keyword{datasets}
