% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ShroutFleissICC1k.R
\name{ShroutFleissICC1}
\alias{ShroutFleissICC1}
\alias{ShroutFleissICC11}
\alias{ShroutFleissICC1k}
\title{Shrout and Fleiss intra-class correlation functions}
\usage{
ShroutFleissICC1(dta, clustercol, cols)
}
\arguments{
\item{dta}{A data frame containing within-subject measures, one participant per line;}

\item{clustercol}{is the column index where cluster belonging are given;}

\item{cols}{A vector indicating the columns containing the measures.}
}
\value{
ICC the intra-class measure of association.
}
\description{
The functions ShroutFleissICC1, ShroutFleissICC11
and ShroutFleissICC1k computes the intra-class correlation ICC
for a given data frame containing repeated measures in columns cols
when the measures are in distinct clusters, identified in column clustercol.
See \insertCite{sf79}{superb}.
}
\examples{
# creates a small data frames with 4 subject's scores for 5 measures:
dta <- data.frame(cbind(
        clus <- c(1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3),
        col1 <- c(2, 4, 4, 6, 4, 5, 8, 8, 5, 8, 9, 9)
    ))

ShroutFleissICC1(dta, 1, 2)
# 0.434343434 
ShroutFleissICC11(dta[, 1], dta[,2])
# 0.434343434 

dta2 <- data.frame(cbind(
        clus <- c(1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3),
        col1 <- c(1, 3, 3, 5, 3, 4, 7, 7, 4, 7, 8, 8),
        col1 <- c(2, 4, 4, 6, 4, 5, 8, 8, 5, 8, 9, 9),
        col1 <- c(3, 5, 5, 7, 5, 6, 9, 9, 6, 9, 10, 10)
    ))
 
ShroutFleissICC1(dta2, 1, 2:4)
# 0.7543859649 
ShroutFleissICC1k(dta2[, 1], dta2[,2:4])
# 0.7543859649 
  
}
\references{
\insertAllCited{}

\insertAllCited{}
}
