% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mean_group_tbl.R
\name{mean_group_tbl}
\alias{mean_group_tbl}
\title{Summarize continuous variables by group}
\usage{
mean_group_tbl(
  data,
  var_stem,
  group,
  escape_stem = FALSE,
  ignore_stem_case = FALSE,
  group_type = "variable",
  group_name = NULL,
  escape_group = FALSE,
  ignore_group_case = FALSE,
  remove_group_non_alnum = TRUE,
  na_removal = "listwise",
  only = NULL,
  var_labels = NULL,
  ignore = NULL
)
}
\arguments{
\item{data}{A data frame.}

\item{var_stem}{A character string of a variable stem or the full name of a variable in
\code{data}.}

\item{group}{A character string of a variable in \code{data} or a pattern to use to search for
variables in \code{data}.}

\item{escape_stem}{A logical value indicating whether to escape \code{var_stem}. Default is
\code{FALSE}.}

\item{ignore_stem_case}{A logical value indicating whether the search for columns matching
the supplied \code{var_stem} is case-insensitive. Default is \code{FALSE}.}

\item{group_type}{A character string that defines the type of grouping variable. Should be
one of \code{pattern} or \code{variable}. Default is \code{variable}, in which case the variable matching the
\code{group} string will be searched for within \code{data}.}

\item{group_name}{A character string piped to the final table to replace the name of \code{group}.}

\item{escape_group}{A logical value indicating whether to escape string supplied to \code{group}.}

\item{ignore_group_case}{A logical value indicating whether \code{group} is case-insensitive.
Default is \code{FALSE}.}

\item{remove_group_non_alnum}{A logical value indicating whether to remove all non-
alphanumeric characters (anything that is not a letter or number) from \code{group}. Default
is \code{TRUE}.}

\item{na_removal}{A character string specifying how to remove missing values. Should be
one of \code{pairwise} or \code{listwise}. Default is \code{listwise}.}

\item{only}{A character string or vector of character strings of the types of
summary data to return. Default is \code{NULL}, which returns mean (mean), standard
deviation (sd), minimum value (min), maximum value (max), and non-missing responses
(nobs).}

\item{var_labels}{An optional named character vector or list where each element maps
labels to variable names. If any element is unnamed or if any labels do not match
variables in returned from \code{data}, all labels will be ignored and the table will be
printed without them.}

\item{ignore}{An optional named vector or list specifying values to exclude from the
dataset and analysis. By default, \code{NULL} includes all available values. To omit values
from variables returned by \code{var_stem}, use the provided stem as the name. To exclude
values from both \code{var_stem} variables and a grouping variable in \code{data}, supply a list.}
}
\value{
A tibble presenting summary statistics (e.g., mean, standard deviation, minimum
value, maximum, number of non-missing observations) for a set of variables sharing the same
variable stem. The results are grouped by either a grouping variable in the data or by a
pattern matched with variable names.
}
\description{
\code{mean_group_tbl()} presents descriptive statistics (mean, sd, minimum,
maximum, number of non-missing observations) for interval (e.g., Test scores) and
ratio level (e.g., Age) variables with the same variable stem by some grouping variable.
A variable stem is a common prefix found in related variable names, often corresponding
to similar survey items, that represents a shared concept before unique identifiers (like
time points) are added. For example, in the \code{stem_social_psych} dataset, the two variables
'belong_belongStem_w1' and 'belong_belongStem_w2' share the variable stem 'belong_belongStem'
(e.g., "I feel like an outsider in STEM"), with suffixes (_w1, _w2) indicating different
measurement waves. By default, missing data are excluded from the calculations in a listwise
fashion.
}
\examples{
mean_group_tbl(data = stem_social_psych,
               var_stem = "belong_welcomedStem",
               group = "_w\\\\d",
               group_type = "pattern",
               na_removal = "pairwise",
               var_labels = c(belong_welcomedStem_w1 = "I feel welcomed in STEM workplaces",
                              belong_welcomedStem_w2 = "I feel welcomed in STEM workplaces"),
               group_name = "wave")

mean_group_tbl(data = social_psy_data,
               var_stem = "belong",
               group = "gender",
               group_type = "variable",
               na_removal = "pairwise",
               var_labels = c(belong_1 = "I feel like I belong at this institution",
                              belong_2 = "I  feel like part of the community",
                              belong_3 = "I feel valued by this institution"),
               group_name = "gender_identity")

grouped_data <-
  data.frame(
    symptoms.t1 = sample(c(1:5, -999), replace = TRUE, size = 50),
    symptoms.t2 = sample(c(NA, 1:5, -999), replace = TRUE, size = 50)
  )

mean_group_tbl(data = grouped_data,
               var_stem = "symptoms",
               group = ".t\\\\d",
               group_type = "pattern",
               escape_group = TRUE,
               na_removal = "listwise",
               ignore = c(symptoms = -999))
               
}
\author{
Ama Nyame-Mensah
}
