% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_shape.R
\name{read_shape}
\alias{read_shape}
\title{Read in the shape file as sf object}
\usage{
read_shape(shp_path, simplify = TRUE, keep = 0.1)
}
\arguments{
\item{shp_path}{character vector location of shape file, extension .shp}

\item{simplify}{a boolean to decide whether to simplify the shape file
using rmapshaper, keeping all shapes.}

\item{keep}{ratio of points to keep}
}
\value{
an sf data frame, with a column of non null geometries
}
\description{
read_shape
}
\examples{
\dontrun{
# Download resource from sugarbag site
# https://srkobakian.github.io/sugarbag/articles/abs-data.html
# Find the location of extracted shape data
shape <- read_shape(shp_path = file.choose())
}

}
