% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sudokuAlt.R
\name{regulariseGame}
\alias{regulariseGame}
\alias{regulariseGame.sudoku}
\alias{regulariseGame.default}
\title{regulariseGame}
\usage{
regulariseGame(g, ...)

\method{regulariseGame}{sudoku}(g, target = c("block", "col", "row"),
  ...)

\method{regulariseGame}{default}(g, ...)
}
\arguments{
\item{g}{a solved sudoku game}

\item{...}{additional arguments to methods (currently not used)}

\item{target}{character; which section do you want to be in sorted order?}
}
\value{
a regularised solved sudoku game
}
\description{
Put a solved sudoku game into a canonical form
}
\details{
If a solved sudoku game is to be used as an experimental
design it is sometimes useful to re-arrange the symbols
so that either the first row, first column or top left
block symbols are in sorted order.  This function accomplishes
this task.
}
\examples{
set.seed(1234)
g <- makeGame() \%>\%
     solve() \%>\%    
     regulariseGame(target = "b") \%>\% 
     plot()
plot(originalGame(g))
}
