% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arrival_rate.R
\name{arrival_rate}
\alias{arrival_rate}
\title{Estimate arrival rate of a Poisson points process}
\usage{
arrival_rate(data)
}
\arguments{
\item{data}{A \code{data.frame} containing the following named column for each subject:
\describe{
\item{\code{entrytime}:}{time of entry into study (numeric);}
} If the \code{data.frame} also contains a column named \code{unit}, the arrival
rate will be determined for each unit separately.}
}
\value{
A (named) vector containing the estimated arrival rate in the data,
or for each unit in the data.
}
\description{
In a Poisson point process, subjects arrive with exponentially
distributed inter-arrival times with rate \eqn{\psi}{\psi}. This function
can be used to estimate the parameter \eqn{\psi}{\psi}.
}
\examples{
arrival_rate(surgerydat)


}
\author{
Daniel Gomon
}
