% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stylest_select_vocab.R
\name{stylest_select_vocab}
\alias{stylest_select_vocab}
\title{Select vocabulary using cross-validated out-of-sample prediction}
\usage{
stylest_select_vocab(x, speaker, filter = NULL, smooth = 0.5,
  nfold = 5, cutoff_pcts = c(50, 60, 70, 80, 90, 99))
}
\arguments{
\item{x}{Corpus as text vector. May be a \code{corpus_frame} object}

\item{speaker}{Vector of speaker labels. Should be the same length as
\code{x}}

\item{filter}{if not \code{NULL}, a \code{corpus} text_filter}

\item{smooth}{value for smoothing. Defaults to 0.5}

\item{nfold}{Number of folds for cross-validation. Defaults to 5}

\item{cutoff_pcts}{Vector of cutoff percentages to test. Defaults to
\code{c(50, 60, 70, 80, 90, 99)}}
}
\value{
List of: best cutoff percent with the best speaker classification
  rate; cutoff percentages that were tested; matrix of the mean percentage of
  incorrectly identified speakers for each cutoff percent and fold; and the
  number of folds for cross-validation
}
\description{
Selects optimal vocabulary quantile(s) for model fitting using performance on
predicting out-of-sampletexts.
}
\examples{
\dontrun{
data(novels_excerpts)
stylest_select_vocab(novels_excerpts$text, novels_excerpts$author, cutoff_pcts = c(50, 90))
}
  
}
