% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculateStatistics_gui.r
\name{calculateStatistics_gui}
\alias{calculateStatistics_gui}
\title{Calculate Statistics}
\usage{
calculateStatistics_gui(
  data = NULL,
  target = NULL,
  quant = 0.95,
  group = NULL,
  count = NULL,
  env = parent.frame(),
  savegui = NULL,
  debug = FALSE,
  parent = NULL
)
}
\arguments{
\item{data}{character preselected data.frame if provided and exist in environment.}

\item{target}{character vector preselected target column.}

\item{quant}{numeric quantile to calculate. Default=0.95.}

\item{group}{character vector preselected column(s) to group by.}

\item{count}{character vector preselected column to count unique values in.}

\item{env}{environment in which to search for data frames and save result.}

\item{savegui}{logical indicating if GUI settings should be saved in the environment.}

\item{debug}{logical indicating printing debug information.}

\item{parent}{widget to get focus when finished.}
}
\value{
TRUE
}
\description{
GUI wrapper for the \code{\link{calculateStatistics}} function.
}
\details{
Simplifies the use of the \code{\link{calculateStatistics}} function
by providing a graphical user interface. Preselected values can be provided
as arguments.
}
\seealso{
\code{link{quantile}}, \code{link{min}}, \code{link{max}}, \code{link{mean}}, \code{link{sd}}
}
